/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.reporting;

import java.io.InputStream;
import java.util.Map;

/**
 * Defines the common state and behavior of all IDIFReport implementations.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/12/19
 */
public abstract class AbstractDIFReport implements IReport
{

    /** The report export format. */
    private ReportExportFormat exportFormat;

    /**
     *
     */
    private Map<String, Object> parameters = null;

    /** The report template */
    private InputStream templateInputStream;

    /** The report template */
    private String templatePath;

    /**
     * @see pt.digitalis.utils.reporting.IReport#getExportFormat()
     */
    public ReportExportFormat getExportFormat()
    {
        return this.exportFormat;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#setExportFormat(pt.digitalis.utils.reporting.ReportExportFormat)
     */
    public void setExportFormat(ReportExportFormat exportFormat)
    {
        this.exportFormat = exportFormat;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#getParameters()
     */
    public Map<String, Object> getParameters()
    {
        return this.parameters;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#setParameters(java.util.Map)
     */
    public void setParameters(Map<String, Object> parameters)
    {
        this.parameters = parameters;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#getTemplateInputStream()
     */
    public InputStream getTemplateInputStream()
    {
        return templateInputStream;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#setTemplateInputStream(java.io.InputStream)
     */
    public void setTemplateInputStream(InputStream templateInputStream)
    {
        this.templateInputStream = templateInputStream;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#getTemplatePath()
     */
    public String getTemplatePath()
    {
        return this.templatePath;
    }

    /**
     * @see pt.digitalis.utils.reporting.IReport#setTemplatePath(java.lang.String)
     */
    public void setTemplatePath(String templatePath)
    {
        this.templatePath = templatePath;
    }
}
