/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.reporting;

/**
 * Defines the available export formats.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/12/10
 */
public enum ReportExportFormat
{

    /** The .html file format. */
    HTML,
    /** The .pdf file format. */
    PDF,
    /** The .xls file format. */
    XLS,
    /** The .xml file format. */
    XML;

    /**
     * Converts a given value passed as a String type to the corresponding ReportExportFormat type.
     *
     * @param exportFormatAsString the source value to convert from
     *
     * @return the converted value
     */
    static public ReportExportFormat getReportExportFormatFromString(String exportFormatAsString)
    {
        exportFormatAsString = exportFormatAsString.toLowerCase();

        if ("pdf".equals(exportFormatAsString))
            return PDF;
        else if ("html".equals(exportFormatAsString))
            return HTML;
        else if ("xls".equals(exportFormatAsString))
            return XLS;
        else if ("xml".equals(exportFormatAsString))
            return XML;
        else
            return null;
    }

    /**
     * Returns the file extension associated to the export format.
     *
     * @return the file extension for the selected export format.
     */
    public String getFileExtension()
    {
        if (this.equals(PDF))
            return ".pdf";
        else if (this.equals(HTML))
            return ".html";
        else if (this.equals(XLS))
            return ".xls";
        else if (this.equals(XML))
            return ".xml";
        else
            return null;
    }
}
