/**
 *
 */
package pt.digitalis.utils.reporting.impl.jasperreports.bean;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import pt.digitalis.utils.reporting.IDataSourceField;
import pt.digitalis.utils.reporting.IReportDataSource;
import pt.digitalis.utils.reporting.exception.ReportingException;

import java.util.Collection;

/**
 * @author Antnio Silva <a href="mailto:asilva@digitalis.pt">asilva@digitalis.pt</a>
 * @created 2009/03/27
 */
public class BeanCollectionDataSourceJasperImpl extends JRBeanCollectionDataSource implements IReportDataSource
{

    /**
     * creates a datasource base on a collection
     *
     * @param beanCollection
     *            the collection to build the datasource
     */
    public BeanCollectionDataSourceJasperImpl(Collection<?> beanCollection)
    {
        super(beanCollection);
    }

    /**
     * @see pt.digitalis.utils.reporting.IReportDataSource#getFieldValue(pt.digitalis.utils.reporting.IDataSourceField)
     */
    public Object getFieldValue(IDataSourceField field) throws ReportingException
    {
        Object result = null;

        try
        {
            result = super.getFieldValue((JRField) field);
        }
        catch (JRException exception)
        {
            throw new ReportingException("Couldn't get value for data field " + super.toString());
        }

        return result;
    }
}
