/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.reporting.impl.jasperreports.xml;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import pt.digitalis.utils.reporting.IDataSourceField;
import pt.digitalis.utils.reporting.IReportDataSource;
import pt.digitalis.utils.reporting.exception.ReportingException;

/**
 * Jasper Reports XML data source implementation.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/12/11
 */
public class XMLReportDataSourceJasperImpl extends JRXmlDataSource implements IReportDataSource
{

    /**
     * Builds a new XML data source from a given URI.
     *
     * @param uri the XML data document URI
     *
     * @exception JRException if the data source can't be built
     */
    public XMLReportDataSourceJasperImpl(String uri) throws JRException
    {
        super(uri);
    }

    /**
     * Builds a new XML data source from a given URI and query.
     *
     * @param uri   the XML data document URI
     * @param query the XPath query
     *
     * @exception JRException if the data source can't be built
     */
    public XMLReportDataSourceJasperImpl(String uri, String query) throws JRException
    {
        super(uri, query);
    }

    /**
     * @see pt.digitalis.utils.reporting.IReportDataSource#getFieldValue(pt.digitalis.utils.reporting.IDataSourceField)
     */
    public Object getFieldValue(IDataSourceField field) throws ReportingException
    {

        Object result = null;

        try
        {
            result = super.getFieldValue((JRField) field);
        }
        catch (JRException exception)
        {
            throw new ReportingException("Couldn't get value for data field " + super.toString());
        }

        return result;
    }
}
