/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.ioc;

/**
 * IoC Utils allows the use of different IoC implementations. This enumerated type defines which are available.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Oct 2, 2007
 */
public enum IoCImplementations {

    /** Google Guice IoC framework implementation. */
    GUICE;

    /**
     * Returns the IoC implementation from a given name.
     * 
     * @param name
     *            name of the IoC
     * @return the implementation for the given name
     */
    static public IoCImplementations getImplementationByName(String name)
    {
        /*
         * Implementation Note: if other IoC implementations are supported the method must be rewritten to cope with the
         * new implementations. Using: return IoCImplementations.valueOf(name); ...won't do the job since the valueOf
         * method throws an IllegalArgumentException if a non-existent enum value is passed as an argument.
         */

        return GUICE;
    }
}
