/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.ioc.guice;

import java.lang.annotation.Annotation;

import com.google.inject.name.Named;

/**
 * An ID annotation to identify several implementation contributions of IoC services
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Oct 9, 2007
 */
@SuppressWarnings("all")
public class ID implements Named {

    /** The value for the ID */
    final String value;

    /**
     * Constructor.
     * 
     * @param value
     *            the ID
     */
    public ID(String value)
    {
        this.value = value;
    }

    /**
     * @see com.google.inject.name.Named#value()
     */
    public String value()
    {
        return this.value;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        // This is specified in java.lang.Annotation.
        return 127 * "value".hashCode() ^ value.hashCode();
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object o)
    {
        if (!(o instanceof Named))
            return false;
        Named other = (Named) o;
        return value.equals(other.value());
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "@" + Named.class.getName() + "(value=" + value + ")";
    }

    /**
     * @see java.lang.annotation.Annotation#annotationType()
     */
    public Class<? extends Annotation> annotationType()
    {
        return Named.class;
    }
}
