/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.ioc.modules;

/**
 * Defines the expected behavior for an IoC binding. Uses the 'Fluent Interface' idiom to provide context relaying to
 * subsequent calls.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/05/09
 */
public interface IIoCBinding {

    /**
     * Returns the current binding as final.
     * 
     * @return the updated binding object
     */
    public IIoCBinding asFinal();

    /**
     * Returns the current binding as overriding a previous bind to the same interface.
     * 
     * @return the updated binding object
     */
    public IIoCBinding override();

    /**
     * Returns the current binding as singleton.
     * 
     * @return the updated binding object
     */
    public IIoCBinding asSingleton();

    /**
     * Returns the current binding with the given id.
     * 
     * @param id
     *            the binding's id
     * @return the updated binding object
     */
    public IIoCBinding withId(String id);
}
