/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.ioc;

/**
 * The IoC module parsing modes.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Oct 17, 2007
 */
public enum ModuleParser
{

    /** Uses the classPath getSystemResources() for fast detection. */
    FAST,
    /** Searches all classPath entries in the file system, opening up directories and ZIP files. */
    CRAWLER,
    /**
     * When all else fails, combines the previous methods for complete discovery. For ClassLoader nightmare solving, but
     * slow.
     */
    PARANOID;

    /**
     * Returns the parsing method of a given name.
     *
     * @param name selected method name
     *
     * @return the Module Parsing method for the given name
     */
    static public ModuleParser getParsingMethodByName(String name)
    {
        if (name.equalsIgnoreCase(CRAWLER.toString()))
            return CRAWLER;
        if (name.equalsIgnoreCase(PARANOID.toString()))
            return PARANOID;

        return FAST;
    }
}
