/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.utils.ioc.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import pt.digitalis.utils.ioc.modules.IoCBinding;
import pt.digitalis.utils.ioc.modules.IoCBindingManager;

import java.util.List;

/**
 * A module aggregator is an entity that converts the IoC bindings to the particular IoC technology used. It is also
 * responsible to invoke the binding methods on the underlying IoC technology.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created May 8, 2008
 */
public class ModuleAggregator implements Module
{

    /**
     * @see com.google.inject.Module#configure(com.google.inject.Binder)
     */
    @SuppressWarnings("unchecked")
    public void configure(Binder guiceBinder)
    {

        // For each interface...
        for (Class<?> interfaceType : IoCBindingManager.getInstance().getBindings().keySet())
        {

            // ...get the bindings list for each interface
            List<IoCBinding> bindings = IoCBindingManager.getInstance().getBindings(interfaceType);

            // For each binding...
            for (IoCBinding binding : bindings)
            {

                // Generate a binding builder
                @SuppressWarnings("rawtypes")
                LinkedBindingBuilder linkedBindingBuilder = guiceBinder.bind(binding.getInterfaceType());

                // If id is supplied notify Guice
                if (binding.getId() != null)
                    ((AnnotatedBindingBuilder<?>) linkedBindingBuilder).annotatedWith(new ID(binding.getId()));

                // Bind the implementation to the interface
                ScopedBindingBuilder scopedBindingBuilder = linkedBindingBuilder.to(binding.getImplementationType());

                // Set binding scope
                if (binding.isSingleton())
                    scopedBindingBuilder.in(Scopes.SINGLETON);
            }
        }
    }
}
