/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.utils.ioc.modules;

/**
 * Defines an IoCModule behavior. As dynamic it's only difference as opposed to the {@link IIoCModule} is that it will
 * be ran after all {@link IIoCModule} have been processed. For late bindings that need the content of all other
 * bindings to be defined.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 4 de Fev de 2011
 */
public interface IIoCDynamicModule extends IIoCModule
{

    /**
     * Configuration method for declaring all module bindings.
     *
     * @param binder the binder
     */
    public void configure(IoCBinder binder);
}