/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.utils.ioc.modules;

import java.util.HashMap;
import java.util.Map;

/**
 * Defines a binding point between interfaces and implementations.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created May 2, 2008
 */
public class IoCBinder
{

    /** Temporary module bindings map. */
    private Map<Class<?>, IoCBinding> moduleBindings = new HashMap<Class<?>, IoCBinding>();

    /** Add the temporary bindings list to the manager. */
    public void addBindingsToManager()
    {
        // Add bindings to the manager and make the binding eligible for GC
        for (IoCBinding binding : moduleBindings.values())
        {
            binding.deleteBinderReference();
            IoCBindingManager.getInstance().addBinding(binding);
        }
    }

    /**
     * Binds an implementation type to an interface type.
     *
     * @param interfaceType      the interface type
     * @param implementationType the implementation type
     *
     * @return the binding object
     */
    public IoCBinding bind(Class<?> interfaceType, Class<?> implementationType)
    {

        // Create new binding
        IoCBinding binding = new IoCBinding(interfaceType, implementationType, this);

        // Add the binding to the temporary module bindings map
        updateBinding(binding);

        // Return the binding
        return binding;
    }

    /**
     * Installs a new module.
     *
     * @param module the new module to install
     */
    public void install(IIoCModule module)
    {
        IoCBindingManager.getInstance().addModuleBindings(module);
    }

    /**
     * Updates the binding entry on the temporary module bindings map.
     *
     * @param binding the binding to update
     */
    public void updateBinding(IoCBinding binding)
    {
        this.moduleBindings.put(binding.getImplementationType(), binding);
    }
}
