package pt.digitalis.utils.chart;

import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.util.ShapeUtilities;

/**
 * This chart customizer applies default custom properties. Like removing the chart border
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 05/10/2015
 */
public class DefaultProps implements JRChartCustomizer
{

    /**
     *
     */
    private static Log log = LogFactory.getLog(DefaultProps.class);

    /**
     *
     */
    public DefaultProps()
    {
        // TODO Auto-generated constructor stub
    }

    /**
     * @see net.sf.jasperreports.engine.JRChartCustomizer#customize(org.jfree.chart.JFreeChart,
     *         net.sf.jasperreports.engine.JRChart)
     */
    public void customize(JFreeChart chart, JRChart jasperChart)
    {
        log.debug("################## DEBUG info from DefaultProps ##################");

        // Remove border
        chart.setBorderVisible(false);

        // Set tick shapes
        Plot plot = chart.getPlot();

        if (plot instanceof XYPlot)
        {
            XYPlot xyPlot = (XYPlot) plot;
            xyPlot.getRenderer().setSeriesShape(0, ShapeUtilities.createDiagonalCross(1.5f, 0.2f));
        }
    }
}
