/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.utils.ldap;


/**
 * Top-level class for the LDAP object hierarchy. Defines common attributes to LDAP entities.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/04/10
 */
public class LDAPEntity {

    /** The 'distinguished name' attribute. */
    final static public String DISTINGUISHED_NAME = "distinguishedName";

    /** The 'common name' attribute. */
    final static public String COMMON_NAME = "cn";

    /** The 'name' attribute. */
    final static public String NAME = "name";

    /** The 'description' attribute. */
    final static public String DESCRIPTION = "description";

    /**
     * The DN for direct operations on the LDAP server. Filled only by the finders of the IdentityManager and usable
     * since from that point forward.
     */
    private String distinguishedName;

    /**
     * The entity's common name.
     */
    private String commonName;

    /**
     * The entity's name.
     */
    private String name;

    /**
     * The entity's description.
     */
    private String description;

    /**
     * The entity's parent group DN. The parent group is the group where the entity is located on creation.
     */
    private String parentGroupDN;

    /**
     * Inspector for the distinguished name.
     * 
     * @return the distinguishedName
     */
    public String getDistinguishedName() {
        return distinguishedName;
    }

    /**
     * Modifier for the distinguished name.
     * 
     * @param distinguishedName
     *            the distinguishedName to set
     */
    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    /**
     * Inspector for the common name.
     * 
     * @return the commonName
     */
    public String getCommonName() {
        return this.commonName;
    }

    /**
     * Modifier for the common name.
     * 
     * @param commonName
     *            the commonName to set
     */
    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    /**
     * Inspector for the name.
     * 
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Modifier for the name.
     * 
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Inspector for the 'description' attribute.
     * 
     * @return the description value
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Modifier for the 'description' attribute.
     * 
     * @param description
     *            the new description value to set
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Inspector for the 'parentGroupDN' attribute.
     * 
     * @return the user's main group DN
     */
    public String getParentGroupDN() {
        return this.parentGroupDN;
    }

    /**
     * Modifier for the 'parentGroupDN' attribute.
     * 
     * @param parentGroupDN
     *            the new main group name to set
     */
    public void setParentGroupDN(String parentGroupDN) {
        this.parentGroupDN = parentGroupDN;
    }
   
    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuffer ldapUser = new StringBuffer();

        if (this.getDistinguishedName() == null)
            ldapUser.append("DN= N/A\n");
        else
            ldapUser.append("DN=" + this.getDistinguishedName() + "\n");

        if (this.getCommonName() == null)
            ldapUser.append("CN= N/A\n");
        else
            ldapUser.append("CN=" + this.getCommonName() + "\n");

        if (this.getName() == null)
            ldapUser.append("name= N/A\n");
        else
            ldapUser.append("name=" + this.getName() + "\n");

        if (this.getParentGroupDN() == null)
            ldapUser.append("parentGroupDN= N/A\n");
        else
            ldapUser.append("parentGroupDN=" + this.getParentGroupDN() + "\n");

        return ldapUser.toString();
    }
}
