/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.ldap.exception;

/**
 * Thrown when a requested LDAP operation does not succeed.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/04/02
 */
public class LDAPOperationException extends Exception {

    /** The serial version ID. */
    private static final long serialVersionUID = -3223976845607101414L;

    /**
     * Constructs a new exception with a message.
     * 
     * @param message
     *            the exception message
     */
    public LDAPOperationException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new exception with a message and a cause.
     * 
     * @param message
     *            the exception message
     * @param cause
     *            the exception cause
     */
    public LDAPOperationException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Constructs a new exception with a cause.
     * 
     * @param cause
     *            the exception cause
     */
    public LDAPOperationException(Throwable cause)
    {
        super(cause);
    }
}
