/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.netqa.model.dao.auto.IAutoIntegrationsDAO;
import pt.digitalis.netqa.model.data.Integrations;
import pt.digitalis.netqa.model.netQAFactory;

public abstract class AutoIntegrationsDAOImpl
implements IAutoIntegrationsDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Integrations> getIntegrationsDataSet() {
        return new HibernateDataSet(Integrations.class, (IHibernateDAO)this, Integrations.getPKFieldListAsString());
    }

    public Session getSession() {
        return netQAFactory.getSession();
    }

    @Override
    public void persist(Integrations transientInstance) {
        this.logger.debug((Object)"persisting Integrations instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Integrations instance) {
        this.logger.debug((Object)"attaching dirty Integrations instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Integrations instance) {
        this.logger.debug((Object)"attaching clean Integrations instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Integrations persistentInstance) {
        this.logger.debug((Object)"deleting Integrations instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Integrations merge(Integrations detachedInstance) {
        this.logger.debug((Object)"merging Integrations instance");
        Integrations result = (Integrations)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Integrations findById(Long id) {
        this.logger.debug((Object)("getting Integrations instance with id: " + id));
        Integrations instance = (Integrations)this.getSession().get(Integrations.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Integrations> findAll() {
        List<Integrations> instances = new ArrayList();
        this.logger.debug((Object)"getting all Integrations instances");
        instances = this.getSession().createCriteria(Integrations.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Integrations> findByExample(Integrations instance) {
        this.logger.debug((Object)"finding Integrations instance by example");
        List results = this.getSession().createCriteria(Integrations.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Integrations> findByFieldParcial(Integrations.Fields field, String value) {
        this.logger.debug((Object)("finding Integrations instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Integrations.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Integrations> findByTitle(String title) {
        Integrations instance = new Integrations();
        instance.setTitle(title);
        return this.findByExample(instance);
    }

    @Override
    public List<Integrations> findByUrl(String url) {
        Integrations instance = new Integrations();
        instance.setUrl(url);
        return this.findByExample(instance);
    }

    @Override
    public List<Integrations> findByDescription(String description) {
        Integrations instance = new Integrations();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Integrations> findByOrderNumber(Long orderNumber) {
        Integrations instance = new Integrations();
        instance.setOrderNumber(orderNumber);
        return this.findByExample(instance);
    }

    @Override
    public List<Integrations> findByActive(boolean active) {
        Integrations instance = new Integrations();
        instance.setActive(active);
        return this.findByExample(instance);
    }
}

