/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.netqa.model.dao.auto.IAutoReportCategoryDAO;
import pt.digitalis.netqa.model.data.ReportCategory;
import pt.digitalis.netqa.model.netQAFactory;

public abstract class AutoReportCategoryDAOImpl
implements IAutoReportCategoryDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ReportCategory> getReportCategoryDataSet() {
        return new HibernateDataSet(ReportCategory.class, (IHibernateDAO)this, ReportCategory.getPKFieldListAsString());
    }

    public Session getSession() {
        return netQAFactory.getSession();
    }

    @Override
    public void persist(ReportCategory transientInstance) {
        this.logger.debug((Object)"persisting ReportCategory instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ReportCategory instance) {
        this.logger.debug((Object)"attaching dirty ReportCategory instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ReportCategory instance) {
        this.logger.debug((Object)"attaching clean ReportCategory instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ReportCategory persistentInstance) {
        this.logger.debug((Object)"deleting ReportCategory instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ReportCategory merge(ReportCategory detachedInstance) {
        this.logger.debug((Object)"merging ReportCategory instance");
        ReportCategory result = (ReportCategory)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ReportCategory findById(Long id) {
        this.logger.debug((Object)("getting ReportCategory instance with id: " + id));
        ReportCategory instance = (ReportCategory)this.getSession().get(ReportCategory.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ReportCategory> findAll() {
        List<ReportCategory> instances = new ArrayList();
        this.logger.debug((Object)"getting all ReportCategory instances");
        instances = this.getSession().createCriteria(ReportCategory.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ReportCategory> findByExample(ReportCategory instance) {
        this.logger.debug((Object)"finding ReportCategory instance by example");
        List results = this.getSession().createCriteria(ReportCategory.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ReportCategory> findByFieldParcial(ReportCategory.Fields field, String value) {
        this.logger.debug((Object)("finding ReportCategory instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ReportCategory.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ReportCategory> findByDescription(String description) {
        ReportCategory instance = new ReportCategory();
        instance.setDescription(description);
        return this.findByExample(instance);
    }
}

