/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.netqa.model.dao.auto.IAutoReportDAO;
import pt.digitalis.netqa.model.data.Report;
import pt.digitalis.netqa.model.netQAFactory;

public abstract class AutoReportDAOImpl
implements IAutoReportDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Report> getReportDataSet() {
        return new HibernateDataSet(Report.class, (IHibernateDAO)this, Report.getPKFieldListAsString());
    }

    public Session getSession() {
        return netQAFactory.getSession();
    }

    @Override
    public void persist(Report transientInstance) {
        this.logger.debug((Object)"persisting Report instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Report instance) {
        this.logger.debug((Object)"attaching dirty Report instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Report instance) {
        this.logger.debug((Object)"attaching clean Report instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Report persistentInstance) {
        this.logger.debug((Object)"deleting Report instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Report merge(Report detachedInstance) {
        this.logger.debug((Object)"merging Report instance");
        Report result = (Report)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Report findById(Long id) {
        this.logger.debug((Object)("getting Report instance with id: " + id));
        Report instance = (Report)this.getSession().get(Report.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Report> findAll() {
        List<Report> instances = new ArrayList();
        this.logger.debug((Object)"getting all Report instances");
        instances = this.getSession().createCriteria(Report.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Report> findByExample(Report instance) {
        this.logger.debug((Object)"finding Report instance by example");
        List results = this.getSession().createCriteria(Report.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Report> findByFieldParcial(Report.Fields field, String value) {
        this.logger.debug((Object)("finding Report instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Report.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Report> findByTitle(String title) {
        Report instance = new Report();
        instance.setTitle(title);
        return this.findByExample(instance);
    }

    @Override
    public List<Report> findByDescription(String description) {
        Report instance = new Report();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Report> findByDocumentId(Long documentId) {
        Report instance = new Report();
        instance.setDocumentId(documentId);
        return this.findByExample(instance);
    }

    @Override
    public List<Report> findByJasperReportId(Long jasperReportId) {
        Report instance = new Report();
        instance.setJasperReportId(jasperReportId);
        return this.findByExample(instance);
    }

    @Override
    public List<Report> findByVisible(boolean visible) {
        Report instance = new Report();
        instance.setVisible(visible);
        return this.findByExample(instance);
    }

    @Override
    public List<Report> findByRestrictAccessToGroups(String restrictAccessToGroups) {
        Report instance = new Report();
        instance.setRestrictAccessToGroups(restrictAccessToGroups);
        return this.findByExample(instance);
    }
}

