/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.netqa.model.dao.auto.IAutoUONodeDAO;
import pt.digitalis.netqa.model.data.UONode;
import pt.digitalis.netqa.model.netQAFactory;

public abstract class AutoUONodeDAOImpl
implements IAutoUONodeDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<UONode> getUONodeDataSet() {
        return new HibernateDataSet(UONode.class, (IHibernateDAO)this, UONode.getPKFieldListAsString());
    }

    public Session getSession() {
        return netQAFactory.getSession();
    }

    @Override
    public void persist(UONode transientInstance) {
        this.logger.debug((Object)"persisting UONode instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(UONode instance) {
        this.logger.debug((Object)"attaching dirty UONode instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(UONode instance) {
        this.logger.debug((Object)"attaching clean UONode instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(UONode persistentInstance) {
        this.logger.debug((Object)"deleting UONode instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public UONode merge(UONode detachedInstance) {
        this.logger.debug((Object)"merging UONode instance");
        UONode result = (UONode)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public UONode findById(Long id) {
        this.logger.debug((Object)("getting UONode instance with id: " + id));
        UONode instance = (UONode)this.getSession().get(UONode.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<UONode> findAll() {
        List<UONode> instances = new ArrayList();
        this.logger.debug((Object)"getting all UONode instances");
        instances = this.getSession().createCriteria(UONode.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<UONode> findByExample(UONode instance) {
        this.logger.debug((Object)"finding UONode instance by example");
        List results = this.getSession().createCriteria(UONode.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<UONode> findByFieldParcial(UONode.Fields field, String value) {
        this.logger.debug((Object)("finding UONode instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(UONode.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<UONode> findByKeyword(String keyword) {
        UONode instance = new UONode();
        instance.setKeyword(keyword);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByName(String name) {
        UONode instance = new UONode();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByUrl(String url) {
        UONode instance = new UONode();
        instance.setUrl(url);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByDescription(String description) {
        UONode instance = new UONode();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByLogoDocumentId(Long logoDocumentId) {
        UONode instance = new UONode();
        instance.setLogoDocumentId(logoDocumentId);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByVisible(boolean visible) {
        UONode instance = new UONode();
        instance.setVisible(visible);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByActive(boolean active) {
        UONode instance = new UONode();
        instance.setActive(active);
        return this.findByExample(instance);
    }

    @Override
    public List<UONode> findByPosition(Long position) {
        UONode instance = new UONode();
        instance.setPosition(position);
        return this.findByExample(instance);
    }
}

