/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigAlias;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigLOVValues;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

@ConfigID(value="netQA")
@ConfigSectionID(value="Config/General")
public class netQAConfigurations {
    private static netQAConfigurations configuration = null;
    public static final String MODE_NORMAL = "NORMAL";
    public static final String MODE_PLUS_MAIN = "PLUS_MAIN";
    public static final String MODE_PLUS_NODE = "PLUS_NODE";
    private Long calendarEndHour;
    private Long calendarStartHour;
    private String filtrarListasPorRegenciaModo;
    private Boolean forceProprietarySSOForNodes;
    private String indicadorLinha1_left;
    private String indicadorLinha1_left_title;
    private String indicadorLinha1_right;
    private String indicadorLinha1_right_title;
    private String indicadorLinha2_left;
    private String indicadorLinha2_left_title;
    private String indicadorLinha2_right;
    private String indicadorLinha2_right_title;
    private String indicadorLinha3_left;
    private String indicadorLinha3_left_title;
    private String indicadorLinha3_right;
    private String indicadorLinha3_right_title;
    private String mode;
    private Boolean multiInstituicoesAtivas;
    private String netQAPlusMainServerBaseURL;

    @ConfigIgnore
    public static netQAConfigurations getInstance() throws ConfigurationException {
        if (configuration == null) {
            configuration = (netQAConfigurations)((IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)).readConfiguration(netQAConfigurations.class);
        }
        return configuration;
    }

    @ConfigDefault(value="22")
    public Long getCalendarEndHour() {
        return this.calendarEndHour;
    }

    @ConfigDefault(value="8")
    public Long getCalendarStartHour() {
        return this.calendarStartHour;
    }

    @ConfigLOVValues(value="1=Sem filtro,2=Filtrar sempre")
    @ConfigDefault(value="2")
    public String getFiltrarListasPorRegenciaModo() {
        return this.filtrarListasPorRegenciaModo;
    }

    @ConfigAlias(name="netPA proprietary SSO when accessing nodes", description="If you wish to have Single-Sign-On between central and its notes in netPA+ configuration and you have no Central Authentication service, you can activate netQA SSO Proprietary method. This method still requires that the same user with the same password exists in all netQA nodes including the central one. SSL comunication if of course highly recomended!")
    @ConfigDefault(value="false")
    public Boolean getForceProprietarySSOForNodes() {
        return this.forceProprietarySSOForNodes;
    }

    @ConfigDefault(value="alunos:ALU.02.01.03")
    public String getIndicadorLinha1_left() {
        return this.indicadorLinha1_left;
    }

    public String getIndicadorLinha1_left_title() {
        return this.indicadorLinha1_left_title;
    }

    @ConfigDefault(value="alunos:ALU.01.01.02")
    public String getIndicadorLinha1_right() {
        return this.indicadorLinha1_right;
    }

    public String getIndicadorLinha1_right_title() {
        return this.indicadorLinha1_right_title;
    }

    @ConfigDefault(value="alunos:ALU.02.01.05")
    public String getIndicadorLinha2_left() {
        return this.indicadorLinha2_left;
    }

    public String getIndicadorLinha2_left_title() {
        return this.indicadorLinha2_left_title;
    }

    @ConfigDefault(value="alunos:ALU.01.01.04")
    public String getIndicadorLinha2_right() {
        return this.indicadorLinha2_right;
    }

    public String getIndicadorLinha2_right_title() {
        return this.indicadorLinha2_right_title;
    }

    public String getIndicadorLinha3_left() {
        return this.indicadorLinha3_left;
    }

    public String getIndicadorLinha3_left_title() {
        return this.indicadorLinha3_left_title;
    }

    public String getIndicadorLinha3_right() {
        return this.indicadorLinha3_right;
    }

    public String getIndicadorLinha3_right_title() {
        return this.indicadorLinha3_right_title;
    }

    @ConfigLOVValues(value="NORMAL=Normal,PLUS_MAIN=netQA+ Main server,PLUS_NODE=netQA+ Node server (para cada UO)")
    @ConfigDefault(value="NORMAL")
    @ConfigAlias(name="Modo de funcionamento", description="O modo de funcionamento do netPA. Modo normal assume um netQA em modo aut\u00f3nomo sem interliga\u00e7\u00e3o com outros netQA.<br/>O modo netQA+ possibilita que existe um netQA Central com estat\u00edsticas agrupadas de v\u00e1rias Unidades Organicas de uma institui\u00e7\u00e3o. Neste modo \u00e9 necess\u00e1rio indicar se esta inst\u00e2ncia \u00e9 o n\u00f3 da institui\u00e7\u00e3o ou de uma das Unidades Org\u00e2nicas.")
    public String getMode() {
        return this.mode;
    }

    public Boolean getMultiInstituicoesAtivas() {
        return this.multiInstituicoesAtivas;
    }

    @ConfigAlias(name="netQA+ Main server base URL", description="Apenas necess\u00e1rio quando a inst\u00e2ncia corrente do netPA foi um n\u00f3 de um netPA+ central.")
    public String getNetQAPlusMainServerBaseURL() {
        return this.netQAPlusMainServerBaseURL;
    }

    @ConfigIgnore
    public boolean isModeNetQANormal() {
        return MODE_NORMAL.equals(this.getMode());
    }

    @ConfigIgnore
    public boolean isModeNetQAPlusNode() {
        return MODE_PLUS_NODE.equals(this.getMode());
    }

    @ConfigIgnore
    public boolean isModeNetQAPlusServer() {
        return MODE_PLUS_MAIN.equals(this.getMode());
    }

    public void setCalendarEndHour(Long calendarEndHour) {
        this.calendarEndHour = calendarEndHour;
    }

    public void setCalendarStartHour(Long calendarStartHour) {
        this.calendarStartHour = calendarStartHour;
    }

    public void setFiltrarListasPorRegenciaModo(String filtrarListasPorRegenciaModo) {
        this.filtrarListasPorRegenciaModo = filtrarListasPorRegenciaModo;
    }

    public void setForceProprietarySSOForNodes(Boolean forceProprietarySSOForNodes) {
        this.forceProprietarySSOForNodes = forceProprietarySSOForNodes;
    }

    public void setIndicadorLinha1_left(String indicadorLinha1_left) {
        this.indicadorLinha1_left = indicadorLinha1_left;
    }

    public void setIndicadorLinha1_left_title(String indicadorLinha1_left_title) {
        this.indicadorLinha1_left_title = indicadorLinha1_left_title;
    }

    public void setIndicadorLinha1_right(String indicadorLinha1_right) {
        this.indicadorLinha1_right = indicadorLinha1_right;
    }

    public void setIndicadorLinha1_right_title(String indicadorLinha1_right_title) {
        this.indicadorLinha1_right_title = indicadorLinha1_right_title;
    }

    public void setIndicadorLinha2_left(String indicadorLinha2_left) {
        this.indicadorLinha2_left = indicadorLinha2_left;
    }

    public void setIndicadorLinha2_left_title(String indicadorLinha2_left_title) {
        this.indicadorLinha2_left_title = indicadorLinha2_left_title;
    }

    public void setIndicadorLinha2_right(String indicadorLinha2_right) {
        this.indicadorLinha2_right = indicadorLinha2_right;
    }

    public void setIndicadorLinha2_right_title(String indicadorLinha2_right_title) {
        this.indicadorLinha2_right_title = indicadorLinha2_right_title;
    }

    public void setIndicadorLinha3_left(String indicadorLinha3_left) {
        this.indicadorLinha3_left = indicadorLinha3_left;
    }

    public void setIndicadorLinha3_left_title(String indicadorLinha3_left_title) {
        this.indicadorLinha3_left_title = indicadorLinha3_left_title;
    }

    public void setIndicadorLinha3_right(String indicadorLinha3_right) {
        this.indicadorLinha3_right = indicadorLinha3_right;
    }

    public void setIndicadorLinha3_right_title(String indicadorLinha3_right_title) {
        this.indicadorLinha3_right_title = indicadorLinha3_right_title;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setMultiInstituicoesAtivas(Boolean multiInstituicoesAtivas) {
        this.multiInstituicoesAtivas = multiInstituicoesAtivas;
    }

    public void setNetQAPlusMainServerBaseURL(String netQAPlusMainServerBaseURL) {
        this.netQAPlusMainServerBaseURL = netQAPlusMainServerBaseURL;
    }
}

