/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.rules;

import java.util.HashMap;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.annotations.ContextParameter;
import pt.digitalis.dif.rules.annotations.RuleGroup;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.rules.objects.rules.AbstractRuleGroup;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.netqa.rules.exceptions.NetQAException;

@RuleGroup(name="netQARulesCurso")
public abstract class NetQARulesCurso
extends AbstractRuleGroup {
    private static IRulesManager ruleManager = (IRulesManager)DIFIoCRegistry.getRegistry().getImplementation(IRulesManager.class);
    @ContextParameter
    String codeCurso;
    @ContextParameter
    NetQAUser netQAUser;

    public static NetQARulesCurso getInstance(String codeCurso, NetQAUser netQAUser) throws NetQAException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("codeCurso", codeCurso);
            parameters.put("netQAUser", netQAUser);
            return (NetQARulesCurso)ruleManager.getRuleGroupInstance(NetQARulesCurso.class, parameters);
        }
        catch (MissingContextException e) {
            throw new NetQAException(e);
        }
        catch (RuleGroupException e) {
            throw new NetQAException(e);
        }
    }

    public Boolean canViewAlunos() {
        return true;
    }

    public Boolean canViewApresentacao() {
        return true;
    }

    public Boolean canViewCaracteristicas() {
        return true;
    }

    public Boolean canViewDSD() {
        return true;
    }

    public Boolean canViewHorario() {
        return false;
    }

    public Boolean canViewIndicadores() {
        return true;
    }

    public Boolean canViewInqueritos() {
        return true;
    }

    public Boolean canViewPautas() {
        return true;
    }

    public Boolean canViewPlanoEstudos() {
        return true;
    }

    public Boolean canViewProjetos() {
        return true;
    }

    public Boolean canViewRAC() {
        try {
            return this.netQAUser.isBOUser() || this.netQAUser.isRegenteCurso(this.codeCurso);
        }
        catch (IdentityManagerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean canViewRegencia() {
        return true;
    }

    public Boolean canViewSumarios() {
        return true;
    }

    public Boolean isContentCursoEditable() throws IdentityManagerException {
        return this.netQAUser.isAdministrator() || this.netQAUser.isBOUser() || this.netQAUser.isRegenteCurso(this.codeCurso);
    }
}

