/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.rules;

import java.util.HashMap;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.annotations.ContextParameter;
import pt.digitalis.dif.rules.annotations.RuleGroup;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.rules.objects.rules.AbstractRuleGroup;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.netqa.rules.exceptions.NetQAException;

@RuleGroup(name="NetQARulesDocente")
public abstract class NetQARulesDocente
extends AbstractRuleGroup {
    private static IRulesManager ruleManager = (IRulesManager)DIFIoCRegistry.getRegistry().getImplementation(IRulesManager.class);
    @ContextParameter
    String codeDocente;
    @ContextParameter
    NetQAUser netQAUser;

    public static NetQARulesDocente getInstance(String codeDocente, NetQAUser netQAUser) throws NetQAException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("codeDocente", codeDocente);
            parameters.put("netQAUser", netQAUser);
            return (NetQARulesDocente)ruleManager.getRuleGroupInstance(NetQARulesDocente.class, parameters);
        }
        catch (MissingContextException e) {
            throw new NetQAException(e);
        }
        catch (RuleGroupException e) {
            throw new NetQAException(e);
        }
    }

    public Boolean canViewApresentacao() {
        return true;
    }

    public Boolean canViewCaracteristicas() {
        return true;
    }

    public Boolean canViewCargosGestao() {
        return true;
    }

    public Boolean canViewCurriculum() {
        return true;
    }

    public Boolean canViewDSD() {
        return true;
    }

    public Boolean canViewExperienciaProfissional() {
        return true;
    }

    public Boolean canViewFormacaoComplementar() {
        return true;
    }

    public Boolean canViewHabilitacoesLiterarias() {
        return true;
    }

    public Boolean canViewHistoricoAnoLetivo() {
        return true;
    }

    public Boolean canViewHorario() {
        return true;
    }

    public Boolean canViewIdiomas() {
        return true;
    }

    public Boolean canViewInqueritos() {
        return true;
    }

    public Boolean canViewInvestigacao() {
        return true;
    }

    public Boolean canViewOrientacaoTeses() {
        return true;
    }

    public Boolean canViewParticipacaoJuri() {
        return true;
    }

    public Boolean canViewOutrasActividades() {
        return true;
    }

    public Boolean canViewPautas() {
        return true;
    }

    public Boolean canViewPremiosLouvores() {
        return true;
    }

    public Boolean canViewProjetos() {
        return true;
    }

    public Boolean canViewRegencia() {
        return true;
    }

    public Boolean canViewSumarios() {
        return true;
    }

    public Boolean isContentCursoEditable() throws IdentityManagerException {
        return this.netQAUser.isAdministrator() || this.netQAUser.isBOUser();
    }
}

