/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.rules;

import java.util.ArrayList;
import java.util.List;
import pt.digitalis.dif.codegen.templates.IInjectUserCreator;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dataminer.definition.DashboardManager;
import pt.digitalis.dif.dataminer.session.IDDMSession;
import pt.digitalis.dif.dataminer.session.IDDMUserProfile;
import pt.digitalis.dif.dem.annotations.siges.ISIGESInstanceInitializer;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.log.LogLevel;
import pt.digitalis.netqa.rules.NetQARulesCurso;
import pt.digitalis.netqa.rules.NetQARulesDocente;
import pt.digitalis.netqa.rules.NetQARulesUnidadeCurricular;
import pt.digitalis.netqa.rules.exceptions.NetQAException;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.cmenet.business.definitions.Catalog;
import pt.digitalis.siges.cmenet.business.session.AbstractSiGESDDMUserProfile;
import pt.digitalis.siges.cmenet.business.session.CMEUserProfileRegenciasDeCurso;
import pt.digitalis.siges.cmenet.business.session.CMEUserProfileRegenciasDeUnidadeCurricular;
import pt.digitalis.siges.model.ISIGESDirectory;
import pt.digitalis.siges.model.ISIGESInstance;
import pt.digitalis.siges.model.data.cse.TableLectivo;
import pt.digitalis.siges.model.rules.CSERules;
import pt.digitalis.siges.model.storedprocs.SIGESStoredProcedures;
import pt.digitalis.utils.config.ConfigurationException;

public class NetQAUser
implements IInjectUserCreator {
    private static final String NETQA_ANO_LETIVO_IN_SESSION = "netQAAnoLetivoInSession";
    private static final String NETQA_DDMSESSION_IN_SESSION = "netQADDMSessionInSession";
    private TableLectivo anoLectivo = null;
    private String codeCurso;
    private String codeDiscip;
    private String codeFuncionario;
    private String codeInstituicao;
    private IDIFContext context;
    private IDDMSession ddmSession;
    private List<String> regenteCursos = null;
    private List<String> regenteUCs = null;

    public NetQAUser() {
    }

    public NetQAUser(IDIFContext context) throws IdentityManagerException {
        this.context = context;
        this.ddmSession = (IDDMSession)context.getSession().getAttribute(NETQA_DDMSESSION_IN_SESSION);
        if (this.ddmSession == null) {
            this.ddmSession = (IDDMSession)DIFIoCRegistry.getRegistry().getImplementation(IDDMSession.class);
            try {
                this.ddmSession.initialize(context.getSession());
            }
            catch (IdentityManagerException e) {
                new BusinessException("Error initializing the DDM session", (Exception)((Object)e)).addToExceptionContext(context).log(LogLevel.ERROR);
            }
            catch (ConfigurationException e) {
                new BusinessException("Error initializing the DDM session", (Exception)((Object)e)).addToExceptionContext(context).log(LogLevel.ERROR);
            }
            if (this.context.getSession().isLogged()) {
                context.getSession().addAttribute(NETQA_DDMSESSION_IN_SESSION, (Object)this.ddmSession);
                if (context.getSession().getUser().getGroupIDs().contains("QualidadeBackOffice")) {
                    DashboardManager.getInstance((String)"CMEnetCatalogInstance").grantDirectAccessToAllIndicators(context.getSession());
                }
            }
        }
        if (context.getRequest().getParameter("codeCurso") != null) {
            this.codeCurso = (String)context.getRequest().getParameter("codeCurso");
        }
        if (context.getRequest().getParameter("codeDiscip") != null) {
            this.codeDiscip = (String)context.getRequest().getParameter("codeDiscip");
        }
        if (context.getRequest().getParameter("codeFuncionario") != null) {
            this.codeFuncionario = (String)context.getRequest().getParameter("codeFuncionario");
        }
        if (context.getRequest().getParameter("codeInstituicao") != null) {
            this.codeInstituicao = (String)context.getRequest().getParameter("codeInstituicao");
        }
    }

    public TableLectivo getAnoLectivo() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (this.anoLectivo == null) {
            Object anoLectivoInSession = this.context.getSession().getAttribute(NETQA_ANO_LETIVO_IN_SESSION);
            if (anoLectivoInSession != null) {
                this.anoLectivo = (TableLectivo)anoLectivoInSession;
            } else {
                ISIGESInstanceInitializer instanceInitializer = (ISIGESInstanceInitializer)DIFIoCRegistry.getRegistry().getImplementation(ISIGESInstanceInitializer.class);
                ISIGESInstance siges = instanceInitializer.getSIGESInstance(this.context.getSession());
                this.anoLectivo = (TableLectivo)CSERules.getInstance((ISIGESDirectory)siges).getAnoLectivoActual().getResult();
                this.context.getSession().addAttribute(NETQA_ANO_LETIVO_IN_SESSION, (Object)this.anoLectivo);
            }
        }
        return this.anoLectivo;
    }

    public String getAnoLectivoFormatado() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        return SIGESStoredProcedures.getAnoLectivoDescription((String)this.getAnoLectivo().getCodeLectivo());
    }

    public String getCodeCurso() {
        return this.codeCurso;
    }

    public NetQARulesCurso getCursoViewingRights() throws NetQAException {
        return NetQARulesCurso.getInstance(this.codeCurso, this);
    }

    public NetQARulesDocente getDocenteViewingRights() throws NetQAException {
        return NetQARulesDocente.getInstance(this.codeFuncionario, this);
    }

    public NetQARulesDocente getInstituicaoViewingRights() throws NetQAException {
        return NetQARulesDocente.getInstance(this.codeInstituicao, this);
    }

    public List<IDDMUserProfile> getProfiles() {
        return this.ddmSession.getAvailableProfiles();
    }

    public List<String> getRegenteCursos() {
        if (this.regenteCursos == null) {
            this.initializeRegencias();
        }
        return this.regenteCursos;
    }

    public List<String> getRegenteUCs() {
        if (this.regenteUCs == null) {
            this.initializeRegencias();
        }
        return this.regenteUCs;
    }

    public NetQARulesUnidadeCurricular getUCViewingRights() throws NetQAException {
        return NetQARulesUnidadeCurricular.getInstance(this.codeDiscip, this);
    }

    private void initializeRegencias() {
        ArrayList<String> tempRegenteUC = new ArrayList<String>();
        ArrayList<String> tempRegenteCursos = new ArrayList<String>();
        for (IDDMUserProfile profile : this.getProfiles()) {
            if (!(profile instanceof AbstractSiGESDDMUserProfile)) continue;
            for (String instanceID : profile.getInstanceIDs()) {
                if (profile instanceof CMEUserProfileRegenciasDeCurso) {
                    tempRegenteCursos.add(instanceID);
                    continue;
                }
                if (!(profile instanceof CMEUserProfileRegenciasDeUnidadeCurricular)) continue;
                tempRegenteUC.add(instanceID);
            }
        }
        this.regenteUCs = tempRegenteUC;
        this.regenteCursos = tempRegenteCursos;
    }

    public boolean isAdministrator() throws IdentityManagerException {
        return this.context.getSession().isLogged() && this.context.getSession().getUser().getGroupIDs().contains("Administrators");
    }

    public boolean isBOUser() throws IdentityManagerException {
        return this.context.getSession().isLogged() && (this.context.getSession().getUser().getGroupIDs().contains("QualidadeBackOffice") || "QualidadeBackOffice".equals(this.context.getSession().getUser().getProfileID()));
    }

    public boolean isRegenteCurso(String codeCurso) {
        if (this.regenteCursos == null) {
            this.initializeRegencias();
        }
        return this.regenteCursos.contains(codeCurso);
    }

    public boolean isRegenteUC(String codeDiscip) {
        if (this.regenteUCs == null) {
            this.initializeRegencias();
        }
        return this.regenteUCs.contains(codeDiscip);
    }

    public Object newUser(IDIFContext context) {
        try {
            return new NetQAUser(context);
        }
        catch (IdentityManagerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setAnoLectivo(TableLectivo anoLectivo) throws BusinessException, ConfigurationException {
        this.anoLectivo = anoLectivo;
        this.context.getSession().addAttribute(NETQA_ANO_LETIVO_IN_SESSION, (Object)anoLectivo);
        Catalog.setFiltroAnoLetivo((String)anoLectivo.getCodeLectivo());
        Catalog.registerDashboards();
    }

    public void setRegenteCursos(List<String> regenteCursos) {
        this.regenteCursos = regenteCursos;
    }

    public void setRegenteUCs(List<String> regenteUCs) {
        this.regenteUCs = regenteUCs;
    }
}

