/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.rules;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.opensaml.xml.security.SecurityException;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.controller.security.managers.ISessionManager;
import pt.digitalis.dif.controller.security.managers.ISessionManagerInternal;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.exception.security.AuthenticationManagerException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.http.HttpUtils;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.crypto.IEncryptor;
import pt.digitalis.utils.crypto.exeption.CryptoException;
import pt.digitalis.utils.crypto.impl.EncryptorBase64Impl;

public class NetQAUtils {
    private static IApplication application;
    private static String dateFormatString;
    private static IEncryptor encryptor;
    private static Date lastEncryptedUserReceiveDate;
    private static IMessageManager messageManager;

    public static void authenticateWithSSOAuthenticationToken(String token, IDIFSession session, boolean urlDecode) throws UnsupportedEncodingException, IdentityManagerException, SecurityException, CryptoException, AuthenticationManagerException {
        String userID = NetQAUtils.decryptUser(token, urlDecode);
        if (StringUtils.isNotBlank((String)userID)) {
            ISessionManagerInternal sessionManager = (ISessionManagerInternal)DIFIoCRegistry.getRegistry().getImplementation(ISessionManager.class);
            sessionManager.logInNoPasswordValidation(session.getSessionID(), userID, null);
        }
    }

    private static String decryptUser(String encripted, boolean urlDecode) throws SecurityException, UnsupportedEncodingException, CryptoException, IdentityManagerException {
        Date currentDate = new Date();
        String dateFormatStringNoInvalidCharacters = dateFormatString.replace("'", "");
        String decryptedString = NetQAUtils.getEncrypter().decrypt(urlDecode ? URLDecoder.decode(encripted, "UTF-8") : encripted);
        decryptedString = decryptedString.substring("netqa".length());
        String userID = decryptedString.substring(0, decryptedString.length() - dateFormatStringNoInvalidCharacters.length());
        String dateString = decryptedString.substring(userID.length());
        StringBuffer dateStringToParse = new StringBuffer();
        StringBuffer dateTemplateToParse = new StringBuffer();
        boolean reportInvalidToken = false;
        if (dateString.length() != dateFormatStringNoInvalidCharacters.length()) {
            reportInvalidToken = true;
        } else {
            for (int i = 0; i < dateFormatStringNoInvalidCharacters.length(); ++i) {
                Character currentChar = Character.valueOf(dateFormatStringNoInvalidCharacters.charAt(i));
                if (!"dMyHms".contains(currentChar.toString())) continue;
                dateStringToParse.append(dateString.charAt(i));
                dateTemplateToParse.append(dateFormatStringNoInvalidCharacters.charAt(i));
            }
            try {
                long timePassedSinceLastRequest;
                Date parsedDate = new SimpleDateFormat(dateTemplateToParse.toString()).parse(dateStringToParse.toString());
                long timePassedSinceParsedDate = (currentDate.getTime() - parsedDate.getTime()) / 1000L;
                long l = timePassedSinceLastRequest = lastEncryptedUserReceiveDate == null ? 0L : (parsedDate.getTime() - lastEncryptedUserReceiveDate.getTime()) / 1000L;
                if (timePassedSinceLastRequest < -60L) {
                    reportInvalidToken = true;
                } else if (timePassedSinceParsedDate > 60L) {
                    reportInvalidToken = true;
                }
                if (!reportInvalidToken) {
                    lastEncryptedUserReceiveDate = parsedDate;
                }
            }
            catch (ParseException e) {
                reportInvalidToken = true;
            }
        }
        if (reportInvalidToken) {
            throw new SecurityException("Authentication token invalid!");
        }
        if (((IIdentityManager)DIFIoCRegistry.getRegistry().getImplementation(IIdentityManager.class)).userExists(userID)) {
            return userID;
        }
        throw new SecurityException("Authentication token contains invalid user!");
    }

    private static String encryptUser(String userID) throws UnsupportedEncodingException, CryptoException {
        String userIDKey = "netqa" + userID + new SimpleDateFormat(dateFormatString).format(new Date());
        String encrypted = URLEncoder.encode(NetQAUtils.getEncrypter().encrypt(userIDKey), "UTF-8");
        return encrypted;
    }

    public static String generateSSOAuthenticationToken(IDIFSession session) throws UnsupportedEncodingException, CryptoException {
        return NetQAUtils.generateSSOAuthenticationToken(session.getUser().getID());
    }

    public static String generateSSOAuthenticationToken(String userID) throws UnsupportedEncodingException, CryptoException {
        return NetQAUtils.encryptUser(userID);
    }

    public static IApplication getApplication() {
        if (application == null) {
            application = ((IDEMManager)DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class)).getApplication("netqa");
        }
        return application;
    }

    public static Map<String, String> getApplicationMessages(String language) {
        return messageManager.getMessages(NetQAUtils.getApplication(), language);
    }

    private static synchronized IEncryptor getEncrypter() {
        if (encryptor == null) {
            encryptor = new EncryptorBase64Impl();
            encryptor.setSeed("Encer897tupy P@55dpoig345i0d");
        }
        return encryptor;
    }

    public static String getSSOLink(String baseURL, IDIFSession session) throws UnsupportedEncodingException, CryptoException, ConfigurationException {
        if (!netQAConfigurations.getInstance().getForceProprietarySSOForNodes().booleanValue()) {
            return baseURL;
        }
        if (StringUtils.isBlank((String)baseURL)) {
            return null;
        }
        baseURL = HttpUtils.removeListenerPrefix((String)baseURL);
        if (!(baseURL = HttpUtils.removeRESTPrefix((String)baseURL)).endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + "page?stage=" + "homenetqa" + "&netQASSOToken=" + NetQAUtils.generateSSOAuthenticationToken(session);
    }

    static NetQAUser getUserInfo(IDIFContext context) throws IdentityManagerException {
        return new NetQAUser(context);
    }

    static {
        dateFormatString = "dd'#er$%r'MM'12rt23'yyyy'34'HH'$%'mm'7'ss'r'%";
        encryptor = null;
        lastEncryptedUserReceiveDate = null;
        messageManager = (IMessageManager)DIFIoCRegistry.getRegistry().getImplementation(IMessageManager.class);
    }
}

