-----------------------------------------------------
--                   netQA v1.0.0                   --
-----------------------------------------------------

/* ## CREATE INTEGRATIONS TABLE ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'NETQA'
  AND    TABLE_NAME = 'INTEGRATIONS';

  IF TOTAL = 0 THEN
    -- Create table
    EXECUTE IMMEDIATE 'CREATE TABLE NETQA.INTEGRATIONS '||
                      '(ID              NUMBER(10) '||
                      ',TITLE           VARCHAR2(200) '||
                      ',URL             VARCHAR2(4000) '||
                      ',DESCRIPTION     VARCHAR2(4000) '||
                      ',ORDER_NUMBER    NUMBER(4) '||
                      ',ACTIVE          NUMBER(1)) '||
                      'TABLESPACE SMALL '||
                      'STORAGE (INITIAL 256K NEXT 504K MINEXTENTS 1 MAXEXTENTS 505 PCTINCREASE 10)';

    -- Add comments to the columns
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.INTEGRATIONS.ID           IS ''The ID column''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.INTEGRATIONS.TITLE        IS ''The integration title''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.INTEGRATIONS.URL          IS ''The integration site URL''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.INTEGRATIONS.DESCRIPTION  IS ''The integration description''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.INTEGRATIONS.ORDER_NUMBER IS ''Order field''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.INTEGRATIONS.ACTIVE       IS ''If the integration is active''';

    -- Create constraints
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.INTEGRATIONS ADD CONSTRAINT INTEGRATIONS_PK PRIMARY KEY (ID)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.INTEGRATIONS ADD CONSTRAINT INTEGRATIONS_TITLE_NN CHECK ("TITLE" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.INTEGRATIONS ADD CONSTRAINT INTEGRATIONS_URL_NN CHECK ("URL" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.INTEGRATIONS ADD CONSTRAINT INTEGRATIONS_ACTIVE_NN CHECK ("ACTIVE" IS NOT NULL)';

    -- Create sequence
    SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_SEQUENCES
    WHERE  SEQUENCE_OWNER = 'NETQA'
    AND    SEQUENCE_NAME  = 'INTEGRATIONS_SEQ';

    IF TOTAL > 0 THEN
      EXECUTE IMMEDIATE 'DROP SEQUENCE NETQA.INTEGRATIONS_SEQ';
    END IF;
    EXECUTE IMMEDIATE 'CREATE SEQUENCE NETQA.INTEGRATIONS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE';

    -- Create trigger
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER NETQA.TRG_INTEGRATIONS_BFR_INS '||
                      'BEFORE INSERT ON NETQA.INTEGRATIONS '||
                      'FOR EACH ROW '||
                      'BEGIN '||
                      '  IF :NEW.ID IS NULL THEN '||
                      '    :NEW.ID := INTEGRATIONS_SEQ.NEXTVAL; '||
                      '  END IF; '||
                      '  IF :NEW.ORDER_NUMBER IS NULL THEN '||
                      '    :NEW.ORDER_NUMBER := :NEW.ID; '||
                      '  END IF; '||
                      'END TRG_INTEGRATIONS_BFR_INS;';
  END IF;
END;
/
