-----------------------------------------------------
--                 netQA v11.5.4-1                 --
-----------------------------------------------------

/* ## CREATE REPORT_CATEGORY TABLE ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'NETQA'
  AND    TABLE_NAME = 'REPORT_CATEGORY';

  IF TOTAL = 0 THEN
    -- Create table
    EXECUTE IMMEDIATE 'CREATE TABLE NETQA.REPORT_CATEGORY '||
                      '(ID              NUMBER(10) '||
                      ',DESCRIPTION     VARCHAR2(200)) '||
                      'TABLESPACE SMALL '||
                      'STORAGE (INITIAL 256K NEXT 504K MINEXTENTS 1 MAXEXTENTS 505 PCTINCREASE 10)';

    -- Add comments to the columns
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT_CATEGORY.ID           IS ''The ID column''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT_CATEGORY.DESCRIPTION  IS ''The description''';

    -- Create constraints
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.REPORT_CATEGORY ADD CONSTRAINT REPORT_CATEGORY_PK PRIMARY KEY (ID)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.REPORT_CATEGORY ADD CONSTRAINT REPORT_CATEGORY_DESCRIPTION_NN CHECK ("DESCRIPTION" IS NOT NULL)';

    -- Create sequence
    SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_SEQUENCES
    WHERE  SEQUENCE_OWNER = 'NETQA'
    AND    SEQUENCE_NAME  = 'REPORT_CATEGORY_SEQ';

    IF TOTAL > 0 THEN
      EXECUTE IMMEDIATE 'DROP SEQUENCE NETQA.REPORT_CATEGORY_SEQ';
    END IF;
    EXECUTE IMMEDIATE 'CREATE SEQUENCE NETQA.REPORT_CATEGORY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE';

    -- Create trigger
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER NETQA.TRG_REPORT_CATEGORY_BFR_INS '||
                      'BEFORE INSERT ON NETQA.REPORT_CATEGORY '||
                      'FOR EACH ROW '||
                      'BEGIN '||
                      '  IF :NEW.ID IS NULL THEN '||
                      '    :NEW.ID := REPORT_CATEGORY_SEQ.NEXTVAL; '||
                      '  END IF; '||
                      'END TRG_REPORT_CATEGORY_BFR_INS;';
  END IF;
END;
/

/* ## CREATE REPORT TABLE ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'NETQA'
  AND    TABLE_NAME = 'REPORT';

  IF TOTAL = 0 THEN
    -- Create table
    EXECUTE IMMEDIATE 'CREATE TABLE NETQA.REPORT '||
                      '(ID                        NUMBER(10) '||
                      ',TITLE                     VARCHAR2(200) '||
                      ',DESCRIPTION               VARCHAR2(4000) '||
                      ',CATEGORY_ID               NUMBER '||
                      ',DOCUMENT_ID               NUMBER '||
                      ',JASPER_REPORT_ID          NUMBER(10) '||
                      ',VISIBLE                   NUMBER(1) '||
                      ',RESTRICT_ACCESS_TO_GROUPS VARCHAR2(4000)) '||
                      'TABLESPACE SMALL '||
                      'STORAGE (INITIAL 256K NEXT 504K MINEXTENTS 1 MAXEXTENTS 505 PCTINCREASE 10)';

    -- Add comments to the columns
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.ID                         IS ''The ID column''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.TITLE                      IS ''The title''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.DESCRIPTION                IS ''The description''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.CATEGORY_ID                IS ''The document category id''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.DOCUMENT_ID                IS ''The document repository id''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.JASPER_REPORT_ID           IS ''The ID for the jasper report template''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.VISIBLE                    IS ''If the report is active''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.REPORT.RESTRICT_ACCESS_TO_GROUPS  IS ''If the report is active''';

    -- Create constraints
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.REPORT ADD CONSTRAINT REPORT_PK PRIMARY KEY (ID)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.REPORT ADD CONSTRAINT REPORT_TITLE_NN CHECK ("TITLE" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.REPORT ADD CONSTRAINT REPORT_CATEGORY_NN CHECK ("CATEGORY_ID" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.REPORT ADD CONSTRAINT REPORT_CATEGORY_FK FOREIGN KEY (CATEGORY_ID) REFERENCES NETQA.REPORT_CATEGORY (ID)';

    -- Create sequence
    SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_SEQUENCES
    WHERE  SEQUENCE_OWNER = 'NETQA'
    AND    SEQUENCE_NAME  = 'REPORT_SEQ';

    IF TOTAL > 0 THEN
      EXECUTE IMMEDIATE 'DROP SEQUENCE NETQA.REPORT_SEQ';
    END IF;
    EXECUTE IMMEDIATE 'CREATE SEQUENCE NETQA.REPORT_SEQ START WITH 1 INCREMENT BY 1 NOCACHE';

    -- Create trigger
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER NETQA.TRG_REPORT_BFR_INS '||
                      'BEFORE INSERT ON NETQA.REPORT '||
                      'FOR EACH ROW '||
                      'BEGIN '||
                      '  IF :NEW.ID IS NULL THEN '||
                      '    :NEW.ID := REPORT_SEQ.NEXTVAL; '||
                      '  END IF; '||
                      'END TRG_REPORT_BFR_INS;';
  END IF;
END;
/
