-----------------------------------------------------
--                 netQA v11.6.12                  --
-----------------------------------------------------

/* ## CREATE UO TABLE ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'NETQA'
  AND    TABLE_NAME = 'U_O_NODE';

  IF TOTAL = 0 THEN
    -- Create table
    EXECUTE IMMEDIATE 'CREATE TABLE NETQA.U_O_NODE '||
                      '(ID                NUMBER(10) '||
                      ',KEYWORD           VARCHAR2(30) '||
                      ',NAME              VARCHAR2(500) '||
                      ',URL               VARCHAR2(1000) '||
                      ',POSITION          NUMBER(3) '||
                      ',DESCRIPTION       CLOB '||
                      ',LOGO_DOCUMENT_ID  NUMBER '||
                      ',VISIBLE           NUMBER(1) '||
                      ',ACTIVE            NUMBER(1)) '||
                      'TABLESPACE SMALL '||
                      'STORAGE (INITIAL 256K NEXT 504K MINEXTENTS 1 MAXEXTENTS 505 PCTINCREASE 10)';

    -- Add comments to the columns
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.ID               IS ''The ID column''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.KEYWORD          IS ''The keyword''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.NAME             IS ''The name''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.POSITION         IS ''The position (order)''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.URL              IS ''The URL''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.DESCRIPTION      IS ''The description''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.LOGO_DOCUMENT_ID IS ''The logo image''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.VISIBLE          IS ''If the UO node is visible''';
    EXECUTE IMMEDIATE 'COMMENT ON COLUMN NETQA.U_O_NODE.ACTIVE           IS ''If the UO node is active''';

    -- Create constraints
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.U_O_NODE ADD CONSTRAINT UO_NODE_PK PRIMARY KEY (ID)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.U_O_NODE ADD CONSTRAINT UO_NODE_KEYWORD_NN CHECK ("KEYWORD" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.U_O_NODE ADD CONSTRAINT UO_NODE_NAME_NN CHECK ("NAME" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.U_O_NODE ADD CONSTRAINT UO_NODE_URL_NN CHECK ("URL" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.U_O_NODE ADD CONSTRAINT UO_NODE_VISIBLE_NN CHECK ("VISIBLE" IS NOT NULL)';
    EXECUTE IMMEDIATE 'ALTER TABLE NETQA.U_O_NODE ADD CONSTRAINT UO_NODE_ACTIVE_NN CHECK ("ACTIVE" IS NOT NULL)';

    -- Create sequence
    SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_SEQUENCES
    WHERE  SEQUENCE_OWNER = 'NETQA'
    AND    SEQUENCE_NAME  = 'UO_NODE_SEQ';

    IF TOTAL > 0 THEN
      EXECUTE IMMEDIATE 'DROP SEQUENCE NETQA.U_O_NODE_SEQ';
    END IF;
    EXECUTE IMMEDIATE 'CREATE SEQUENCE NETQA.U_O_NODE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE';

    -- Create trigger
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER NETQA.TRG_U_O_NODE_BFR_INS '||
                      'BEFORE INSERT ON NETQA.U_O_NODE '||
                      'FOR EACH ROW '||
                      'BEGIN '||
                      '  IF :NEW.ID IS NULL THEN '||
                      '    :NEW.ID := U_O_NODE_SEQ.NEXTVAL; '||
                      '  END IF; '||
                      'END TRG_U_O_NODE_BFR_INS;';
  END IF;
END;
/
