/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.crypto;

import pt.digitalis.utils.crypto.exeption.CryptoException;

/**
 * Defines an Encryption API
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Sep 30, 2007
 */
public interface IEncryptor {

    /**
     * Decrypts the given String value
     * 
     * @param value
     *            the string to decrypt
     * @return the decrypted value
     * @throws CryptoException
     *             if an error occurs during crypto process
     */
    public String decrypt(String value) throws CryptoException;

    /**
     * Decrypts the given String value
     * 
     * @param value
     *            the string to decrypt
     * @param key
     *            the key used in cypher
     * @return the decrypted value
     * @throws CryptoException
     *             if an error occurs during crypto process
     */
    public String decrypt(String value, String key) throws CryptoException;

    /**
     * Encrypts the given String value
     * 
     * @param value
     *            the string to encrypt
     * @return the encrypted value
     * @throws CryptoException
     *             if an error occurs during crypto process
     */
    public String encrypt(String value) throws CryptoException;

    /**
     * Encrypts the given String value
     * 
     * @param value
     *            the string to encrypt
     * @param key
     *            the key used in cypher
     * @return the encrypted value
     * @throws CryptoException
     *             if an error occurs during crypto process
     */
    public String encrypt(String value, String key) throws CryptoException;

    /**
     * @return the seed
     */
    public String getSeed();

    /**
     * @param seed
     *            the seed to set
     */
    public void setSeed(String seed);
}
