/**
 * 2013, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.checksum;

import java.io.InputStream;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 23 de Mai de 2013
 */
public interface ICheckSumGenerator {

    /**
     * Generates an hash check sum validator string for the given input using the configured generator
     * 
     * @param contentToEncrypt
     *            the content to encrypt
     * @return the string with the hash generated
     * @throws CheckSumException
     */
    public String getCheckSumHash(byte[] contentToEncrypt) throws CheckSumException;

    /**
     * Generates an hash check sum validator string for the given input using the configured generator
     * 
     * @param contentToEncrypt
     *            the content to encrypt
     * @return the string with the hash generated
     * @throws CheckSumException
     */
    public String getCheckSumHash(InputStream contentToEncrypt) throws CheckSumException;

    /**
     * Generates an hash check sum validator string for the given input using the configured generator
     * 
     * @param contentToEncrypt
     *            the content to encrypt
     * @return the string with the hash generated
     * @throws CheckSumException
     */
    public String getCheckSumHash(String contentToEncrypt) throws CheckSumException;
}
