/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.crypto.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

import org.apache.commons.codec.binary.Base64;

import pt.digitalis.utils.crypto.IEncryptor;
import pt.digitalis.utils.crypto.exeption.CryptoException;

/**
 * Default implementation of {@link IEncryptor}
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Galaio da Silva <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Sep 30, 2007
 */
public class EncryptorBase64Impl implements IEncryptor {

    /**
     * Number of iteration, used for the encryption.
     */
    private static final int iterations = 10;
    /**
     * 8-bytes Salt, used for the encryption.
     */
    private static final byte[] salt = {(byte) 0xA9, (byte) 0x9B, (byte) 0xC8, (byte) 0x32, (byte) 0x56, (byte) 0x34,
                        (byte) 0xE3, (byte) 0x03};

    /** The seed for encryption operations */
    private String seed;

    /**
     * @see pt.digitalis.utils.crypto.IEncryptor#decrypt(java.lang.String)
     */
    public String decrypt(String value) throws CryptoException
    {
        return decrypt(value, seed);
    }

    /**
     * @see pt.digitalis.utils.crypto.IEncryptor#decrypt(java.lang.String, java.lang.String)
     */
    public String decrypt(String value, String key) throws CryptoException
    {
        String decoded = null;

        // Encode the string into bytes using utf-8 and Encrypt
        byte[] dec;
        try
        {
            Cipher cipher = this.getCipher(key, Cipher.DECRYPT_MODE);

            dec = cipher.doFinal(Base64.decodeBase64(value.getBytes()));
            decoded = new String(dec, "UTF8");
        }
        catch (Exception e)
        {
            throw new CryptoException(e);
        }

        return decoded;
    }

    /**
     * @see pt.digitalis.utils.crypto.IEncryptor#encrypt(java.lang.String)
     */
    public String encrypt(String value) throws CryptoException
    {
        return encrypt(value, this.seed);
    }

    /**
     * @see pt.digitalis.utils.crypto.IEncryptor#encrypt(java.lang.String, java.lang.String)
     */
    public String encrypt(String value, String key) throws CryptoException
    {
        String encripted = null;

        try
        {
            // Encode the string into bytes using utf-8 and Encrypt
            byte[] enc = this.getCipher(key, Cipher.ENCRYPT_MODE).doFinal(value.getBytes("utf-8"));

            // Encode bytes to base64 to get a string
            encripted = new String(Base64.encodeBase64(enc));

        }
        catch (Exception e)
        {
            throw new CryptoException(e);
        }
        return encripted;
    }

    /**
     * Gets the cipher to (de)encrypt the <code>String</code>.
     * 
     * @param _key
     *            the key to be used
     * @param _mode
     *            the mode to use the cipher (javax.crypto.Cipher#DECRYPT_MODE or javax.crypto.Cipher#ENCRYPT_MODE)
     * @return the cipher
     * @throws InvalidKeySpecException
     *             javax.crypto.SecretKeyFactory#generateSecret
     * @throws NoSuchAlgorithmException
     *             javax.crypto.SecretKeyFactory#getInstance, javax.crypto.Cipher#getInstance
     * @throws NoSuchPaddingException
     *             javax.crypto.Cipher#getInstance
     * @throws InvalidKeyException
     *             javax.crypto.Cipher#init
     * @throws InvalidAlgorithmParameterException
     *             javax.crypto.Cipher#init
     * @throws CryptoException
     */
    private Cipher getCipher(String _key, int _mode) throws InvalidKeySpecException, NoSuchAlgorithmException,
            NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, CryptoException
    {
        if (_key == null)
            throw new CryptoException("The seed was not provided.");

        // Prepare the parameters to the cipther
        KeySpec keySpec = new PBEKeySpec(_key.toCharArray(), salt, iterations, 10);
        SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = new PBEParameterSpec(salt, iterations);

        // Create Cipher
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(_mode, secretKey, paramSpec);

        return cipher;
    }

    /**
     * @see pt.digitalis.utils.crypto.IEncryptor#getSeed()
     */
    public String getSeed()
    {
        return seed;
    }

    /**
     * @see pt.digitalis.utils.crypto.IEncryptor#setSeed(java.lang.String)
     */
    public void setSeed(String seed)
    {
        this.seed = seed;
    }
}
