package pt.digitalis.utils.crypto.ioc;

import pt.digitalis.utils.crypto.IEncryptor;
import pt.digitalis.utils.crypto.impl.EncryptorBase64Impl;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 30 de Set de 2011
 */
public class SecurityModule implements IIoCModule
{

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IEncryptor.class, EncryptorBase64Impl.class).withId("encryptatorBase64");
    }
}
