/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.web.ancillaries;

import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.easymock.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebAncillaries {
    public static final String ACCEPT_LANGUAGE_HEADER = "en-gb,en;q=0.5";
    public static final String ACCESSIBLE_WEB_UI_MODE = "access";
    public static final Locale EN_LOCALE = new Locale("en-gb", "");
    public static final String FALSE = Boolean.FALSE.toString().toLowerCase();
    public static final String FIREFOX_MAIN_VERSION = "2";
    public static final String FIREFOX_MINOR_VERSION = "0.0.11";
    public static final String FIREFOX_USER_AGENT_HEADER = "Mozilla/5.0 Mac Gecko/20071127 Firefox/2.0.0.11";
    public static final String FORWARDED_IP = "127.0.0.1";
    public static final String HOMEPAGE_STAGE_ID = "homestage";
    public static final String INEXISTENT_MOCKUP_STAGE_ID = "inexistentmockupteststage";
    public static final String LOCALE_EVALUATION_ACCEPT_LANGUAGE_HEADER = "en-gb";
    public static final String MAC_OS = "Mac - Mac_PowerPC ";
    public static final String MAIN_VERSION_UNKNOWN = "666";
    public static final String METHOD_GET = "GET";
    public static final String MINOR_VERSION_UNKNOWN = "666";
    public static final String MOZILLA_MAIN_VERSION = "5";
    public static final String MOZILLA_MINOR_VERSION = "0";
    public static final String MOZILLA_USER_AGENT_HEADER = "Mozilla/5.0 Mac - Mac_PowerPC  Gecko/20071127 Firefox/2.0.0.11";
    public static final String MSIE_MAIN_VERSION = "7";
    public static final String MSIE_MINOR_VERSION = "0b";
    public static final String MSIE_USER_AGENT_HEADER = "Mozilla/7.0b (compatible; MSIE 7.0b; Windows 98)";
    public static final String OPERA_MAIN_VERSION = "9";
    public static final String OPERA_MINOR_VERSION = "5";
    public static final String OPERA_USER_AGENT_HEADER = "Opera/9.5 (compatible; Opera 9.5; Windows NT)";
    public static final String SESSION_ID = "testSession";
    public static final String TRUE = Boolean.TRUE.toString().toLowerCase();
    public static final String UNKNOWN_MAC_OS = "Other Mac";
    public static final String UNKNOWN_MAC_USER_AGENT_HEADER = "Unknown/666.666 (compatible; Unknown; Other Mac)";
    public static final String UNKNOWN_MACINTOSH_USER_AGENT_HEADER = "Unknown/666.666 (compatible; Unknown; Macintosh)";
    public static final String UNKNOWN_OS = "unknown";
    public static final String UNKNOWN_USER_AGENT_HEADER = "Unknown/666.666 (compatible; Unknown; unknown)";
    public static final String UNKNOWN_WIN16_USER_AGENT_HEADER = "Unknown/666.666 (compatible; Unknown; Windows 3.x)";
    public static final String UNKNOWN_WIN95_USER_AGENT_HEADER = "Unknown/666.666 (compatible; Unknown; Windows 95)";

    public static HttpServletRequest createHttpServletRequestMock(Map<String, String> parameters, Map<String, Object> attributes) {
        return WebAncillaries.createHttpServletRequestMock(parameters, attributes, null);
    }

    public static HttpServletRequest createHttpServletRequestMock(Map<String, String> parameters, Map<String, Object> attributes, Map<String, Object> sessionAttributes) {
        HttpServletRequest request = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        if (parameters != null && parameters.size() > 0) {
            Vector<String> parameterNames = new Vector<String>();
            for (String parameterName : parameters.keySet()) {
                EasyMock.expect((Object)request.getParameter(parameterName)).andReturn((Object)parameters.get(parameterName)).anyTimes();
                parameterNames.add(parameterName);
            }
            EasyMock.expect((Object)request.getParameterNames()).andReturn(parameterNames.elements());
        }
        if (attributes != null && attributes.size() > 0) {
            Vector<String> attributeNames = new Vector<String>();
            for (String attributeName : attributes.keySet()) {
                EasyMock.expect((Object)request.getAttribute(attributeName)).andReturn(attributes.get(attributeName)).anyTimes();
                attributeNames.add(attributeName);
            }
            EasyMock.expect((Object)request.getAttributeNames()).andReturn(attributeNames.elements());
        }
        EasyMock.expect((Object)request.getSession()).andReturn((Object)WebAncillaries.createHttpSessionMock(sessionAttributes)).anyTimes();
        EasyMock.expect((Object)request.getMethod()).andReturn((Object)METHOD_GET).anyTimes();
        EasyMock.expect((Object)request.getHeader("User-Agent")).andReturn((Object)MOZILLA_USER_AGENT_HEADER).anyTimes();
        EasyMock.expect((Object)request.getHeader("Accept-Language")).andReturn((Object)ACCEPT_LANGUAGE_HEADER).anyTimes();
        EasyMock.replay((Object)request);
        return request;
    }

    public static HttpServletResponse createHttpServletResponseMock() {
        HttpServletResponse response = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        EasyMock.replay((Object)response);
        return response;
    }

    public static HttpSession createHttpSessionMock(Map<String, Object> sessionAttributes) {
        HttpSession session = (HttpSession)EasyMock.createMock(HttpSession.class);
        EasyMock.expect((Object)session.getId()).andReturn((Object)SESSION_ID);
        if (sessionAttributes != null && sessionAttributes.size() > 0) {
            Vector<String> attributeNames = new Vector<String>();
            for (String attributeName : sessionAttributes.keySet()) {
                EasyMock.expect((Object)session.getAttribute(attributeName)).andReturn(sessionAttributes.get(attributeName)).anyTimes();
                session.removeAttribute(attributeName);
                attributeNames.add(attributeName);
            }
            EasyMock.expect((Object)session.getAttributeNames()).andReturn(attributeNames.elements());
        }
        EasyMock.replay((Object)session);
        return session;
    }

    public static RequestDispatcher createRequestDispatcherMock() {
        RequestDispatcher dispatcher = (RequestDispatcher)EasyMock.createNiceMock(RequestDispatcher.class);
        EasyMock.replay((Object)dispatcher);
        return dispatcher;
    }

    public static ServletConfig createServletConfigMock(String viewPath) {
        ServletConfig servletConfig = (ServletConfig)EasyMock.createNiceMock(ServletConfig.class);
        EasyMock.expect((Object)servletConfig.getServletContext()).andReturn((Object)WebAncillaries.createServletContextMock(viewPath)).anyTimes();
        EasyMock.replay((Object)servletConfig);
        return servletConfig;
    }

    public static ServletContext createServletContextMock(String viewPath) {
        ServletContext servletContext = (ServletContext)EasyMock.createNiceMock(ServletContext.class);
        EasyMock.expect((Object)servletContext.getRequestDispatcher(viewPath)).andReturn((Object)WebAncillaries.createRequestDispatcherMock()).anyTimes();
        EasyMock.replay((Object)servletContext);
        return servletContext;
    }
}

