/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.web.ancillaries;

/**
 * Defines the constants found on browser-related information.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/01/29
 */
public class WebConstants {

    /** The 'Accept Language' header. */
    final static public String ACCEPT_LANGUAGE_HEADER = "Accept-Language";

    /** The 'Chrome' brand. */
    final static public String CHROME_NAME = "Chrome";

    /** The ',' character as a String. */
    final static public String COMMA = ",";

    /** The '-' character as a String. */
    final static public String DASH = "-";

    /** The '.' character as a String. */
    final static public String DOT = ".";

    /** The empty String. */
    final static public String EMPTY_STRING = "";

    /** The 'Firefox' brand. */
    final static public String FIREFOX_NAME = "Firefox";

    /** The IP forward header. */
    final static public String FORWARDED_IP = "x-forwarded-for";

    /** The 'English' language. */
    final static public String LANG_EN = "en";

    /** The 'English' language. */
    final static public String LANG_EN_GB = "en-gb";

    /** The 'Portuguese' language. */
    final static public String LANG_PT = "pt";

    /** The 'Macintosh' name. */
    final static public String MAC_NAME = "Macintosh";

    /** The 'Mac Power PC' name. */
    final static public String MAC_PPC_NAME = "Macintosh Power PC";

    /** The 'Mac Power PC' tag. */
    final static public String MAC_PPC_TAG = "mac_powerpc";

    /** The 'Mac Power PC' short tag. */
    final static public String MAC_PPC_TAG_SHORT = "mac_ppc";

    /** The 'Macintosh' tag. */
    final static public String MAC_TAG = "macintosh";

    /** The 'Mac' short tag. */
    final static public String MAC_TAG_SHORT = "mac";

    /** The 'Microsoft' brand. */
    final static public String MICROSOFT_BRAND = "Microsoft";

    /** The 'Mozilla' browser id tag. */
    final static public String MOZILLA_TAG = "mozilla";

    /** The 'MS Internet Explorer' browser name. */
    final static public String MSIE_NAME = "Microsoft Internet Explorer";

    /** The 'MS Internet Explorer' browser id tag. */
    final static public String MSIE_TAG = "msie";

    /** The 'Netscape' brand. */
    final static public String NETSCAPE_BRAND = "Netscape Communications";

    /** The 'Netscape' brand. */
    final static public String NETSCAPE_NAME = "Netscape Navigator";

    /** The 'Opera' brand. */
    final static public String OPERA_BRAND = "Opera Software";

    /** The 'Opera' browser name. */
    final static public String OPERA_NAME = "Opera Software Opera";

    /** The 'Opera' browser id tag. */
    final static public String OPERA_TAG = "opera";

    /** The 'Safari' brand. */
    final static public String SAFARI_NAME = "Safari";

    /** The ';' character as a String. */
    final static public String SEMICOLON = ";";

    /** The '/' character as a String. */
    final static public String SLASH = "/";

    /** The ' ' character as a String. */
    final static public String SPACE = " ";

    /** The 'unknown' value. */
    final static public String UNKNOWN = "unknown";

    /** The 'Unknown Mac' tag. */
    final static public String UNKNOWN_MAC = "Unknown Mac";

    /** The 'User Agent' header. */
    final static public String USER_AGENT_HEADER = "User-Agent";

    /** The 'Windows' short tag. */
    final static public String WIN_TAG_SHORT = "win";

    /** The 'Windows NT' name. */
    final static public String WIN16_NAME = "Windows 3.x";

    /** The 'Windows 3.x' tag. */
    final static public String WIN16_TAG = "windows 3.";

    /** The 'Windows 3.x' short tag. */
    final static public String WIN16_TAG_SHORT = "win16";

    /** The 'Windows 95' name. */
    final static public String WIN95_NAME = "Windows 95";

    /** The 'Windows 95' tag. */
    final static public String WIN95_TAG = "windows 95";

    /** The 'Windows 95' short tag. */
    final static public String WIN95_TAG_SHORT = "win95";

    /** The 'Windows 98' name. */
    final static public String WIN98_NAME = "Windows 98";

    /** The 'Windows 98' tag. */
    final static public String WIN98_TAG = "windows 98";

    /** The 'Windows 98' short tag. */
    final static public String WIN98_TAG_SHORT = "win98";

    /** The 'Windows NT' name. */
    final static public String WINNT_NAME = "Windows NT";

    /** The 'Windows NT' tag. */
    final static public String WINNT_TAG = "windows nt";

    /** The 'Windows NT' short tag. */
    final static public String WINNT_TAG_SHORT = "winnt";

}
