/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SourceMapInput {
    private static final Logger logger = Logger.getLogger(SourceMapInput.class.getName());
    private SourceFile sourceFile;
    private SourceMapConsumerV3 parsedSourceMap = null;

    public SourceMapInput(SourceFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceMapConsumerV3 getSourceMap() {
        if (this.parsedSourceMap == null) {
            SourceMapInput sourceMapInput = this;
            synchronized (sourceMapInput) {
                if (this.parsedSourceMap == null) {
                    this.parsedSourceMap = new SourceMapConsumerV3();
                    try {
                        this.parsedSourceMap.parse(this.sourceFile.getCode());
                    }
                    catch (SourceMapParseException | IOException parseFailure) {
                        logger.log(Level.WARNING, "Failed to parse sourcemap", parseFailure);
                    }
                }
            }
        }
        return this.parsedSourceMap;
    }

    public String getOriginalPath() {
        return this.sourceFile.getOriginalPath();
    }
}

