/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.Collection;

class TypeTransformation {
    private AbstractCompiler compiler;
    private JSTypeRegistry typeRegistry;
    static final DiagnosticType UNKNOWN_TYPEVAR = DiagnosticType.warning("TYPEVAR_UNDEFINED", "Reference to an unknown type variable {0}");
    static final DiagnosticType UNKNOWN_TYPENAME = DiagnosticType.warning("TYPENAME_UNDEFINED", "Reference to an unknown type name {0}");
    static final DiagnosticType BASETYPE_INVALID = DiagnosticType.warning("BASETYPE_INVALID", "The type {0} cannot be templatized");
    static final DiagnosticType TEMPTYPE_INVALID = DiagnosticType.warning("TEMPTYPE_INVALID", "Expected templatized type in {0} found {1}");
    static final DiagnosticType INDEX_OUTOFBOUNDS = DiagnosticType.warning("INDEX_OUTOFBOUNDS", "Index out of bounds in templateTypeOf: {0} > {1}");

    TypeTransformation(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
    }

    private boolean isTypeVar(Node n) {
        return n.isName();
    }

    private boolean isTypeName(Node n) {
        return n.isString();
    }

    private TypeTransformationParser.Keywords nameToKeyword(String s) {
        return TypeTransformationParser.Keywords.valueOf(s.toUpperCase());
    }

    private JSType getType(String name) {
        return this.typeRegistry.getType(name);
    }

    private JSType getNativeType(JSTypeNative type) {
        return this.typeRegistry.getNativeObjectType(type);
    }

    private boolean isTemplatizable(JSType type) {
        return this.typeRegistry.isTemplatizable(type);
    }

    private JSType getUnknownType() {
        return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    private JSType getNoType() {
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    private JSType createUnionType(JSType ... variants) {
        return this.typeRegistry.createUnionType(variants);
    }

    private JSType createTemplatizedType(ObjectType baseType, JSType[] params) {
        return this.typeRegistry.createTemplatizedType(baseType, params);
    }

    private void reportWarning(Node n, DiagnosticType msg, String ... param) {
        this.compiler.report(JSError.make(n, msg, param));
    }

    private ImmutableMap<String, JSType> addNewVar(ImmutableMap<String, JSType> typeVars, String name, JSType type) {
        return new ImmutableMap.Builder().putAll(typeVars).put((Object)name, (Object)type).build();
    }

    private String getFunctionParameter(Node functionNode, int index) {
        return functionNode.getChildAtIndex(1).getChildAtIndex(index).getString();
    }

    private Node getCallArgument(Node n, int i) {
        return n.isCall() ? n.getChildAtIndex(i + 1) : null;
    }

    private ImmutableList<Node> getParameters(Node operation) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 1; i < operation.getChildCount(); ++i) {
            builder.add((Object)operation.getChildAtIndex(i));
        }
        return builder.build();
    }

    JSType eval(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        if (this.isTypeName(ttlAst)) {
            return this.evalTypeName(ttlAst);
        }
        if (this.isTypeVar(ttlAst)) {
            return this.evalTypeVar(ttlAst, typeVars);
        }
        String name = ttlAst.getFirstChild().getString();
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case TYPE_CONSTRUCTOR: {
                return this.evalTypeExpression(ttlAst, typeVars);
            }
            case OPERATION: {
                return this.evalOperationExpression(ttlAst, typeVars);
            }
        }
        throw new IllegalStateException("Could not evaluate the type transformation expression");
    }

    private JSType evalOperationExpression(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        String name = ttlAst.getFirstChild().getString();
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case COND: {
                return this.evalConditional(ttlAst, typeVars);
            }
            case MAPUNION: {
                return this.evalMapunion(ttlAst, typeVars);
            }
        }
        throw new IllegalStateException("Invalid type transformation operation");
    }

    private JSType evalTypeExpression(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        String name = ttlAst.getFirstChild().getString();
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case TYPE: {
                return this.evalTemplatizedType(ttlAst, typeVars);
            }
            case UNION: {
                return this.evalUnionType(ttlAst, typeVars);
            }
            case NONE: {
                return this.getNoType();
            }
            case RAWTYPEOF: {
                return this.evalRawTypeOf(ttlAst, typeVars);
            }
            case TEMPLATETYPEOF: {
                return this.evalTemplateTypeOf(ttlAst, typeVars);
            }
            case RECORD: {
                return this.evalRecordType(ttlAst, typeVars);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private JSType evalTypeName(Node ttlAst) {
        String typeName = ttlAst.getString();
        JSType resultingType = this.getType(typeName);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPENAME, typeName);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private JSType evalTemplatizedType(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<Node> params = this.getParameters(ttlAst);
        JSType firstParam = this.eval((Node)params.get(0), typeVars);
        if (!this.isTemplatizable(firstParam)) {
            this.reportWarning(ttlAst, BASETYPE_INVALID, firstParam.toString());
            return this.getUnknownType();
        }
        ObjectType baseType = firstParam.toObjectType();
        JSType[] templatizedTypes = new JSType[params.size() - 1];
        for (int i = 0; i < templatizedTypes.length; ++i) {
            templatizedTypes[i] = this.eval((Node)params.get(i + 1), typeVars);
        }
        return this.createTemplatizedType(baseType, templatizedTypes);
    }

    private JSType evalTypeVar(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        String typeVar = ttlAst.getString();
        JSType resultingType = (JSType)typeVars.get((Object)typeVar);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPEVAR, typeVar);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private JSType evalUnionType(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<Node> params = this.getParameters(ttlAst);
        int paramCount = params.size();
        JSType[] basicTypes = new JSType[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            basicTypes[i] = this.eval((Node)params.get(i), typeVars);
        }
        return this.createUnionType(basicTypes);
    }

    private boolean evalBoolean(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<Node> params = this.getParameters(ttlAst);
        JSType type0 = this.eval((Node)params.get(0), typeVars);
        JSType type1 = this.eval((Node)params.get(1), typeVars);
        String name = ttlAst.getFirstChild().getString();
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case EQ: {
                return type0.isEquivalentTo(type1);
            }
            case SUB: {
                return type0.isSubtype(type1);
            }
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private JSType evalConditional(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<Node> params = this.getParameters(ttlAst);
        if (this.evalBoolean((Node)params.get(0), typeVars)) {
            return this.eval((Node)params.get(1), typeVars);
        }
        return this.eval((Node)params.get(2), typeVars);
    }

    private JSType evalMapunion(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<Node> params = this.getParameters(ttlAst);
        Node unionParam = (Node)params.get(0);
        Node mapFunction = (Node)params.get(1);
        String paramName = this.getFunctionParameter(mapFunction, 0);
        Node mapFunctionBody = mapFunction.getChildAtIndex(2);
        JSType unionType = this.eval(unionParam, typeVars);
        if (!unionType.isUnionType()) {
            return this.eval(mapFunctionBody, this.addNewVar(typeVars, paramName, unionType));
        }
        Collection<JSType> unionElms = ((UnionType)unionType).getAlternates();
        int unionSize = unionElms.size();
        JSType[] newUnionElms = new JSType[unionSize];
        int i = 0;
        for (JSType elm : unionElms) {
            newUnionElms[i] = this.eval(mapFunctionBody, this.addNewVar(typeVars, paramName, elm));
            ++i;
        }
        return this.createUnionType(newUnionElms);
    }

    private JSType evalRawTypeOf(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<Node> params = this.getParameters(ttlAst);
        JSType type = this.eval((Node)params.get(0), typeVars);
        if (!type.isTemplatizedType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "rawTypeOf", type.toString());
            return this.getUnknownType();
        }
        return ((TemplatizedType)type).getReferencedType();
    }

    private JSType evalTemplateTypeOf(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ImmutableList<JSType> templateTypes;
        ImmutableList<Node> params = this.getParameters(ttlAst);
        JSType type = this.eval((Node)params.get(0), typeVars);
        if (!type.isTemplatizedType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "templateTypeOf", type.toString());
            return this.getUnknownType();
        }
        int index = (int)((Node)params.get(1)).getDouble();
        if (index > (templateTypes = ((TemplatizedType)type).getTemplateTypes()).size()) {
            this.reportWarning(ttlAst, INDEX_OUTOFBOUNDS, Integer.toString(index), Integer.toString(templateTypes.size()));
            return this.getUnknownType();
        }
        return (JSType)templateTypes.get(index);
    }

    private JSType evalRecordType(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        Node record = this.getCallArgument(ttlAst, 0);
        RecordTypeBuilder builder = new RecordTypeBuilder(this.typeRegistry);
        for (Node p : record.children()) {
            builder.addProperty(p.getString(), this.eval(p.getFirstChild(), typeVars), null);
        }
        return builder.build();
    }
}

