/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Scope;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Set;

public class BreakFuzzer
extends AbstractFuzzer {
    BreakFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        Scope scope = this.context.scopeManager.localScope();
        if (scope.loopNesting + scope.switchNesting > 0) {
            return budget >= 1;
        }
        return false;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        Node node = new Node(116);
        Scope localScope = this.context.scopeManager.localScope();
        double toLabel = this.getOwnConfig().optDouble("toLabel");
        if (budget > 1 && localScope.loopLabels.size() + localScope.otherLabels.size() > 0 && this.context.random.nextDouble() < toLabel) {
            node.addChildToBack(Node.newString(153, localScope.randomLabelForBreak(this.context.random)));
        }
        return node;
    }

    @Override
    protected String getConfigName() {
        return "break";
    }
}

