/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.DoWhileFuzzer;
import com.google.javascript.jscomp.fuzzing.ForFuzzer;
import com.google.javascript.jscomp.fuzzing.ForInFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Scope;
import com.google.javascript.jscomp.fuzzing.StatementFuzzer;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.jscomp.fuzzing.WhileFuzzer;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Set;

public class LabelFuzzer
extends AbstractFuzzer {
    LabelFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 3;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        String labelName = "x_" + this.context.snGenerator.getNextNumber();
        Node name = Node.newString(153, labelName);
        StatementFuzzer stmtFuzzer = new StatementFuzzer(this.context);
        AbstractFuzzer selectedFuzzer = stmtFuzzer.selectFuzzer(budget - 2, types);
        Scope localScope = this.context.scopeManager.localScope();
        ArrayList<String> currentLabels = selectedFuzzer instanceof ForFuzzer || selectedFuzzer instanceof ForInFuzzer || selectedFuzzer instanceof WhileFuzzer || selectedFuzzer instanceof DoWhileFuzzer ? localScope.loopLabels : localScope.otherLabels;
        currentLabels.add(labelName);
        Node node = new Node(126, name, selectedFuzzer.generate(budget - 2));
        currentLabels.remove(labelName);
        return node;
    }

    @Override
    protected String getConfigName() {
        return "label";
    }
}

