/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.TypeWithProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ObjectType
implements TypeWithProperties {
    private final NominalType nominalType;
    private final FunctionType fn;
    private final boolean isLoose;
    private final PersistentMap<String, Property> props;
    private final ObjectKind objectKind;
    static final ObjectType TOP_OBJECT = ObjectType.makeObjectType(null, null, null, false, ObjectKind.UNRESTRICTED);
    static final ObjectType TOP_STRUCT = ObjectType.makeObjectType(null, null, null, false, ObjectKind.STRUCT);
    static final ObjectType TOP_DICT = ObjectType.makeObjectType(null, null, null, false, ObjectKind.DICT);

    private ObjectType(NominalType nominalType, PersistentMap<String, Property> props, FunctionType fn, boolean isLoose, ObjectKind objectKind) {
        Preconditions.checkArgument((fn == null || fn.isLoose() == isLoose ? 1 : 0) != 0, (String)"isLoose: %s, fn: %s", (Object[])new Object[]{isLoose, fn});
        Preconditions.checkArgument((nominalType == null || !isLoose ? 1 : 0) != 0);
        Preconditions.checkArgument((nominalType == null || fn == null ? 1 : 0) != 0, (String)"Cannot create object of %s that is callable", (Object[])new Object[]{nominalType});
        this.nominalType = nominalType;
        this.props = props;
        this.fn = fn;
        this.isLoose = isLoose;
        this.objectKind = objectKind;
    }

    static ObjectType makeObjectType(NominalType nominalType, PersistentMap<String, Property> props, FunctionType fn, boolean isLoose, ObjectKind ok) {
        if (props == null) {
            props = PersistentMap.create();
        }
        return new ObjectType(nominalType, props, fn, isLoose, ok);
    }

    static ObjectType fromFunction(FunctionType fn) {
        return ObjectType.makeObjectType(null, null, fn, fn.isLoose(), ObjectKind.UNRESTRICTED);
    }

    public static ObjectType fromNominalType(NominalType cl) {
        return ObjectType.makeObjectType(cl, null, null, false, cl.getObjectKind());
    }

    static ObjectType fromProperties(Map<String, JSType> propTypes) {
        PersistentMap<String, Property> props = PersistentMap.create();
        for (Map.Entry<String, JSType> propTypeEntry : propTypes.entrySet()) {
            String propName = propTypeEntry.getKey();
            JSType propType = propTypeEntry.getValue();
            props = props.with(propName, Property.make(propType, propType));
        }
        return ObjectType.makeObjectType(null, props, null, false, ObjectKind.UNRESTRICTED);
    }

    boolean isInhabitable() {
        for (Property p : this.props.values()) {
            if (!p.getType().isBottom()) continue;
            return false;
        }
        return true;
    }

    boolean isRecordType() {
        return this.nominalType == null && this.fn == null && !this.isLoose;
    }

    boolean isStruct() {
        return this.objectKind.isStruct();
    }

    boolean isLoose() {
        return this.isLoose;
    }

    boolean isLooseStruct() {
        return this.isLoose && this.objectKind.isStruct();
    }

    boolean isDict() {
        return this.objectKind.isDict();
    }

    static ImmutableSet<ObjectType> withLooseObjects(Set<ObjectType> objs) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withLoose());
        }
        return newObjs.build();
    }

    private ObjectType withLoose() {
        if (this.nominalType != null) {
            return this;
        }
        FunctionType fn = this.fn == null ? null : this.fn.withLoose();
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String pname : this.props.keySet()) {
            newProps = newProps.with(pname, ((Property)this.props.get(pname)).withRequired());
        }
        return ObjectType.makeObjectType(this.nominalType, newProps, fn, true, this.objectKind);
    }

    static ImmutableSet<ObjectType> withoutProperty(Set<ObjectType> objs, QualifiedName qname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, null));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyHelper(QualifiedName qname, JSType type, boolean isDeclared, boolean isConstant) {
        PersistentMap<String, Property> newProps = this.props;
        if (qname.isIdentifier()) {
            String pname = qname.getLeftmostName();
            JSType declType = this.getDeclaredProp(qname);
            if (type == null) {
                type = declType;
            }
            if (declType != null) {
                isDeclared = true;
                if (this.hasConstantProp(qname)) {
                    isConstant = true;
                }
                if (type != null && !type.isSubtypeOf(declType)) {
                    type = declType;
                }
            } else if (isDeclared) {
                declType = type;
            }
            newProps = type == null && declType == null ? newProps.without(pname) : newProps.with(pname, isConstant ? Property.makeConstant(type, declType) : Property.make(type, isDeclared ? declType : null));
        } else {
            String objName = qname.getLeftmostName();
            QualifiedName objQname = new QualifiedName(objName);
            if (!this.mayHaveProp(objQname)) {
                Preconditions.checkState((type == null ? 1 : 0) != 0);
                return this;
            }
            QualifiedName innerProps = qname.getAllButLeftmost();
            Property objProp = this.getLeftmostProp(objQname);
            JSType inferred = type == null ? objProp.getType().withoutProperty(innerProps) : objProp.getType().withProperty(innerProps, type);
            JSType declared = objProp.getDeclaredType();
            newProps = newProps.with(objName, objProp.isOptional() ? Property.makeOptional(inferred, declared) : Property.make(inferred, declared));
        }
        return ObjectType.makeObjectType(this.nominalType, newProps, this.fn, this.isLoose, this.objectKind);
    }

    ObjectType withProperty(QualifiedName qname, JSType type) {
        return this.withPropertyHelper(qname, type, false, false);
    }

    static ImmutableSet<ObjectType> withProperty(Set<ObjectType> objs, QualifiedName qname, JSType type) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, type));
        }
        return newObjs.build();
    }

    static ImmutableSet<ObjectType> withDeclaredProperty(Set<ObjectType> objs, QualifiedName qname, JSType type, boolean isConstant) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withPropertyHelper(qname, type, true, isConstant));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyRequired(String pname) {
        Property oldProp = (Property)this.props.get(pname);
        Property newProp = oldProp == null ? Property.make(JSType.UNKNOWN, null) : Property.make(oldProp.getType(), oldProp.getDeclaredType());
        return ObjectType.makeObjectType(this.nominalType, this.props.with(pname, newProp), this.fn, this.isLoose, this.objectKind);
    }

    static ImmutableSet<ObjectType> withPropertyRequired(Set<ObjectType> objs, String pname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withPropertyRequired(pname));
        }
        return newObjs.build();
    }

    private static PersistentMap<String, Property> meetPropsHelper(boolean specializeProps1, NominalType resultNominalType, PersistentMap<String, Property> props1, PersistentMap<String, Property> props2) {
        String pname;
        PersistentMap<String, Property> newProps = props1;
        if (resultNominalType != null) {
            for (Map.Entry propsEntry : props1.entrySet()) {
                pname = (String)propsEntry.getKey();
                Property nomProp = resultNominalType.getProp(pname);
                if (nomProp == null) continue;
                newProps = ObjectType.addOrRemoveProp(newProps, pname, nomProp, (Property)propsEntry.getValue());
            }
        }
        for (Map.Entry propsEntry : props2.entrySet()) {
            Property newProp;
            pname = (String)propsEntry.getKey();
            Property prop2 = (Property)propsEntry.getValue();
            if (!props1.containsKey(pname)) {
                newProp = prop2;
            } else {
                Property prop1 = (Property)props1.get(pname);
                if (prop1.equals(prop2)) continue;
                Property property = newProp = specializeProps1 ? prop1.specialize(prop2) : Property.meet(prop1, prop2);
            }
            if (resultNominalType != null && resultNominalType.getProp(pname) != null) {
                Property nomProp = resultNominalType.getProp(pname);
                newProps = ObjectType.addOrRemoveProp(newProps, pname, nomProp, newProp);
                continue;
            }
            newProps = newProps.with(pname, newProp);
        }
        return newProps;
    }

    private static PersistentMap<String, Property> addOrRemoveProp(PersistentMap<String, Property> props, String pname, Property nomProp, Property objProp) {
        JSType propType = objProp.getType();
        JSType nomPropType = nomProp.getType();
        if (!propType.isUnknown() && propType.isSubtypeOf(nomPropType) && !propType.equals(nomPropType)) {
            return props.with(pname, nomProp.specialize(objProp));
        }
        return props.without(pname);
    }

    private static PersistentMap<String, Property> joinProps(Map<String, Property> props1, Map<String, Property> props2) {
        String pname;
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry<String, Property> propsEntry : props1.entrySet()) {
            pname = propsEntry.getKey();
            if (props2.containsKey(pname)) continue;
            newProps = newProps.with(pname, propsEntry.getValue().withOptional());
        }
        for (Map.Entry<String, Property> propsEntry : props2.entrySet()) {
            pname = propsEntry.getKey();
            Property prop2 = propsEntry.getValue();
            if (props1.containsKey(pname)) {
                newProps = newProps.with(pname, Property.join(props1.get(pname), prop2));
                continue;
            }
            newProps = newProps.with(pname, prop2.withOptional());
        }
        return newProps;
    }

    private static PersistentMap<String, Property> joinPropsLoosely(Map<String, Property> props1, Map<String, Property> props2) {
        String pname;
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry<String, Property> propsEntry : props1.entrySet()) {
            pname = propsEntry.getKey();
            if (props2.containsKey(pname)) continue;
            newProps = newProps.with(pname, propsEntry.getValue().withRequired());
        }
        for (Map.Entry<String, Property> propsEntry : props2.entrySet()) {
            pname = propsEntry.getKey();
            Property prop2 = propsEntry.getValue();
            if (props1.containsKey(pname)) {
                newProps = newProps.with(pname, Property.join(props1.get(pname), prop2).withRequired());
                continue;
            }
            newProps = newProps.with(pname, prop2.withRequired());
        }
        return newProps;
    }

    static boolean isUnionSubtype(boolean keepLoosenessOfThis, Set<ObjectType> objs1, Set<ObjectType> objs2) {
        for (ObjectType obj1 : objs1) {
            boolean foundSupertype = false;
            for (ObjectType obj2 : objs2) {
                if (!obj1.isSubtypeOf(keepLoosenessOfThis, obj2)) continue;
                foundSupertype = true;
                break;
            }
            if (foundSupertype) continue;
            return false;
        }
        return true;
    }

    boolean isSubtypeOf(ObjectType obj2) {
        return this.isSubtypeOf(true, obj2);
    }

    boolean isSubtypeOf(boolean keepLoosenessOfThis, ObjectType obj2) {
        if (obj2 == TOP_OBJECT) {
            return true;
        }
        if (keepLoosenessOfThis && this.isLoose || obj2.isLoose) {
            return this.isLooseSubtypeOf(obj2);
        }
        if (this.nominalType == null && obj2.nominalType != null || this.nominalType != null && obj2.nominalType != null && !this.nominalType.isSubclassOf(obj2.nominalType)) {
            return false;
        }
        if (!this.objectKind.isSubtypeOf(obj2.objectKind)) {
            return false;
        }
        for (Map.Entry entry : obj2.props.entrySet()) {
            String pname = (String)entry.getKey();
            Property prop2 = (Property)entry.getValue();
            Property prop1 = this.getLeftmostProp(new QualifiedName(pname));
            if (!(prop2.isOptional() ? prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType()) : prop1 == null || prop1.isOptional() || !prop1.getType().isSubtypeOf(prop2.getType()))) continue;
            return false;
        }
        if (obj2.fn == null) {
            return true;
        }
        if (this.fn == null) {
            return false;
        }
        return this.fn.isSubtypeOf(obj2.fn);
    }

    boolean isLooseSubtypeOf(ObjectType obj2) {
        Preconditions.checkState((this.isLoose || obj2.isLoose ? 1 : 0) != 0);
        if (obj2 == TOP_OBJECT) {
            return true;
        }
        if (!this.isLoose) {
            if (!this.objectKind.isSubtypeOf(obj2.objectKind)) {
                return false;
            }
            for (String pname : obj2.props.keySet()) {
                QualifiedName qname = new QualifiedName(pname);
                if (this.mayHaveProp(qname) && this.getProp(qname).isSubtypeOf(obj2.getProp(qname))) continue;
                return false;
            }
        } else {
            for (String pname : this.props.keySet()) {
                QualifiedName qname = new QualifiedName(pname);
                if (!obj2.mayHaveProp(qname) || this.getProp(qname).isSubtypeOf(obj2.getProp(qname))) continue;
                return false;
            }
        }
        if (obj2.fn == null) {
            return true;
        }
        if (this.fn == null) {
            return false;
        }
        return this.fn.isLooseSubtypeOf(obj2.fn);
    }

    ObjectType specialize(ObjectType other) {
        Preconditions.checkState((boolean)ObjectType.areRelatedClasses(this.nominalType, other.nominalType));
        NominalType resultNominalType = NominalType.pickSubclass(this.nominalType, other.nominalType);
        if (resultNominalType != null) {
            if (this.fn != null || other.fn != null) {
                return null;
            }
            return ObjectType.makeObjectType(resultNominalType, ObjectType.meetPropsHelper(true, resultNominalType, this.props, other.props), null, false, ObjectKind.meet(this.objectKind, other.objectKind));
        }
        return ObjectType.makeObjectType(null, ObjectType.meetPropsHelper(true, null, this.props, other.props), this.fn == null ? null : this.fn.specialize(other.fn), this.isLoose, ObjectKind.meet(this.objectKind, other.objectKind));
    }

    static ObjectType meet(ObjectType obj1, ObjectType obj2) {
        Preconditions.checkState((boolean)ObjectType.areRelatedClasses(obj1.nominalType, obj2.nominalType));
        NominalType resultNominalType = NominalType.pickSubclass(obj1.nominalType, obj2.nominalType);
        FunctionType fn = FunctionType.meet(obj1.fn, obj2.fn);
        boolean isLoose = obj1.isLoose && obj2.isLoose || fn != null && fn.isLoose();
        PersistentMap<String, Property> props = isLoose ? ObjectType.joinPropsLoosely(obj1.props, obj2.props) : ObjectType.meetPropsHelper(false, resultNominalType, obj1.props, obj2.props);
        return ObjectType.makeObjectType(resultNominalType, props, fn, isLoose, ObjectKind.meet(obj1.objectKind, obj2.objectKind));
    }

    static ObjectType join(ObjectType obj1, ObjectType obj2) {
        PersistentMap<String, Property> props;
        Preconditions.checkState((boolean)ObjectType.areRelatedClasses(obj1.nominalType, obj2.nominalType));
        if (obj1.equals(obj2)) {
            return obj1;
        }
        boolean isLoose = obj1.isLoose || obj2.isLoose;
        FunctionType fn = FunctionType.join(obj1.fn, obj2.fn);
        if (isLoose) {
            fn = fn == null ? null : fn.withLoose();
            props = ObjectType.joinPropsLoosely(obj1.props, obj2.props);
        } else {
            props = ObjectType.joinProps(obj1.props, obj2.props);
        }
        return ObjectType.makeObjectType(NominalType.pickSuperclass(obj1.nominalType, obj2.nominalType), props, fn, isLoose, ObjectKind.join(obj1.objectKind, obj2.objectKind));
    }

    static ImmutableSet<ObjectType> joinSets(ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2) {
        if (objs1 == null) {
            return objs2;
        }
        if (objs2 == null) {
            return objs1;
        }
        ObjectType[] objs1Arr = (ObjectType[])objs1.toArray((Object[])new ObjectType[0]);
        ObjectType[] keptFrom1 = Arrays.copyOf(objs1Arr, objs1Arr.length);
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj2 : objs2) {
            boolean addedObj2 = false;
            for (int i = 0; i < objs1Arr.length; ++i) {
                ObjectType obj1 = objs1Arr[i];
                NominalType nominalType1 = obj1.nominalType;
                NominalType nominalType2 = obj2.nominalType;
                if (!ObjectType.areRelatedClasses(nominalType1, nominalType2)) continue;
                if (nominalType2 == null && nominalType1 != null && !obj1.isSubtypeOf(obj2) || nominalType1 == null && nominalType2 != null && !obj2.isSubtypeOf(obj1)) break;
                keptFrom1[i] = null;
                newObjs.add((Object)ObjectType.join(obj1, obj2));
                addedObj2 = true;
                break;
            }
            if (addedObj2) continue;
            newObjs.add((Object)obj2);
        }
        for (ObjectType o : keptFrom1) {
            if (o == null) continue;
            newObjs.add((Object)o);
        }
        return newObjs.build();
    }

    private static boolean areRelatedClasses(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return true;
        }
        return c1.isSubclassOf(c2) || c2.isSubclassOf(c1);
    }

    static ImmutableSet<ObjectType> meetSetsHelper(boolean specializeObjs1, Set<ObjectType> objs1, Set<ObjectType> objs2) {
        if (objs1 == null || objs2 == null) {
            return null;
        }
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        block0: for (ObjectType obj2 : objs2) {
            for (ObjectType obj1 : objs1) {
                ObjectType newObj;
                if (!ObjectType.areRelatedClasses(obj1.nominalType, obj2.nominalType)) continue;
                if (specializeObjs1) {
                    newObj = obj1.specialize(obj2);
                    if (newObj == null) {
                        continue;
                    }
                } else {
                    newObj = ObjectType.meet(obj1, obj2);
                }
                newObjs.add((Object)newObj);
                continue block0;
            }
        }
        return newObjs.build();
    }

    @VisibleForTesting
    static ImmutableSet<ObjectType> meetSets(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(false, objs1, objs2);
    }

    static ImmutableSet<ObjectType> specializeSet(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(true, objs1, objs2);
    }

    FunctionType getFunType() {
        return this.fn;
    }

    NominalType getNominalType() {
        return this.nominalType;
    }

    @Override
    public JSType getProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        if (qname.isIdentifier()) {
            return p == null ? JSType.UNDEFINED : p.getType();
        }
        Preconditions.checkState((p != null ? 1 : 0) != 0);
        return p.getType().getProp(qname.getAllButLeftmost());
    }

    @Override
    public JSType getDeclaredProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        if (p == null) {
            return null;
        }
        if (qname.isIdentifier()) {
            return p.isDeclared() ? p.getDeclaredType() : null;
        }
        return p.getType().getDeclaredProp(qname.getAllButLeftmost());
    }

    private Property getLeftmostProp(QualifiedName qname) {
        String objName = qname.getLeftmostName();
        Property p = (Property)this.props.get(objName);
        if (p == null && this.nominalType != null) {
            p = this.nominalType.getProp(objName);
        }
        return p;
    }

    @Override
    public boolean mayHaveProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        return p != null && (qname.isIdentifier() || p.getType().mayHaveProp(qname.getAllButLeftmost()));
    }

    @Override
    public boolean hasProp(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostProp(qname);
        return p != null && !p.isOptional();
    }

    @Override
    public boolean hasConstantProp(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostProp(qname);
        return p != null && p.isConstant();
    }

    static ObjectType unifyUnknowns(ObjectType t1, ObjectType t2) {
        if (t1.nominalType != t2.nominalType) {
            return null;
        }
        if (t1.fn != t2.fn) {
            throw new RuntimeException("Unification of functions not yet supported");
        }
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String propName : t1.props.keySet()) {
            Property prop1 = (Property)t1.props.get(propName);
            Property prop2 = (Property)t2.props.get(propName);
            if (prop2 == null) {
                return null;
            }
            Property p = Property.unifyUnknowns(prop1, prop2);
            if (p == null) {
                return null;
            }
            newProps = newProps.with(propName, p);
        }
        return ObjectType.makeObjectType(t1.nominalType, newProps, t1.fn, t1.isLoose || t2.isLoose, ObjectKind.join(t1.objectKind, t2.objectKind));
    }

    boolean unifyWith(ObjectType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        if (this.nominalType != null && other.nominalType != null) {
            return this.nominalType.unifyWith(other.nominalType, typeParameters, typeMultimap);
        }
        if (this.nominalType != null || other.nominalType != null) {
            return false;
        }
        if (!(this.fn == null || other.fn != null && this.fn.unifyWith(other.fn, typeParameters, typeMultimap))) {
            return false;
        }
        for (String propName : this.props.keySet()) {
            Property thisProp = (Property)this.props.get(propName);
            Property otherProp = (Property)other.props.get(propName);
            if (otherProp != null && thisProp.unifyWith(otherProp, typeParameters, typeMultimap)) continue;
            return false;
        }
        return true;
    }

    ObjectType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (concreteTypes.isEmpty() || !this.hasFreeTypeVars(new HashSet<String>())) {
            return this;
        }
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String p : this.props.keySet()) {
            newProps = newProps.with(p, ((Property)this.props.get(p)).substituteGenerics(concreteTypes));
        }
        return new ObjectType(this.nominalType == null ? null : this.nominalType.instantiateGenerics(concreteTypes), newProps, this.fn == null ? null : this.fn.substituteGenerics(concreteTypes), this.isLoose, this.objectKind);
    }

    boolean hasFreeTypeVars(Set<String> boundTypeVars) {
        if (this.nominalType != null && this.nominalType.hasFreeTypeVars(boundTypeVars) || this.fn != null && this.fn.hasFreeTypeVars(boundTypeVars)) {
            return true;
        }
        for (Property prop : this.props.values()) {
            if (!prop.hasFreeTypeVars(boundTypeVars)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (this.props.isEmpty() || this.props.size() == 1 && this.props.containsKey("prototype")) {
            if (this.fn != null) {
                return this.fn.appendTo(builder);
            }
            if (this.nominalType != null) {
                return this.nominalType.appendTo(builder);
            }
        }
        if (this.nominalType != null) {
            this.nominalType.appendTo(builder);
        } else if (this.isStruct()) {
            builder.append("struct");
        } else if (this.isDict()) {
            builder.append("dict");
        }
        if (this.nominalType == null || !this.props.isEmpty()) {
            builder.append('{');
            boolean firstIteration = true;
            for (String pname : new TreeSet(this.props.keySet())) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    builder.append(", ");
                }
                builder.append(pname);
                builder.append(':');
                ((Property)this.props.get(pname)).appendTo(builder);
            }
            builder.append('}');
        }
        if (this.isLoose) {
            builder.append(" (loose)");
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof ObjectType));
        ObjectType obj2 = (ObjectType)o;
        return Objects.equals(this.fn, obj2.fn) && Objects.equals(this.nominalType, obj2.nominalType) && Objects.equals(this.props, obj2.props);
    }

    public int hashCode() {
        return Objects.hash(this.fn, this.props, this.nominalType);
    }
}

