/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CleanupPasses;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerOptionsPreprocessor;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ES6ModuleLoader;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.FunctionInformationMap;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.GlobalVarReferenceMap;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.PrintStreamErrorManager;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessEs6Modules;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.jscomp.RecordFunctionInformation;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.SanityCheck;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceInformationAnnotator;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SuppressDocWarningsGuard;
import com.google.javascript.jscomp.SymbolTable;
import com.google.javascript.jscomp.SyntheticAst;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.TransformAMDToCJSModule;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ClosureReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.SemanticReverseAbstractInterpreter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class Compiler
extends AbstractCompiler {
    static final String SINGLETON_MODULE_NAME = "[singleton]";
    static final DiagnosticType MODULE_DEPENDENCY_ERROR = DiagnosticType.error("JSC_MODULE_DEPENDENCY_ERROR", "Bad dependency: {0} -> {1}. Modules must be listed in dependency order.");
    static final DiagnosticType MISSING_ENTRY_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "required entry point \"{0}\" never provided");
    static final DiagnosticType MISSING_MODULE_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "unknown module \"{0}\" specified in entry point spec");
    static final String PARSING_PASS_NAME = "parseInputs";
    static final String CROSS_MODULE_CODE_MOTION_NAME = "crossModuleCodeMotion";
    static final String CROSS_MODULE_METHOD_MOTION_NAME = "crossModuleMethodMotion";
    private static final String CONFIG_RESOURCE = "com.google.javascript.jscomp.parsing.ParserConfig";
    CompilerOptions options = null;
    private PassConfig passes = null;
    private List<CompilerInput> externs;
    private List<JSModule> modules;
    private JSModuleGraph moduleGraph;
    private List<CompilerInput> inputs;
    private ErrorManager errorManager;
    private WarningsGuard warningsGuard;
    private final Map<String, Node> injectedLibraries = new LinkedHashMap<String, Node>();
    Node externsRoot;
    Node jsRoot;
    Node externAndJsRoot;
    private CompilerOptions.LanguageMode languageMode = CompilerOptions.LanguageMode.ECMASCRIPT3;
    private Map<InputId, CompilerInput> inputsById;
    private Function<String, SourceFile> originalSourcesLoader = new Function<String, SourceFile>(){

        public SourceFile apply(String filename) {
            return SourceFile.fromFile(filename);
        }
    };
    private ConcurrentHashMap<String, SourceFile> sourceMapOriginalSources = new ConcurrentHashMap();
    private Map<String, List<Comment>> commentsPerFile = new HashMap<String, List<Comment>>();
    private SourceMap sourceMap;
    private String externExports = null;
    private int uniqueNameId = 0;
    private int timeout = 0;
    private boolean hasRegExpGlobalReferences = true;
    private FunctionInformationMap functionInformationMap;
    private final StringBuilder debugLog = new StringBuilder();
    CodingConvention defaultCodingConvention = new ClosureCodingConvention();
    private JSTypeRegistry typeRegistry;
    private Config parserConfig = null;
    private Config externsParserConfig = null;
    private ReverseAbstractInterpreter abstractInterpreter;
    private TypeValidator typeValidator;
    private PhaseOptimizer phaseOptimizer = null;
    public PerformanceTracker tracker;
    private GlobalTypeInfo symbolTable;
    private final ErrorReporter oldErrorReporter = RhinoErrorReporter.forOldRhino(this);
    private final ErrorReporter defaultErrorReporter = RhinoErrorReporter.forOldRhino(this);
    public static final DiagnosticType OPTIMIZE_LOOP_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of optimization iterations: {0}");
    public static final DiagnosticType MOTION_ITERATIONS_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of code motion iterations: {0}");
    private static final long COMPILER_STACK_SIZE = 0x200000L;
    private static final ExecutorService compilerExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(null, r, "jscompiler", 0x200000L);
        }
    });
    private Thread compilerThread = null;
    private boolean useThreads = true;
    private static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final PrintStream outStream;
    private GlobalVarReferenceMap globalRefMap = null;
    private volatile double progress = 0.0;
    private String lastPassName;
    private Set<String> externProperties = null;
    private static final DiagnosticType EMPTY_MODULE_LIST_ERROR = DiagnosticType.error("JSC_EMPTY_MODULE_LIST_ERROR", "At least one module must be provided");
    private static final DiagnosticType EMPTY_ROOT_MODULE_ERROR = DiagnosticType.error("JSC_EMPTY_ROOT_MODULE_ERROR", "Root module '{0}' must contain at least one source code input");
    static final DiagnosticType DUPLICATE_INPUT = DiagnosticType.error("JSC_DUPLICATE_INPUT", "Duplicate input: {0}");
    static final DiagnosticType DUPLICATE_EXTERN_INPUT = DiagnosticType.error("JSC_DUPLICATE_EXTERN_INPUT", "Duplicate extern input: {0}");
    private final PassFactory sanityCheck = new PassFactory("sanityCheck", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new SanityCheck(compiler);
        }
    };
    private Tracer currentTracer = null;
    private String currentPassName = null;
    private int syntheticCodeId = 0;
    protected final RecentChange recentChange = new RecentChange();
    private final List<CodeChangeHandler> codeChangeHandlers = new ArrayList<CodeChangeHandler>();
    static final String SYNTHETIC_EXTERNS = "{SyntheticVarsDeclar}";
    private CompilerInput synthesizedExternsInput = null;
    private ImmutableMap<String, Node> defaultDefineValues = ImmutableMap.of();

    public Compiler() {
        this((PrintStream)null);
    }

    public Compiler(PrintStream stream) {
        this.addChangeHandler(this.recentChange);
        this.outStream = stream;
    }

    public Compiler(ErrorManager errorManager) {
        this();
        this.setErrorManager(errorManager);
    }

    public void setErrorManager(ErrorManager errorManager) {
        Preconditions.checkNotNull((Object)errorManager, (Object)"the error manager cannot be null");
        this.errorManager = errorManager;
    }

    private MessageFormatter createMessageFormatter() {
        boolean colorize = this.options.shouldColorizeErrorOutput();
        return this.options.errorFormat.toFormatter(this, colorize);
    }

    @VisibleForTesting
    void setOriginalSourcesLoader(Function<String, SourceFile> originalSourcesLoader) {
        this.originalSourcesLoader = originalSourcesLoader;
    }

    public void initOptions(CompilerOptions options) {
        this.options = options;
        this.languageMode = options.getLanguageIn();
        if (this.errorManager == null) {
            if (this.outStream == null) {
                this.setErrorManager(new LoggerErrorManager(this.createMessageFormatter(), logger));
            } else {
                PrintStreamErrorManager printer = new PrintStreamErrorManager(this.createMessageFormatter(), this.outStream);
                printer.setSummaryDetailLevel(options.summaryDetailLevel);
                this.setErrorManager(printer);
            }
        }
        this.reconcileOptionsWithGuards();
        ImmutableList guards = ImmutableList.of((Object)new SuppressDocWarningsGuard(this.getDiagnosticGroups().getRegisteredGroups()), (Object)options.getWarningsGuard());
        this.warningsGuard = new ComposeWarningsGuard((List<WarningsGuard>)guards);
    }

    protected void reconcileOptionsWithGuards() {
        if (this.options.enables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = true;
        } else if (this.options.disables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = false;
        } else if (!this.options.checkTypes) {
            this.options.setWarningLevel(DiagnosticGroup.forType(RhinoErrorReporter.TYPE_PARSE_ERROR), CheckLevel.OFF);
        }
        if (this.options.checkGlobalThisLevel.isOn() && !this.options.disables(DiagnosticGroups.GLOBAL_THIS)) {
            this.options.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, this.options.checkGlobalThisLevel);
        }
        if (this.options.getLanguageIn().isStrict()) {
            this.options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.ERROR);
        }
        if (!this.options.checkSymbols && !this.options.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            this.options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF);
        }
    }

    public <T1 extends SourceFile, T2 extends SourceFile> void init(List<T1> externs, List<T2> inputs, CompilerOptions options) {
        JSModule module = new JSModule(SINGLETON_MODULE_NAME);
        for (SourceFile input : inputs) {
            module.add(input);
        }
        ArrayList<JSModule> modules = new ArrayList<JSModule>(1);
        modules.add(module);
        this.initModules(externs, modules, options);
    }

    public <T extends SourceFile> void initModules(List<T> externs, List<JSModule> modules, CompilerOptions options) {
        this.initOptions(options);
        this.checkFirstModule(modules);
        Compiler.fillEmptyModules(modules);
        this.externs = this.makeCompilerInput(externs, true);
        this.modules = modules;
        if (modules.size() > 1) {
            try {
                this.moduleGraph = new JSModuleGraph(modules);
            }
            catch (JSModuleGraph.ModuleDependenceException e) {
                this.report(JSError.make(MODULE_DEPENDENCY_ERROR, e.getModule().getName(), e.getDependentModule().getName()));
                return;
            }
        } else {
            this.moduleGraph = null;
        }
        this.inputs = Compiler.getAllInputsFromModules(modules);
        this.initBasedOnOptions();
        this.initInputsByIdMap();
        this.initAST();
    }

    private void initBasedOnOptions() {
        if (this.options.sourceMapOutputPath != null) {
            this.sourceMap = this.options.sourceMapFormat.getInstance();
            this.sourceMap.setPrefixMappings(this.options.sourceMapLocationMappings);
        }
    }

    private <T extends SourceFile> List<CompilerInput> makeCompilerInput(List<T> files, boolean isExtern) {
        ArrayList<CompilerInput> inputs = new ArrayList<CompilerInput>(files.size());
        for (SourceFile file : files) {
            inputs.add(new CompilerInput(file, isExtern));
        }
        return inputs;
    }

    private void checkFirstModule(List<JSModule> modules) {
        if (modules.isEmpty()) {
            this.report(JSError.make(EMPTY_MODULE_LIST_ERROR, new String[0]));
        } else if (modules.get(0).getInputs().isEmpty() && modules.size() > 1) {
            this.report(JSError.make(EMPTY_ROOT_MODULE_ERROR, modules.get(0).getName()));
        }
    }

    static String createFillFileName(String moduleName) {
        return "[" + moduleName + "]";
    }

    private static void fillEmptyModules(List<JSModule> modules) {
        for (JSModule module : modules) {
            if (!module.getInputs().isEmpty()) continue;
            module.add(SourceFile.fromCode(Compiler.createFillFileName(module.getName()), ""));
        }
    }

    public void rebuildInputsFromModules() {
        this.inputs = Compiler.getAllInputsFromModules(this.modules);
        this.initInputsByIdMap();
    }

    private static List<CompilerInput> getAllInputsFromModules(List<JSModule> modules) {
        ArrayList<CompilerInput> inputs = new ArrayList<CompilerInput>();
        HashMap<String, JSModule> inputMap = new HashMap<String, JSModule>();
        for (JSModule module : modules) {
            for (CompilerInput input : module.getInputs()) {
                String inputName = input.getName();
                inputs.add(input);
                inputMap.put(inputName, module);
            }
        }
        return inputs;
    }

    private String getRelativeTo(String relative, String base) {
        return FileSystems.getDefault().getPath(base, new String[0]).resolveSibling(relative).normalize().toString();
    }

    void initInputsByIdMap() {
        CompilerInput previous;
        InputId id;
        this.inputsById = new HashMap<InputId, CompilerInput>();
        for (CompilerInput input : this.externs) {
            id = input.getInputId();
            previous = this.putCompilerInput(id, input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_EXTERN_INPUT, input.getName()));
        }
        for (CompilerInput input : this.inputs) {
            id = input.getInputId();
            previous = this.putCompilerInput(id, input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_INPUT, input.getName()));
        }
    }

    private void initAST() {
        this.jsRoot = IR.block();
        this.jsRoot.setIsSyntheticBlock(true);
        this.externsRoot = IR.block();
        this.externsRoot.setIsSyntheticBlock(true);
        this.externAndJsRoot = IR.block(this.externsRoot, this.jsRoot);
        this.externAndJsRoot.setIsSyntheticBlock(true);
    }

    public Result compile(SourceFile extern, SourceFile input, CompilerOptions options) {
        return this.compile((List)ImmutableList.of((Object)extern), (List)ImmutableList.of((Object)input), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1 extends SourceFile, T2 extends SourceFile> Result compile(List<T1> externs, List<T2> inputs, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.init(externs, inputs, options);
            if (this.hasErrors()) {
                Result result = this.getResult();
                return result;
            }
            Result result = this.compile();
            return result;
        }
        finally {
            Tracer t = this.newTracer("generateReport");
            this.errorManager.generateReport();
            this.stopTracer(t, "generateReport");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SourceFile> Result compileModules(List<T> externs, List<JSModule> modules, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.initModules(externs, modules, options);
            if (this.hasErrors()) {
                Result result = this.getResult();
                return result;
            }
            Result result = this.compile();
            return result;
        }
        finally {
            Tracer t = this.newTracer("generateReport");
            this.errorManager.generateReport();
            this.stopTracer(t, "generateReport");
        }
    }

    private Result compile() {
        return this.runInCompilerThread(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                Compiler.this.compileInternal();
                return Compiler.this.getResult();
            }
        });
    }

    public void disableThreads() {
        this.useThreads = false;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runInCompilerThread(final Callable<T> callable) {
        T result = null;
        final Throwable[] exception = new Throwable[1];
        Preconditions.checkState((this.compilerThread == null || this.compilerThread == Thread.currentThread() ? 1 : 0) != 0, (Object)"Please do not share the Compiler across threads");
        if (this.useThreads && this.compilerThread == null) {
            try {
                final boolean dumpTraceReport = this.options != null && this.options.tracer.isOn();
                Callable bootCompilerThread = new Callable<T>(){

                    @Override
                    public T call() {
                        try {
                            Compiler.this.compilerThread = Thread.currentThread();
                            if (dumpTraceReport) {
                                Tracer.initCurrentThreadTrace();
                            }
                            Object v = callable.call();
                            return v;
                        }
                        catch (Throwable e) {
                            exception[0] = e;
                        }
                        finally {
                            Compiler.this.compilerThread = null;
                            if (dumpTraceReport) {
                                Tracer.logCurrentThreadTrace();
                            }
                            Tracer.clearCurrentThreadTrace();
                        }
                        return null;
                    }
                };
                Future future = compilerExecutor.submit(bootCompilerThread);
                if (this.timeout > 0) {
                    result = future.get(this.timeout, TimeUnit.SECONDS);
                }
                result = future.get();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            try {
                result = callable.call();
            }
            catch (Exception e) {
                exception[0] = e;
            }
            finally {
                Tracer.clearCurrentThreadTrace();
            }
        }
        if (exception[0] != null) {
            Throwables.propagate((Throwable)exception[0]);
        }
        return result;
    }

    private void compileInternal() {
        this.setProgress(0.0, null);
        CompilerOptionsPreprocessor.preprocess(this.options);
        this.parse();
        this.setProgress(0.15, "parse");
        if (this.hasErrors()) {
            return;
        }
        if (!this.precheck()) {
            return;
        }
        if (!this.options.skipAllPasses) {
            this.check();
            if (this.hasErrors()) {
                return;
            }
            if (!this.options.checksOnly && !this.options.ideMode) {
                this.optimize();
            }
        }
        if (this.options.recordFunctionInformation) {
            this.recordFunctionInformation();
        }
        if (this.options.devMode == CompilerOptions.DevMode.START_AND_END) {
            this.runSanityCheck();
        }
        this.setProgress(1.0, "recordFunctionInformation");
        if (this.tracker != null) {
            this.tracker.outputTracerReport(this.outStream == null ? System.out : this.outStream);
        }
    }

    public void parse() {
        this.parseInputs();
    }

    PassConfig getPassConfig() {
        if (this.passes == null) {
            this.passes = this.createPassConfigInternal();
        }
        return this.passes;
    }

    PassConfig createPassConfigInternal() {
        return new DefaultPassConfig(this.options);
    }

    public void setPassConfig(PassConfig passes) {
        Preconditions.checkNotNull((Object)passes);
        if (this.passes != null) {
            throw new IllegalStateException("this.passes has already been assigned");
        }
        this.passes = passes;
    }

    boolean precheck() {
        return true;
    }

    public void check() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        this.phaseOptimizer = new PhaseOptimizer(this, this.tracker, new PhaseOptimizer.ProgressRange(this.getProgress(), 1.0));
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            this.phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        if (this.options.getCheckDeterminism()) {
            this.phaseOptimizer.setPrintAstHashcodes(true);
        }
        this.phaseOptimizer.consume(this.getPassConfig().getChecks());
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
        if (!(!this.options.getTweakProcessing().shouldStrip() && this.options.stripTypes.isEmpty() && this.options.stripNameSuffixes.isEmpty() && this.options.stripTypePrefixes.isEmpty() && this.options.stripNamePrefixes.isEmpty())) {
            this.stripCode(this.options.stripTypes, this.options.stripNameSuffixes, this.options.stripTypePrefixes, this.options.stripNamePrefixes);
        }
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS);
        this.phaseOptimizer = null;
    }

    private void externExports() {
        logger.fine("Creating extern file for exports");
        this.startPass("externExports");
        ExternExportsPass pass = new ExternExportsPass(this);
        this.process(pass);
        this.externExports = pass.getGeneratedExterns();
        this.endPass();
    }

    @Override
    void process(CompilerPass p) {
        p.process(this.externsRoot, this.jsRoot);
    }

    private void maybeSanityCheck() {
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            this.runSanityCheck();
        }
    }

    private void runSanityCheck() {
        this.sanityCheck.create(this).process(this.externsRoot, this.jsRoot);
    }

    void stripCode(Set<String> stripTypes, Set<String> stripNameSuffixes, Set<String> stripTypePrefixes, Set<String> stripNamePrefixes) {
        logger.fine("Strip code");
        this.startPass("stripCode");
        StripCode r = new StripCode(this, stripTypes, stripNameSuffixes, stripTypePrefixes, stripNamePrefixes);
        if (this.options.getTweakProcessing().shouldStrip()) {
            r.enableTweakStripping();
        }
        this.process(r);
        this.endPass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomPasses(CustomPassExecutionTime executionTime) {
        if (this.options.customPasses != null) {
            Tracer t = this.newTracer("runCustomPasses");
            try {
                for (CompilerPass p : this.options.customPasses.get((Object)executionTime)) {
                    this.process(p);
                }
            }
            finally {
                this.stopTracer(t, "runCustomPasses");
            }
        }
    }

    void startPass(String passName) {
        Preconditions.checkState((this.currentTracer == null ? 1 : 0) != 0);
        this.currentPassName = passName;
        this.currentTracer = this.newTracer(passName);
    }

    void endPass() {
        Preconditions.checkState((this.currentTracer != null ? 1 : 0) != 0, (Object)"Tracer should not be null at the end of a pass.");
        this.stopTracer(this.currentTracer, this.currentPassName);
        this.currentPassName = null;
        this.currentTracer = null;
        this.maybeSanityCheck();
    }

    Tracer newTracer(String passName) {
        String comment = passName + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.options.tracer.isOn()) {
            this.tracker.recordPassStart(passName, true);
        }
        return new Tracer("Compiler", comment);
    }

    void stopTracer(Tracer t, String passName) {
        long result = t.stop();
        if (this.options.tracer.isOn()) {
            this.tracker.recordPassStop(passName, result);
        }
    }

    public Result getResult() {
        PassConfig.State state = this.getPassConfig().getIntermediateState();
        return new Result(this.getErrors(), this.getWarnings(), this.debugLog.toString(), state.variableMap, state.propertyMap, state.anonymousFunctionNameMap, state.stringMap, this.functionInformationMap, this.sourceMap, this.externExports, state.cssNames, state.idGeneratorMap);
    }

    public JSError[] getErrors() {
        if (this.errorManager == null) {
            return new JSError[0];
        }
        return this.errorManager.getErrors();
    }

    public JSError[] getWarnings() {
        if (this.errorManager == null) {
            return new JSError[0];
        }
        return this.errorManager.getWarnings();
    }

    @Override
    public Node getRoot() {
        return this.externAndJsRoot;
    }

    @Override
    CompilerOptions.LanguageMode getLanguageMode() {
        return this.languageMode;
    }

    @Override
    void setLanguageMode(CompilerOptions.LanguageMode mode) {
        this.languageMode = mode;
    }

    private int nextUniqueNameId() {
        return this.uniqueNameId++;
    }

    @VisibleForTesting
    void resetUniqueNameId() {
        this.uniqueNameId = 0;
    }

    @Override
    Supplier<String> getUniqueNameIdSupplier() {
        final Compiler self = this;
        return new Supplier<String>(){

            public String get() {
                return String.valueOf(self.nextUniqueNameId());
            }
        };
    }

    @Override
    boolean areNodesEqualForInlining(Node n1, Node n2) {
        if (this.options.ambiguateProperties || this.options.disambiguateProperties) {
            return n1.isEquivalentToTyped(n2);
        }
        return n1.isEquivalentTo(n2);
    }

    @Override
    public CompilerInput getInput(InputId id) {
        return this.inputsById.get(id);
    }

    protected void removeExternInput(InputId id) {
        CompilerInput input = this.getInput(id);
        if (input == null) {
            return;
        }
        Preconditions.checkState((boolean)input.isExtern(), (String)"Not an extern input: %s", (Object[])new Object[]{input.getName()});
        this.inputsById.remove(id);
        this.externs.remove(input);
        Node root = input.getAstRoot(this);
        if (root != null) {
            root.detachFromParent();
        }
    }

    @Override
    public CompilerInput newExternInput(String name) {
        SyntheticAst ast = new SyntheticAst(name);
        if (this.inputsById.containsKey(ast.getInputId())) {
            throw new IllegalArgumentException("Conflicting externs name: " + name);
        }
        CompilerInput input = new CompilerInput(ast, true);
        this.putCompilerInput(input.getInputId(), input);
        this.externsRoot.addChildToFront(ast.getAstRoot(this));
        this.externs.add(0, input);
        return input;
    }

    CompilerInput putCompilerInput(InputId id, CompilerInput input) {
        if (this.inputsById == null) {
            this.inputsById = new HashMap<InputId, CompilerInput>();
        }
        input.setCompiler(this);
        return this.inputsById.put(id, input);
    }

    boolean replaceIncrementalSourceAst(JsAst ast) {
        CompilerInput oldInput = this.getInput(ast.getInputId());
        Preconditions.checkNotNull((Object)oldInput, (String)"No input to replace: %s", (Object[])new Object[]{ast.getInputId().getIdName()});
        Node newRoot = ast.getAstRoot(this);
        if (newRoot == null) {
            return false;
        }
        Node oldRoot = oldInput.getAstRoot(this);
        if (oldRoot != null) {
            oldRoot.getParent().replaceChild(oldRoot, newRoot);
        } else {
            this.getRoot().getLastChild().addChildToBack(newRoot);
        }
        CompilerInput newInput = new CompilerInput(ast);
        this.putCompilerInput(ast.getInputId(), newInput);
        JSModule module = oldInput.getModule();
        if (module != null) {
            module.addAfter(newInput, oldInput);
            module.remove(oldInput);
        }
        Preconditions.checkState((boolean)newInput.getInputId().equals(oldInput.getInputId()));
        InputId inputIdOnAst = newInput.getAstRoot(this).getInputId();
        Preconditions.checkState((boolean)newInput.getInputId().equals(inputIdOnAst));
        this.inputs.remove(oldInput);
        return true;
    }

    boolean addNewSourceAst(JsAst ast) {
        CompilerInput oldInput = this.getInput(ast.getInputId());
        if (oldInput != null) {
            throw new IllegalStateException("Input already exists: " + ast.getInputId().getIdName());
        }
        Node newRoot = ast.getAstRoot(this);
        if (newRoot == null) {
            return false;
        }
        this.getRoot().getLastChild().addChildToBack(newRoot);
        CompilerInput newInput = new CompilerInput(ast);
        if (this.moduleGraph == null && !this.modules.isEmpty()) {
            this.modules.get(0).add(newInput);
        }
        this.putCompilerInput(ast.getInputId(), newInput);
        return true;
    }

    @Override
    JSModuleGraph getModuleGraph() {
        return this.moduleGraph;
    }

    JSModuleGraph getDegenerateModuleGraph() {
        return this.moduleGraph == null ? new JSModuleGraph(this.modules) : this.moduleGraph;
    }

    @Override
    public TypeIRegistry getTypeIRegistry() {
        return this.getTypeRegistry();
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = new JSTypeRegistry(this.oldErrorReporter);
        }
        return this.typeRegistry;
    }

    @Override
    public MemoizedScopeCreator getTypedScopeCreator() {
        return this.getPassConfig().getTypedScopeCreator();
    }

    DefaultPassConfig ensureDefaultPassConfig() {
        PassConfig passes = this.getPassConfig().getBasePassConfig();
        Preconditions.checkState((boolean)(passes instanceof DefaultPassConfig), (Object)"PassConfigs must eventually delegate to the DefaultPassConfig");
        return (DefaultPassConfig)passes;
    }

    public SymbolTable buildKnownSymbolTable() {
        SymbolTable symbolTable = new SymbolTable(this.getTypeRegistry());
        MemoizedScopeCreator typedScopeCreator = this.getTypedScopeCreator();
        if (typedScopeCreator != null) {
            symbolTable.addScopes(typedScopeCreator.getAllMemoizedScopes());
            symbolTable.addSymbolsFrom(typedScopeCreator);
        } else {
            symbolTable.findScopes(this, this.externsRoot, this.jsRoot);
        }
        GlobalNamespace globalNamespace = this.ensureDefaultPassConfig().getGlobalNamespace();
        if (globalNamespace != null) {
            symbolTable.addSymbolsFrom(globalNamespace);
        }
        ReferenceCollectingCallback refCollector = new ReferenceCollectingCallback(this, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
        NodeTraversal.traverse(this, this.getRoot(), refCollector);
        symbolTable.addSymbolsFrom(refCollector);
        PreprocessorSymbolTable preprocessorSymbolTable = this.ensureDefaultPassConfig().getPreprocessorSymbolTable();
        if (preprocessorSymbolTable != null) {
            symbolTable.addSymbolsFrom(preprocessorSymbolTable);
        }
        symbolTable.fillNamespaceReferences();
        symbolTable.fillPropertyScopes();
        symbolTable.fillThisReferences(this, this.externsRoot, this.jsRoot);
        symbolTable.fillPropertySymbols(this, this.externsRoot, this.jsRoot);
        symbolTable.fillJSDocInfo(this, this.externsRoot, this.jsRoot);
        symbolTable.fillSymbolVisibility(this, this.externsRoot, this.jsRoot);
        return symbolTable;
    }

    @Override
    public TypedScope getTopScope() {
        return this.getPassConfig().getTopScope();
    }

    @Override
    public ReverseAbstractInterpreter getReverseAbstractInterpreter() {
        if (this.abstractInterpreter == null) {
            ChainableReverseAbstractInterpreter interpreter = new SemanticReverseAbstractInterpreter(this.getTypeRegistry());
            if (this.options.closurePass) {
                interpreter = new ClosureReverseAbstractInterpreter(this.getTypeRegistry()).append(interpreter).getFirst();
            }
            this.abstractInterpreter = interpreter;
        }
        return this.abstractInterpreter;
    }

    @Override
    TypeValidator getTypeValidator() {
        if (this.typeValidator == null) {
            this.typeValidator = new TypeValidator(this);
        }
        return this.typeValidator;
    }

    @Override
    Iterable<TypeValidator.TypeMismatch> getTypeMismatches() {
        return this.getTypeValidator().getMismatches();
    }

    @Override
    GlobalTypeInfo getSymbolTable() {
        GlobalTypeInfo gti = this.symbolTable;
        this.symbolTable = null;
        return gti;
    }

    @Override
    void setSymbolTable(GlobalTypeInfo symbolTable) {
        this.symbolTable = symbolTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node parseInputs() {
        boolean devMode = this.options.devMode != CompilerOptions.DevMode.OFF;
        this.externsRoot.detachChildren();
        this.jsRoot.detachChildren();
        if (this.options.tracer.isOn()) {
            this.tracker = new PerformanceTracker(this.jsRoot, this.options.tracer);
            this.addChangeHandler(this.tracker.getCodeChangeHandler());
        }
        Tracer tracer = this.newTracer(PARSING_PASS_NAME);
        this.beforePass(PARSING_PASS_NAME);
        try {
            for (CompilerInput object : this.externs) {
                Node n = object.getAstRoot(this);
                if (this.hasErrors()) {
                    Node node = null;
                    return node;
                }
                this.externsRoot.addChildToBack(n);
            }
            if (this.options.lowerFromEs6()) {
                this.processEs6Modules();
            }
            if (this.options.transformAMDToCJSModules || this.options.processCommonJSModules) {
                this.processAMDAndCommonJSModules();
            }
            this.hoistExterns();
            boolean staleInputs = false;
            if (this.options.dependencyOptions.needsManagement()) {
                for (CompilerInput input : this.inputs) {
                    for (String provide : input.getProvides()) {
                        this.getTypeRegistry().forwardDeclareType(provide);
                    }
                }
                try {
                    this.inputs = (this.moduleGraph == null ? new JSModuleGraph(this.modules) : this.moduleGraph).manageDependencies(this.options.dependencyOptions, this.inputs);
                    staleInputs = true;
                }
                catch (SortedDependencies.CircularDependencyException circularDependencyException) {
                    this.report(JSError.make(JSModule.CIRCULAR_DEPENDENCY_ERROR, circularDependencyException.getMessage()));
                }
                catch (SortedDependencies.MissingProvideException missingProvideException) {
                    this.report(JSError.make(MISSING_ENTRY_ERROR, missingProvideException.getMessage()));
                }
                catch (JSModuleGraph.MissingModuleException missingModuleException) {
                    this.report(JSError.make(MISSING_MODULE_ERROR, missingModuleException.getMessage()));
                }
                if (this.hasErrors()) {
                    Node node = null;
                    return node;
                }
            }
            this.hoistNoCompileFiles();
            if (staleInputs) {
                this.repartitionInputs();
            }
            for (CompilerInput input : this.inputs) {
                Node n = input.getAstRoot(this);
                if (n == null) continue;
                if (devMode) {
                    this.runSanityCheck();
                    if (this.hasErrors()) {
                        String provide;
                        provide = null;
                        return provide;
                    }
                }
                if (this.options.sourceMapOutputPath != null || this.options.nameReferenceReportPath != null || this.options.isExternExportsEnabled() || this.options.externExportsPath != null || !this.options.replaceStringsFunctionDescriptions.isEmpty()) {
                    SourceInformationAnnotator sia = new SourceInformationAnnotator(input.getName(), this.options.devMode != CompilerOptions.DevMode.OFF);
                    NodeTraversal.traverse(this, n, sia);
                }
                this.jsRoot.addChildToBack(n);
            }
            if (this.hasErrors()) {
                Node node = null;
                return node;
            }
            Node node = this.externAndJsRoot;
            return node;
        }
        finally {
            this.afterPass(PARSING_PASS_NAME);
            this.stopTracer(tracer, PARSING_PASS_NAME);
        }
    }

    void hoistExterns() {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            JSDocInfo info;
            Node n;
            if (this.options.dependencyOptions.needsManagement() && (!input.getProvides().isEmpty() || !input.getRequires().isEmpty()) || (n = input.getAstRoot(this)) == null || (info = n.getJSDocInfo()) == null || !info.isExterns()) continue;
            this.externsRoot.addChildToBack(n);
            input.setIsExtern(true);
            input.getModule().remove(input);
            this.externs.add(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void hoistNoCompileFiles() {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            JSDocInfo info;
            Node n = input.getAstRoot(this);
            if (n == null || (info = n.getJSDocInfo()) == null || !info.isNoCompile()) continue;
            input.getModule().remove(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void repartitionInputs() {
        Compiler.fillEmptyModules(this.modules);
        this.rebuildInputsFromModules();
    }

    void processEs6Modules() {
        for (CompilerInput input : this.inputs) {
            input.setCompiler(this);
            Node root = input.getAstRoot(this);
            if (root == null) continue;
            new ProcessEs6Modules(this, new ES6ModuleLoader(this, this.options.commonJSModulePathPrefix), true).processFile(root);
        }
    }

    void processAMDAndCommonJSModules() {
        LinkedHashMap<String, JSModule> modulesByProvide = new LinkedHashMap<String, JSModule>();
        LinkedHashMap<CompilerInput, JSModule> modulesByInput = new LinkedHashMap<CompilerInput, JSModule>();
        for (CompilerInput compilerInput : this.inputs) {
            compilerInput.setCompiler(this);
            Node root = compilerInput.getAstRoot(this);
            if (root == null) continue;
            if (this.options.transformAMDToCJSModules) {
                new TransformAMDToCJSModule(this).process(null, root);
            }
            if (!this.options.processCommonJSModules) continue;
            ProcessCommonJSModules cjs = new ProcessCommonJSModules(this, new ES6ModuleLoader(this, this.options.commonJSModulePathPrefix), true);
            cjs.process(null, root);
            JSModule m = new JSModule(cjs.inputToModuleName(compilerInput));
            m.addAndOverrideModule(compilerInput);
            for (String provide : compilerInput.getProvides()) {
                modulesByProvide.put(provide, m);
            }
            modulesByInput.put(compilerInput, m);
        }
        if (this.options.processCommonJSModules) {
            ArrayList<JSModule> modules = new ArrayList<JSModule>(modulesByProvide.values());
            if (!modules.isEmpty()) {
                this.modules = modules;
                this.moduleGraph = new JSModuleGraph(this.modules);
            }
            for (JSModule module : modules) {
                for (CompilerInput input : module.getInputs()) {
                    for (String require : input.getRequires()) {
                        JSModule dependency = (JSModule)modulesByProvide.get(require);
                        if (dependency == null) {
                            this.report(JSError.make(MISSING_ENTRY_ERROR, require));
                            continue;
                        }
                        module.addDependency(dependency);
                    }
                }
            }
            try {
                this.addCommonJSModulesToGraph(modules, modulesByInput);
            }
            catch (Exception exception) {
                Throwables.propagate((Throwable)exception);
            }
        }
    }

    void addCommonJSModulesToGraph(List<JSModule> inputModules, Map<CompilerInput, JSModule> modulesByInput) throws SortedDependencies.CircularDependencyException, SortedDependencies.MissingProvideException, JSModuleGraph.MissingModuleException {
        ArrayList<CompilerInput> inputs = new ArrayList<CompilerInput>();
        for (JSModule jSModule : inputModules) {
            inputs.addAll(jSModule.getInputs());
        }
        this.modules = new ArrayList<JSModule>();
        DependencyOptions depOptions = this.options.dependencyOptions;
        for (CompilerInput input : this.moduleGraph.manageDependencies(depOptions, inputs)) {
            this.modules.add(modulesByInput.get(input));
        }
        SortedDependencies<JSModule> sortedDependencies = new SortedDependencies<JSModule>(this.modules);
        this.modules = sortedDependencies.getDependenciesOf(this.modules, true);
        JSModule firstModule = (JSModule)Iterables.getFirst(this.modules, null);
        for (int i = 1; i < this.modules.size(); ++i) {
            if (this.modules.get(i).getDependencies().contains(firstModule)) continue;
            this.modules.get(i).addDependency(firstModule);
        }
        this.moduleGraph = new JSModuleGraph(this.modules);
    }

    public Node parse(SourceFile file) {
        this.initCompilerOptionsIfTesting();
        this.addToDebugLog("Parsing: " + file.getName());
        return new JsAst(file).getAstRoot(this);
    }

    @Override
    Node parseSyntheticCode(String js) {
        CompilerInput input = new CompilerInput(SourceFile.fromCode(" [synthetic:" + ++this.syntheticCodeId + "] ", js));
        this.putCompilerInput(input.getInputId(), input);
        return input.getAstRoot(this);
    }

    protected CompilerOptions newCompilerOptions() {
        return new CompilerOptions();
    }

    void initCompilerOptionsIfTesting() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
        }
    }

    @Override
    Node parseSyntheticCode(String fileName, String js) {
        this.initCompilerOptionsIfTesting();
        return this.parse(SourceFile.fromCode(fileName, js));
    }

    @Override
    Node parseTestCode(String js) {
        this.initCompilerOptionsIfTesting();
        CompilerInput input = new CompilerInput(SourceFile.fromCode("[testcode]", js));
        if (this.inputsById == null) {
            this.inputsById = new HashMap<InputId, CompilerInput>();
        }
        this.putCompilerInput(input.getInputId(), input);
        return input.getAstRoot(this);
    }

    @Override
    ErrorReporter getDefaultErrorReporter() {
        return this.defaultErrorReporter;
    }

    public String toSource() {
        return this.runInCompilerThread(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSource");
                try {
                    CodeBuilder cb = new CodeBuilder();
                    if (Compiler.this.jsRoot != null) {
                        int i = 0;
                        for (Node scriptNode = Compiler.this.jsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                            Compiler.this.toSource(cb, i++, scriptNode);
                        }
                    }
                    String string = cb.toString();
                    return string;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSource");
                }
            }
        });
    }

    public String[] toSourceArray() {
        return this.runInCompilerThread(new Callable<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSourceArray");
                try {
                    int numInputs = Compiler.this.inputs.size();
                    String[] sources = new String[numInputs];
                    CodeBuilder cb = new CodeBuilder();
                    for (int i = 0; i < numInputs; ++i) {
                        Node scriptNode = ((CompilerInput)Compiler.this.inputs.get(i)).getAstRoot(Compiler.this);
                        cb.reset();
                        Compiler.this.toSource(cb, i, scriptNode);
                        sources[i] = cb.toString();
                    }
                    String[] stringArray = sources;
                    return stringArray;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSourceArray");
                }
            }
        });
    }

    public String toSource(final JSModule module) {
        return this.runInCompilerThread(new Callable<String>(){

            @Override
            public String call() throws Exception {
                List<CompilerInput> inputs = module.getInputs();
                int numInputs = inputs.size();
                if (numInputs == 0) {
                    return "";
                }
                CodeBuilder cb = new CodeBuilder();
                for (int i = 0; i < numInputs; ++i) {
                    Node scriptNode = inputs.get(i).getAstRoot(Compiler.this);
                    if (scriptNode == null) {
                        throw new IllegalArgumentException("Bad module: " + module.getName());
                    }
                    Compiler.this.toSource(cb, i, scriptNode);
                }
                return cb.toString();
            }
        });
    }

    public String[] toSourceArray(final JSModule module) {
        return this.runInCompilerThread(new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                List<CompilerInput> inputs = module.getInputs();
                int numInputs = inputs.size();
                if (numInputs == 0) {
                    return new String[0];
                }
                String[] sources = new String[numInputs];
                CodeBuilder cb = new CodeBuilder();
                for (int i = 0; i < numInputs; ++i) {
                    Node scriptNode = inputs.get(i).getAstRoot(Compiler.this);
                    if (scriptNode == null) {
                        throw new IllegalArgumentException("Bad module input: " + inputs.get(i).getName());
                    }
                    cb.reset();
                    Compiler.this.toSource(cb, i, scriptNode);
                    sources[i] = cb.toString();
                }
                return sources;
            }
        });
    }

    public void toSource(final CodeBuilder cb, final int inputSeqNum, final Node root) {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String code;
                if (Compiler.this.options.printInputDelimiter) {
                    if (cb.getLength() > 0 && !cb.endsWith("\n")) {
                        cb.append("\n");
                    }
                    Preconditions.checkState((boolean)root.isScript());
                    String delimiter = Compiler.this.options.inputDelimiter;
                    String inputName = root.getInputId().getIdName();
                    String sourceName = root.getSourceFileName();
                    Preconditions.checkState((sourceName != null ? 1 : 0) != 0);
                    Preconditions.checkState((!sourceName.isEmpty() ? 1 : 0) != 0);
                    delimiter = delimiter.replaceAll("%name%", Matcher.quoteReplacement(inputName)).replaceAll("%num%", String.valueOf(inputSeqNum));
                    cb.append(delimiter).append("\n");
                }
                if (root.getJSDocInfo() != null && root.getJSDocInfo().getLicense() != null) {
                    cb.append("/*\n").append(root.getJSDocInfo().getLicense()).append("*/\n");
                }
                if (Compiler.this.options.sourceMapOutputPath != null) {
                    Compiler.this.sourceMap.setStartingPosition(cb.getLineIndex(), cb.getColumnIndex());
                }
                if (!(code = Compiler.this.toSource(root, Compiler.this.sourceMap, inputSeqNum == 0)).isEmpty()) {
                    boolean hasSemiColon;
                    cb.append(code);
                    int length = code.length();
                    char lastChar = code.charAt(length - 1);
                    char secondLastChar = length >= 2 ? code.charAt(length - 2) : (char)'\u0000';
                    boolean bl = hasSemiColon = lastChar == ';' || lastChar == '\n' && secondLastChar == ';';
                    if (!hasSemiColon) {
                        cb.append(";");
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String toSource(Node n) {
        this.initCompilerOptionsIfTesting();
        return this.toSource(n, null, true);
    }

    private String toSource(Node n, SourceMap sourceMap, boolean firstOutput) {
        CodePrinter.Builder builder = new CodePrinter.Builder(n);
        builder.setCompilerOptions(this.options);
        builder.setSourceMap(sourceMap);
        builder.setTagAsStrict(firstOutput && this.options.getLanguageOut().isStrict());
        return builder.build();
    }

    public void optimize() {
        List<PassFactory> optimizations = this.getPassConfig().getOptimizations();
        if (optimizations.isEmpty()) {
            return;
        }
        this.normalize();
        if (this.options.isExternExportsEnabled() || this.options.externExportsPath != null) {
            this.externExports();
        }
        this.phaseOptimizer = new PhaseOptimizer(this, this.tracker, null);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            this.phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        if (this.options.getCheckDeterminism()) {
            this.phaseOptimizer.setPrintAstHashcodes(true);
        }
        this.phaseOptimizer.consume(optimizations);
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        this.phaseOptimizer = null;
    }

    @Override
    void setCssRenamingMap(CssRenamingMap map) {
        this.options.cssRenamingMap = map;
    }

    @Override
    CssRenamingMap getCssRenamingMap() {
        return this.options.cssRenamingMap;
    }

    ControlFlowGraph<Node> computeCFG() {
        logger.fine("Computing Control Flow Graph");
        Tracer tracer = this.newTracer("computeCFG");
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
        this.process(cfa);
        this.stopTracer(tracer, "computeCFG");
        return cfa.getCfg();
    }

    public void normalize() {
        logger.fine("Normalizing");
        this.startPass("normalize");
        this.process(new Normalize(this, false));
        this.endPass();
    }

    @Override
    void prepareAst(Node root) {
        PrepareAst pass = new PrepareAst(this);
        pass.process(null, root);
    }

    void recordFunctionInformation() {
        logger.fine("Recording function information");
        this.startPass("recordFunctionInformation");
        RecordFunctionInformation recordFunctionInfoPass = new RecordFunctionInformation(this, this.getPassConfig().getIntermediateState().functionNames);
        this.process(recordFunctionInfoPass);
        this.functionInformationMap = recordFunctionInfoPass.getMap();
        this.endPass();
    }

    @Override
    void addChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.add(handler);
    }

    @Override
    void removeChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.remove(handler);
    }

    @Override
    void setScope(Node n) {
        if (this.phaseOptimizer != null) {
            this.phaseOptimizer.setScope(n);
        }
    }

    @Override
    Node getJsRoot() {
        return this.jsRoot;
    }

    @Override
    boolean hasScopeChanged(Node n) {
        if (!this.analyzeChangedScopesOnly || this.phaseOptimizer == null) {
            return true;
        }
        return this.phaseOptimizer.hasScopeChanged(n);
    }

    @Override
    void reportChangeToEnclosingScope(Node n) {
        if (this.phaseOptimizer != null) {
            this.phaseOptimizer.reportChangeToEnclosingScope(n);
            this.phaseOptimizer.startCrossScopeReporting();
            this.reportCodeChange();
            this.phaseOptimizer.endCrossScopeReporting();
        } else {
            this.reportCodeChange();
        }
    }

    @VisibleForTesting
    void setPhaseOptimizer(PhaseOptimizer po) {
        this.phaseOptimizer = po;
    }

    @Override
    public void reportCodeChange() {
        for (CodeChangeHandler handler : this.codeChangeHandlers) {
            handler.reportChange();
        }
    }

    @Override
    public CodingConvention getCodingConvention() {
        CodingConvention convention = this.options.getCodingConvention();
        convention = convention != null ? convention : this.defaultCodingConvention;
        return convention;
    }

    @Override
    public boolean isIdeMode() {
        return this.options.ideMode;
    }

    @Override
    public boolean acceptEcmaScript5() {
        switch (this.options.getLanguageIn()) {
            case ECMASCRIPT5: 
            case ECMASCRIPT5_STRICT: 
            case ECMASCRIPT6: 
            case ECMASCRIPT6_STRICT: {
                return true;
            }
            case ECMASCRIPT3: {
                return false;
            }
        }
        throw new IllegalStateException("unexpected language mode: " + (Object)((Object)this.options.getLanguageIn()));
    }

    @Override
    public boolean acceptConstKeyword() {
        return this.options.acceptConstKeyword;
    }

    @Override
    Config getParserConfig(AbstractCompiler.ConfigContext context) {
        if (this.parserConfig == null) {
            switch (this.options.getLanguageIn()) {
                case ECMASCRIPT3: {
                    this.parserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT3);
                    this.externsParserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT5);
                    break;
                }
                case ECMASCRIPT5: {
                    this.externsParserConfig = this.parserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT5);
                    break;
                }
                case ECMASCRIPT5_STRICT: {
                    this.externsParserConfig = this.parserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT5_STRICT);
                    break;
                }
                case ECMASCRIPT6: {
                    this.externsParserConfig = this.parserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT6);
                    break;
                }
                case ECMASCRIPT6_STRICT: {
                    this.externsParserConfig = this.parserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT6_STRICT);
                    break;
                }
                case ECMASCRIPT6_TYPED: {
                    this.externsParserConfig = this.parserConfig = this.createConfig(Config.LanguageMode.ECMASCRIPT6_TYPED);
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected language mode: " + (Object)((Object)this.options.getLanguageIn()));
                }
            }
        }
        switch (context) {
            case EXTERNS: {
                return this.externsParserConfig;
            }
        }
        return this.parserConfig;
    }

    protected Config createConfig(Config.LanguageMode mode) {
        return ParserRunner.createConfig(this.isIdeMode(), this.options.isParseJsDocDocumentation(), mode, this.acceptConstKeyword(), this.options.extraAnnotationNames);
    }

    protected DiagnosticGroups getDiagnosticGroups() {
        return new DiagnosticGroups();
    }

    @Override
    public void report(JSError error) {
        CheckLevel newLevel;
        CheckLevel level = error.getDefaultLevel();
        if (this.warningsGuard != null && (newLevel = this.warningsGuard.level(error)) != null) {
            level = newLevel;
        }
        if (level.isOn()) {
            this.initCompilerOptionsIfTesting();
            if (this.getOptions().errorHandler != null) {
                this.getOptions().errorHandler.report(level, error);
            }
            this.errorManager.report(level, error);
        }
    }

    @Override
    public CheckLevel getErrorLevel(JSError error) {
        Preconditions.checkNotNull((Object)this.options);
        return this.warningsGuard.level(error);
    }

    @Override
    void throwInternalError(String message, Exception cause) {
        String finalMessage = "INTERNAL COMPILER ERROR.\nPlease report this problem.\n\n" + message;
        RuntimeException e = new RuntimeException(finalMessage, cause);
        if (cause != null) {
            e.setStackTrace(cause.getStackTrace());
        }
        throw e;
    }

    public int getErrorCount() {
        return this.errorManager.getErrorCount();
    }

    public int getWarningCount() {
        return this.errorManager.getWarningCount();
    }

    @Override
    boolean hasHaltingErrors() {
        return !this.isIdeMode() && this.getErrorCount() > 0;
    }

    public boolean hasErrors() {
        return this.hasHaltingErrors();
    }

    @Override
    void addToDebugLog(String str) {
        if (this.options.useDebugLog) {
            this.debugLog.append(str);
            this.debugLog.append('\n');
            logger.fine(str);
        }
    }

    @Override
    SourceFile getSourceFileByName(String sourceName) {
        if (sourceName != null) {
            CompilerInput input = this.inputsById.get(new InputId(sourceName));
            if (input != null) {
                return input.getSourceFile();
            }
            return this.sourceMapOriginalSources.get(sourceName);
        }
        return null;
    }

    @Override
    public Mapping.OriginalMapping getSourceMapping(String sourceName, int lineNumber, int columnNumber) {
        SourceMapInput sourceMap = (SourceMapInput)this.options.inputSourceMaps.get((Object)sourceName);
        if (sourceMap == null) {
            return null;
        }
        Mapping.OriginalMapping result = sourceMap.getSourceMap().getMappingForLine(lineNumber, columnNumber + 1);
        if (result == null) {
            return null;
        }
        String path = this.getRelativeTo(result.getOriginalFile(), sourceMap.getOriginalPath());
        this.sourceMapOriginalSources.putIfAbsent(path, (SourceFile)this.originalSourcesLoader.apply((Object)path));
        return result.toBuilder().setOriginalFile(path).setColumnPosition(result.getColumnPosition() - 1).build();
    }

    @Override
    public String getSourceLine(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLine(lineNumber);
        }
        return null;
    }

    @Override
    public Region getSourceRegion(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getRegion(lineNumber);
        }
        return null;
    }

    @Override
    Node getNodeForCodeInsertion(JSModule module) {
        if (module == null) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("No inputs");
            }
            return this.inputs.get(0).getAstRoot(this);
        }
        List<CompilerInput> moduleInputs = module.getInputs();
        if (!moduleInputs.isEmpty()) {
            return moduleInputs.get(0).getAstRoot(this);
        }
        throw new IllegalStateException("Root module has no inputs");
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    VariableMap getVariableMap() {
        return this.getPassConfig().getIntermediateState().variableMap;
    }

    VariableMap getPropertyMap() {
        return this.getPassConfig().getIntermediateState().propertyMap;
    }

    @Override
    CompilerOptions getOptions() {
        return this.options;
    }

    FunctionInformationMap getFunctionalInformationMap() {
        return this.functionInformationMap;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public String getAstDotGraph() throws IOException {
        if (this.jsRoot != null) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
            cfa.process(null, this.jsRoot);
            return DotFormatter.toDot(this.jsRoot, cfa.getCfg());
        }
        return "";
    }

    @Override
    public ErrorManager getErrorManager() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
        }
        return this.errorManager;
    }

    @Override
    List<CompilerInput> getInputsInOrder() {
        return Collections.unmodifiableList(this.inputs);
    }

    public Map<InputId, CompilerInput> getInputsById() {
        return Collections.unmodifiableMap(this.inputsById);
    }

    List<CompilerInput> getExternsInOrder() {
        return Collections.unmodifiableList(this.externs);
    }

    @VisibleForTesting
    List<CompilerInput> getInputsForTesting() {
        return this.inputs;
    }

    @VisibleForTesting
    List<CompilerInput> getExternsForTesting() {
        return this.externs;
    }

    @Override
    boolean hasRegExpGlobalReferences() {
        return this.hasRegExpGlobalReferences;
    }

    @Override
    void setHasRegExpGlobalReferences(boolean references) {
        this.hasRegExpGlobalReferences = references;
    }

    @Override
    void updateGlobalVarReferences(Map<Var, ReferenceCollectingCallback.ReferenceCollection> refMapPatch, Node collectionRoot) {
        Preconditions.checkState((collectionRoot.isScript() || collectionRoot.isBlock() ? 1 : 0) != 0);
        if (this.globalRefMap == null) {
            this.globalRefMap = new GlobalVarReferenceMap(this.getInputsInOrder(), this.getExternsInOrder());
        }
        this.globalRefMap.updateGlobalVarReferences(refMapPatch, collectionRoot);
    }

    @Override
    GlobalVarReferenceMap getGlobalVarReferences() {
        return this.globalRefMap;
    }

    @Override
    CompilerInput getSynthesizedExternsInput() {
        if (this.synthesizedExternsInput == null) {
            this.synthesizedExternsInput = this.newExternInput(SYNTHETIC_EXTERNS);
        }
        return this.synthesizedExternsInput;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    String getLastPassName() {
        return this.lastPassName;
    }

    @Override
    void setProgress(double newProgress, String passName) {
        this.lastPassName = passName;
        this.progress = newProgress > 1.0 ? 1.0 : newProgress;
    }

    @Override
    void setExternProperties(Set<String> externProperties) {
        this.externProperties = externProperties;
    }

    @Override
    Set<String> getExternProperties() {
        return this.externProperties;
    }

    public void replaceScript(JsAst ast) {
        CompilerInput input = this.getInput(ast.getInputId());
        if (!this.replaceIncrementalSourceAst(ast)) {
            return;
        }
        Node originalRoot = input.getAstRoot(this);
        this.processNewScript(ast, originalRoot);
    }

    public void addNewScript(JsAst ast) {
        if (!this.addNewSourceAst(ast)) {
            return;
        }
        Node emptyScript = new Node(132);
        InputId inputId = ast.getInputId();
        emptyScript.setInputId(inputId);
        emptyScript.setStaticSourceFile(SourceFile.fromCode(inputId.getIdName(), ""));
        this.processNewScript(ast, emptyScript);
    }

    private void processNewScript(JsAst ast, Node originalRoot) {
        Node js = ast.getAstRoot(this);
        Preconditions.checkNotNull((Object)js);
        this.runHotSwap(originalRoot, js, this.getCleanupPassConfig());
        this.runHotSwapPass(null, null, this.ensureDefaultPassConfig().garbageCollectChecks);
        this.getTypeRegistry().clearNamedTypes();
        this.removeSyntheticVarsInput();
        this.runHotSwap(originalRoot, js, this.ensureDefaultPassConfig());
    }

    private void runHotSwap(Node originalRoot, Node js, PassConfig passConfig) {
        for (PassFactory passFactory : passConfig.getChecks()) {
            this.runHotSwapPass(originalRoot, js, passFactory);
        }
    }

    private void runHotSwapPass(Node originalRoot, Node js, PassFactory passFactory) {
        HotSwapCompilerPass pass = passFactory.getHotSwapPass(this);
        if (pass != null) {
            logger.info("Performing HotSwap for pass " + passFactory.getName());
            pass.hotSwapScript(js, originalRoot);
        }
    }

    private PassConfig getCleanupPassConfig() {
        return new CleanupPasses(this.getOptions());
    }

    private void removeSyntheticVarsInput() {
        String sourceName = SYNTHETIC_EXTERNS;
        this.removeExternInput(new InputId(sourceName));
    }

    @Override
    Node ensureLibraryInjected(String resourceName, boolean normalizeAndUniquifyNames) {
        if (this.injectedLibraries.containsKey(resourceName)) {
            return null;
        }
        boolean isBase = "base".equals(resourceName);
        if (!isBase) {
            this.ensureLibraryInjected("base", true);
        }
        Node firstChild = this.loadLibraryCode(resourceName, normalizeAndUniquifyNames).removeChildren();
        Node lastChild = firstChild.getLastSibling();
        Node parent = this.getNodeForCodeInsertion(null);
        if (isBase) {
            parent.addChildrenToFront(firstChild);
        } else {
            parent.addChildrenAfter(firstChild, this.injectedLibraries.get("base"));
        }
        this.reportCodeChange();
        this.injectedLibraries.put(resourceName, lastChild);
        return lastChild;
    }

    @VisibleForTesting
    Node loadLibraryCode(String resourceName, boolean normalizeAndUniquifyNames) {
        String originalCode;
        try {
            originalCode = CharStreams.toString((Readable)new InputStreamReader(Compiler.class.getResourceAsStream(String.format("js/%s.js", resourceName)), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Node ast = this.parseSyntheticCode(originalCode);
        if (normalizeAndUniquifyNames) {
            Normalize.normalizeSyntheticCode(this, ast, String.format("jscomp_%s_", resourceName));
        }
        return ast;
    }

    public static String getReleaseVersion() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        return config.getString("compiler.version");
    }

    public static String getReleaseDate() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        return config.getString("compiler.date");
    }

    @Override
    void addComments(String filename, List<Comment> comments) {
        if (!this.isIdeMode()) {
            throw new UnsupportedOperationException("addComments may only be called in IDE mode.");
        }
        this.commentsPerFile.put(filename, comments);
    }

    @Override
    public List<Comment> getComments(String filename) {
        if (!this.isIdeMode()) {
            throw new UnsupportedOperationException("getComments may only be called in IDE mode.");
        }
        return this.commentsPerFile.get(filename);
    }

    @Override
    void setDefaultDefineValues(ImmutableMap<String, Node> values) {
        this.defaultDefineValues = values;
    }

    @Override
    ImmutableMap<String, Node> getDefaultDefineValues() {
        return this.defaultDefineValues;
    }

    public static class CodeBuilder {
        private final StringBuilder sb = new StringBuilder();
        private int lineCount = 0;
        private int colCount = 0;

        void reset() {
            this.sb.setLength(0);
        }

        CodeBuilder append(String str) {
            int index;
            this.sb.append(str);
            int lastIndex = index = -1;
            while ((index = str.indexOf(10, index + 1)) >= 0) {
                ++this.lineCount;
                lastIndex = index;
            }
            this.colCount = lastIndex == -1 ? (this.colCount += str.length()) : str.length() - (lastIndex + 1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        int getLineIndex() {
            return this.lineCount;
        }

        int getColumnIndex() {
            return this.colCount;
        }

        boolean endsWith(String suffix) {
            return this.sb.length() > suffix.length() && suffix.equals(this.sb.substring(this.sb.length() - suffix.length()));
        }
    }
}

