/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import java.io.Serializable;
import java.text.MessageFormat;

public final class DiagnosticType
implements Comparable<DiagnosticType>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final String key;
    public final MessageFormat format;
    public final CheckLevel defaultLevel;
    public CheckLevel level;

    public static DiagnosticType error(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.ERROR, descriptionFormat);
    }

    public static DiagnosticType warning(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.WARNING, descriptionFormat);
    }

    public static DiagnosticType disabled(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.OFF, descriptionFormat);
    }

    public static DiagnosticType make(String name, CheckLevel level, String descriptionFormat) {
        return new DiagnosticType(name, level, new MessageFormat(descriptionFormat));
    }

    private DiagnosticType(String key, CheckLevel level, MessageFormat format) {
        this.key = key;
        this.defaultLevel = level;
        this.format = format;
        this.level = this.defaultLevel;
    }

    String format(Object ... arguments) {
        return this.format.format(arguments);
    }

    public boolean equals(Object type) {
        return type instanceof DiagnosticType && ((DiagnosticType)type).key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(DiagnosticType diagnosticType) {
        return this.key.compareTo(diagnosticType.key);
    }

    public String toString() {
        return this.key + ": " + this.format.toPattern();
    }
}

