/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionInformationMap;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class RecordFunctionInformation
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Compiler compiler;
    private final FunctionNames functionNames;
    private final JSModuleGraph moduleGraph;
    private final FunctionInformationMap.Builder mapBuilder;

    RecordFunctionInformation(Compiler compiler, FunctionNames functionNames) {
        this.compiler = compiler;
        this.moduleGraph = compiler.getModuleGraph();
        this.functionNames = functionNames;
        this.mapBuilder = FunctionInformationMap.newBuilder();
    }

    FunctionInformationMap getMap() {
        return this.mapBuilder.build();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isFunction()) {
            return;
        }
        int id = this.functionNames.getFunctionId(n);
        if (id < 0) {
            return;
        }
        String compiledSource = this.compiler.toSource(n);
        JSModule module = t.getModule();
        this.mapBuilder.addEntry(FunctionInformationMap.Entry.newBuilder().setId(id).setSourceName(NodeUtil.getSourceName(n)).setLineNumber(n.getLineno()).setModuleName(this.moduleGraph == null ? "" : module.getName()).setSize(compiledSource.length()).setName(this.functionNames.getFunctionName(n)).setCompiledSource(compiledSource).build());
    }
}

