/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class TypeTransformation {
    private AbstractCompiler compiler;
    private JSTypeRegistry typeRegistry;
    private StaticTypedScope<JSType> scope;
    static final DiagnosticType UNKNOWN_TYPEVAR = DiagnosticType.warning("TYPEVAR_UNDEFINED", "Reference to an unknown type variable {0}");
    static final DiagnosticType UNKNOWN_STRVAR = DiagnosticType.warning("UNKNOWN_STRVAR", "Reference to an unknown string variable {0}");
    static final DiagnosticType UNKNOWN_TYPENAME = DiagnosticType.warning("TYPENAME_UNDEFINED", "Reference to an unknown type name {0}");
    static final DiagnosticType BASETYPE_INVALID = DiagnosticType.warning("BASETYPE_INVALID", "The type {0} cannot be templatized");
    static final DiagnosticType TEMPTYPE_INVALID = DiagnosticType.warning("TEMPTYPE_INVALID", "Expected templatized type in {0} found {1}");
    static final DiagnosticType INDEX_OUTOFBOUNDS = DiagnosticType.warning("INDEX_OUTOFBOUNDS", "Index out of bounds in templateTypeOf: {0} > {1}");
    static final DiagnosticType DUPLICATE_VARIABLE = DiagnosticType.warning("DUPLICATE_VARIABLE", "The variable {0} is already defined");
    static final DiagnosticType UNKNOWN_NAMEVAR = DiagnosticType.warning("UNKNOWN_NAMEVAR", "Reference to an unknown name variable {0}");
    static final DiagnosticType RECTYPE_INVALID = DiagnosticType.warning("RECTYPE_INVALID", "The first parameter of a maprecord must be a record type, found {0}");
    static final DiagnosticType MAPRECORD_BODY_INVALID = DiagnosticType.warning("MAPRECORD_BODY_INVALID", "The body of a maprecord function must evaluate to a record type or a no type, found {0}");
    static final DiagnosticType VAR_UNDEFINED = DiagnosticType.warning("VAR_UNDEFINED", "Variable {0} is undefined in the scope");
    static final DiagnosticType INVALID_CTOR = DiagnosticType.warning("INVALID_CTOR", "Expected a constructor type, found {0}");
    static final DiagnosticType RECPARAM_INVALID = DiagnosticType.warning("RECPARAM_INVALID", "Expected a record type, found {0}");
    static final DiagnosticType PROPTYPE_INVALID = DiagnosticType.warning("PROPTYPE_INVALID", "Expected object type, found {0}");

    TypeTransformation(AbstractCompiler compiler, StaticTypedScope<JSType> scope) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
        this.scope = scope;
    }

    private boolean isTypeVar(Node n) {
        return n.isName();
    }

    private boolean isTypeName(Node n) {
        return n.isString();
    }

    private boolean isBooleanOperation(Node n) {
        return n.isAnd() || n.isOr() || n.isNot();
    }

    private TypeTransformationParser.Keywords nameToKeyword(String s) {
        return TypeTransformationParser.Keywords.valueOf(s.toUpperCase());
    }

    private StaticTypedScope<JSType> getScope(StaticTypedScope<JSType> scope, String name) {
        StaticTypedSlot<JSType> slot = scope.getOwnSlot(name);
        if (slot != null) {
            return scope;
        }
        return this.getScope(scope.getParentScope(), name);
    }

    private JSType getType(String name) {
        TemplateType type = null;
        JSType thisType = null;
        if (this.scope != null && this.scope.getTypeOfThis() != null) {
            thisType = this.scope.getTypeOfThis().toObjectType();
        }
        if (thisType != null && (type = thisType.getTemplateTypeMap().getTemplateTypeKeyByName(name)) != null) {
            Preconditions.checkState((boolean)type.isTemplateType(), (String)"Expected a template type, but found: %s", (Object[])new Object[]{type});
            return type;
        }
        StaticTypedSlot<JSType> slot = this.scope.getSlot(name);
        if (slot != null) {
            JSDocInfo info;
            JSType rawType = slot.getType();
            if (rawType != null) {
                if ((rawType.isConstructor() || rawType.isInterface()) && rawType.isFunctionType() && rawType.isNominalConstructor()) {
                    return rawType.toMaybeFunctionType().getInstanceType();
                }
                if (rawType.isEnumType()) {
                    return rawType.toMaybeEnumType().getElementsType();
                }
            }
            if ((info = slot.getJSDocInfo()) != null && info.hasTypedefType()) {
                JSTypeExpression expr = info.getTypedefType();
                StaticTypedScope<JSType> typedefScope = this.getScope(this.scope, name);
                return expr.evaluate(typedefScope, this.typeRegistry);
            }
        }
        return this.typeRegistry.getType(name);
    }

    private boolean isTemplatizable(JSType type) {
        return this.typeRegistry.isTemplatizable(type);
    }

    private JSType getUnknownType() {
        return this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    private JSType getNoType() {
        return this.typeRegistry.getNativeObjectType(JSTypeNative.NO_TYPE);
    }

    private JSType getAllType() {
        return this.typeRegistry.getNativeType(JSTypeNative.ALL_TYPE);
    }

    private JSType getObjectType() {
        return this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE);
    }

    private JSType createUnionType(JSType ... variants) {
        return this.typeRegistry.createUnionType(variants);
    }

    private JSType createTemplatizedType(ObjectType baseType, JSType[] params) {
        return this.typeRegistry.createTemplatizedType(baseType, params);
    }

    private JSType createRecordType(ImmutableMap<String, JSType> props) {
        RecordTypeBuilder builder = new RecordTypeBuilder(this.typeRegistry);
        for (Map.Entry e : props.entrySet()) {
            builder.addProperty((String)e.getKey(), (JSType)e.getValue(), null);
        }
        return builder.build();
    }

    private void reportWarning(Node n, DiagnosticType msg, String ... param) {
        this.compiler.report(JSError.make(n, msg, param));
    }

    private <T> ImmutableMap<String, T> addNewEntry(ImmutableMap<String, T> map, String name, T type) {
        return new ImmutableMap.Builder().putAll(map).put((Object)name, type).build();
    }

    private String getFunctionParameter(Node n, int i) {
        Preconditions.checkArgument((boolean)n.isFunction(), (String)"Expected a function node, found %s", (Object[])new Object[]{n});
        return n.getChildAtIndex(1).getChildAtIndex(i).getString();
    }

    private Node getFunctionBody(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction(), (String)"Expected a function node, found %s", (Object[])new Object[]{n});
        return n.getChildAtIndex(2);
    }

    private String getCallName(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object[])new Object[]{n});
        return n.getFirstChild().getString();
    }

    private Node getCallArgument(Node n, int i) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object[])new Object[]{n});
        return n.getChildAtIndex(i + 1);
    }

    private int getCallParamCount(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object[])new Object[]{n});
        return n.getChildCount() - 1;
    }

    private ImmutableList<Node> getCallParams(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object[])new Object[]{n});
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < this.getCallParamCount(n); ++i) {
            builder.add((Object)this.getCallArgument(n, i));
        }
        return builder.build();
    }

    private Node getComputedPropValue(Node n) {
        Preconditions.checkArgument((boolean)n.isComputedProp(), (String)"Expected a computed property node, found %s", (Object[])new Object[]{n});
        return n.getChildAtIndex(1);
    }

    private String getComputedPropName(Node n) {
        Preconditions.checkArgument((boolean)n.isComputedProp(), (String)"Expected a computed property node, found %s", (Object[])new Object[]{n});
        return n.getFirstChild().getString();
    }

    JSType eval(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        return this.eval(ttlAst, typeVars, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    JSType eval(Node ttlAst, ImmutableMap<String, JSType> typeVars, ImmutableMap<String, String> nameVars) {
        return this.evalInternal(ttlAst, new NameResolver(typeVars, nameVars));
    }

    private JSType evalInternal(Node ttlAst, NameResolver nameResolver) {
        if (this.isTypeName(ttlAst)) {
            return this.evalTypeName(ttlAst);
        }
        if (this.isTypeVar(ttlAst)) {
            return this.evalTypeVar(ttlAst, nameResolver);
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case TYPE_CONSTRUCTOR: {
                return this.evalTypeExpression(ttlAst, nameResolver);
            }
            case OPERATION: {
                return this.evalOperationExpression(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Could not evaluate the type transformation expression");
    }

    private JSType evalOperationExpression(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case COND: {
                return this.evalConditional(ttlAst, nameResolver);
            }
            case MAPUNION: {
                return this.evalMapunion(ttlAst, nameResolver);
            }
            case MAPRECORD: {
                return this.evalMaprecord(ttlAst, nameResolver);
            }
            case TYPEOFVAR: {
                return this.evalTypeOfVar(ttlAst);
            }
            case INSTANCEOF: {
                return this.evalInstanceOf(ttlAst, nameResolver);
            }
            case PRINTTYPE: {
                return this.evalPrintType(ttlAst, nameResolver);
            }
            case PROPTYPE: {
                return this.evalPropType(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Invalid type transformation operation");
    }

    private JSType evalTypeExpression(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case TYPE: {
                return this.evalTemplatizedType(ttlAst, nameResolver);
            }
            case UNION: {
                return this.evalUnionType(ttlAst, nameResolver);
            }
            case NONE: {
                return this.getNoType();
            }
            case ALL: {
                return this.getAllType();
            }
            case UNKNOWN: {
                return this.getUnknownType();
            }
            case RAWTYPEOF: {
                return this.evalRawTypeOf(ttlAst, nameResolver);
            }
            case TEMPLATETYPEOF: {
                return this.evalTemplateTypeOf(ttlAst, nameResolver);
            }
            case RECORD: {
                return this.evalRecordType(ttlAst, nameResolver);
            }
            case TYPEEXPR: {
                return this.evalNativeTypeExpr(ttlAst);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private JSType evalTypeName(Node ttlAst) {
        String typeName = ttlAst.getString();
        JSType resultingType = this.getType(typeName);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPENAME, typeName);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private JSType evalTemplatizedType(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType firstParam = this.evalInternal((Node)params.get(0), nameResolver);
        if (!this.isTemplatizable(firstParam)) {
            this.reportWarning(ttlAst, BASETYPE_INVALID, firstParam.toString());
            return this.getUnknownType();
        }
        ObjectType baseType = firstParam.toObjectType();
        JSType[] templatizedTypes = new JSType[params.size() - 1];
        for (int i = 0; i < templatizedTypes.length; ++i) {
            templatizedTypes[i] = this.evalInternal((Node)params.get(i + 1), nameResolver);
        }
        return this.createTemplatizedType(baseType, templatizedTypes);
    }

    private JSType evalTypeVar(Node ttlAst, NameResolver nameResolver) {
        String typeVar = ttlAst.getString();
        JSType resultingType = (JSType)nameResolver.typeVars.get((Object)typeVar);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPEVAR, typeVar);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private JSType evalUnionType(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        JSType[] basicTypes = new JSType[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            basicTypes[i] = this.evalInternal((Node)params.get(i), nameResolver);
        }
        return this.createUnionType(basicTypes);
    }

    private JSType[] evalTypeParams(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        JSType[] result = new JSType[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = this.evalInternal((Node)params.get(i), nameResolver);
        }
        return result;
    }

    private String evalString(Node ttlAst, NameResolver nameResolver) {
        if (ttlAst.isName()) {
            if (!nameResolver.nameVars.containsKey((Object)ttlAst.getString())) {
                this.reportWarning(ttlAst, UNKNOWN_STRVAR, ttlAst.getString());
                return "";
            }
            return (String)nameResolver.nameVars.get((Object)ttlAst.getString());
        }
        return ttlAst.getString();
    }

    private String[] evalStringParams(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        String[] result = new String[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = this.evalString((Node)params.get(i), nameResolver);
        }
        return result;
    }

    private boolean evalTypePredicate(Node ttlAst, NameResolver nameResolver) {
        JSType[] params = this.evalTypeParams(ttlAst, nameResolver);
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case EQ: {
                return params[0].isEquivalentTo(params[1]);
            }
            case SUB: {
                return params[0].isSubtype(params[1]);
            }
            case ISCTOR: {
                return params[0].isConstructor();
            }
            case ISTEMPLATIZED: {
                return params[0].isTemplatizedType();
            }
            case ISRECORD: {
                return params[0].isRecordType();
            }
            case ISUNKNOWN: {
                return params[0].isUnknownType() || params[0].isCheckedUnknownType();
            }
        }
        throw new IllegalStateException("Invalid type predicate in the type transformation");
    }

    private boolean evalStringPredicate(Node ttlAst, NameResolver nameResolver) {
        String[] params = this.evalStringParams(ttlAst, nameResolver);
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].isEmpty()) continue;
            return false;
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case STREQ: {
                return params[0].equals(params[1]);
            }
        }
        throw new IllegalStateException("Invalid string predicate in the type transformation");
    }

    private boolean evalTypevarPredicate(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case ISDEFINED: {
                return nameResolver.typeVars.containsKey((Object)this.getCallArgument(ttlAst, 0).getString());
            }
        }
        throw new IllegalStateException("Invalid typevar predicate in the type transformation");
    }

    private boolean evalBooleanOperation(Node ttlAst, NameResolver nameResolver) {
        boolean param0 = this.evalBoolean(ttlAst.getFirstChild(), nameResolver);
        if (ttlAst.isNot()) {
            return !param0;
        }
        if (ttlAst.isAnd()) {
            return param0 && this.evalBoolean(ttlAst.getLastChild(), nameResolver);
        }
        if (ttlAst.isOr()) {
            return param0 || this.evalBoolean(ttlAst.getLastChild(), nameResolver);
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private boolean evalBoolean(Node ttlAst, NameResolver nameResolver) {
        if (this.isBooleanOperation(ttlAst)) {
            return this.evalBooleanOperation(ttlAst, nameResolver);
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case STRING_PREDICATE: {
                return this.evalStringPredicate(ttlAst, nameResolver);
            }
            case TYPE_PREDICATE: {
                return this.evalTypePredicate(ttlAst, nameResolver);
            }
            case TYPEVAR_PREDICATE: {
                return this.evalTypevarPredicate(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private JSType evalConditional(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        if (this.evalBoolean((Node)params.get(0), nameResolver)) {
            return this.evalInternal((Node)params.get(1), nameResolver);
        }
        return this.evalInternal((Node)params.get(2), nameResolver);
    }

    private JSType evalMapunion(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        Node unionParam = (Node)params.get(0);
        Node mapFunction = (Node)params.get(1);
        String paramName = this.getFunctionParameter(mapFunction, 0);
        if (nameResolver.typeVars.containsKey((Object)paramName)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramName);
            return this.getUnknownType();
        }
        Node mapFunctionBody = this.getFunctionBody(mapFunction);
        JSType unionType = this.evalInternal(unionParam, nameResolver);
        if (!unionType.isUnionType()) {
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramName, unionType), nameResolver.nameVars);
            return this.evalInternal(mapFunctionBody, newNameResolver);
        }
        Collection<JSType> unionElms = ((UnionType)unionType).getAlternates();
        int unionSize = unionElms.size();
        JSType[] newUnionElms = new JSType[unionSize];
        int i = 0;
        for (JSType elm : unionElms) {
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramName, elm), nameResolver.nameVars);
            newUnionElms[i] = this.evalInternal(mapFunctionBody, newNameResolver);
            ++i;
        }
        return this.createUnionType(newUnionElms);
    }

    private JSType evalRawTypeOf(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType type = this.evalInternal((Node)params.get(0), nameResolver);
        if (!type.isTemplatizedType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "rawTypeOf", type.toString());
            return this.getUnknownType();
        }
        return ((TemplatizedType)type).getReferencedType();
    }

    private JSType evalTemplateTypeOf(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<JSType> templateTypes;
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType type = this.evalInternal((Node)params.get(0), nameResolver);
        if (!type.isTemplatizedType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "templateTypeOf", type.toString());
            return this.getUnknownType();
        }
        int index = (int)((Node)params.get(1)).getDouble();
        if (index > (templateTypes = ((TemplatizedType)type).getTemplateTypes()).size()) {
            this.reportWarning(ttlAst, INDEX_OUTOFBOUNDS, Integer.toString(index), Integer.toString(templateTypes.size()));
            return this.getUnknownType();
        }
        return (JSType)templateTypes.get(index);
    }

    private JSType evalRecord(Node record, NameResolver nameResolver) {
        RecordTypeBuilder builder = new RecordTypeBuilder(this.typeRegistry);
        for (Node propNode : record.children()) {
            if (propNode.isComputedProp()) {
                String compPropName = this.getComputedPropName(propNode);
                if (!nameResolver.nameVars.containsKey((Object)compPropName)) {
                    this.reportWarning(record, UNKNOWN_NAMEVAR, compPropName);
                    return this.getUnknownType();
                }
                Node propValue = this.getComputedPropValue(propNode);
                String resolvedName = (String)nameResolver.nameVars.get((Object)compPropName);
                JSType resultingType = this.evalInternal(propValue, nameResolver);
                builder.addProperty(resolvedName, resultingType, null);
                continue;
            }
            String propName = propNode.getString();
            JSType resultingType = this.evalInternal(propNode.getFirstChild(), nameResolver);
            builder.addProperty(propName, resultingType, null);
        }
        return builder.build();
    }

    private JSType evalRecordParam(Node ttlAst, NameResolver nameResolver) {
        if (ttlAst.isObjectLit()) {
            return this.evalRecord(ttlAst, nameResolver);
        }
        return this.evalInternal(ttlAst, nameResolver);
    }

    private JSType buildRecordTypeFromObject(ObjectType objType) {
        RecordType recType = objType.toMaybeRecordType();
        if (recType != null) {
            return recType;
        }
        Set<String> propNames = objType.getOwnPropertyNames();
        if (propNames.isEmpty()) {
            return this.getObjectType();
        }
        ImmutableMap.Builder props = new ImmutableMap.Builder();
        for (String propName : propNames) {
            props.put((Object)propName, (Object)objType.getPropertyType(propName));
        }
        return this.createRecordType((ImmutableMap<String, JSType>)props.build());
    }

    private JSType evalRecordType(Node ttlAst, NameResolver nameResolver) {
        int paramCount = this.getCallParamCount(ttlAst);
        ImmutableList.Builder recTypesBuilder = new ImmutableList.Builder();
        for (int i = 0; i < paramCount; ++i) {
            JSType type = this.evalRecordParam(this.getCallArgument(ttlAst, i), nameResolver);
            ObjectType objType = type.toObjectType();
            if (objType == null || objType.isUnknownType()) {
                this.reportWarning(ttlAst, RECPARAM_INVALID, type.toString());
                return this.getUnknownType();
            }
            JSType recType = this.buildRecordTypeFromObject(objType);
            if (recType.isEquivalentTo(this.getObjectType())) continue;
            recTypesBuilder.add((Object)recType.toMaybeRecordType());
        }
        return this.joinRecordTypes((ImmutableList<RecordType>)recTypesBuilder.build());
    }

    private void putNewPropInPropertyMap(Map<String, JSType> props, String newPropName, JSType newPropValue) {
        if (!(props.containsKey(newPropName) && newPropValue.isRecordType() && props.get(newPropName).isRecordType())) {
            props.put(newPropName, newPropValue);
            return;
        }
        props.put(newPropName, this.joinRecordTypes((ImmutableList<RecordType>)ImmutableList.of((Object)((RecordType)props.get(newPropName)), (Object)((RecordType)newPropValue))));
    }

    private void addNewPropsFromRecordType(Map<String, JSType> props, RecordType recType) {
        for (String newPropName : recType.getOwnPropertyNames()) {
            JSType newPropValue = recType.getSlot(newPropName).getType();
            this.putNewPropInPropertyMap(props, newPropName, newPropValue);
        }
    }

    private JSType joinRecordTypes(ImmutableList<RecordType> recTypes) {
        HashMap<String, JSType> props = new HashMap<String, JSType>();
        for (int i = 0; i < recTypes.size(); ++i) {
            this.addNewPropsFromRecordType(props, (RecordType)recTypes.get(i));
        }
        return this.createRecordType((ImmutableMap<String, JSType>)ImmutableMap.copyOf(props));
    }

    private JSType evalMaprecord(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType type = this.evalInternal((Node)params.get(0), nameResolver);
        if (type.isEquivalentTo(this.getObjectType())) {
            return this.getObjectType();
        }
        if (!type.isRecordType()) {
            this.reportWarning((Node)params.get(0), RECTYPE_INVALID, type.toString());
            return this.getUnknownType();
        }
        RecordType recType = (RecordType)type;
        Set<String> ownPropsNames = recType.getOwnPropertyNames();
        Node mapFunction = (Node)params.get(1);
        String paramKey = this.getFunctionParameter(mapFunction, 0);
        String paramValue = this.getFunctionParameter(mapFunction, 1);
        if (nameResolver.nameVars.containsKey((Object)paramKey)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramKey);
            return this.getUnknownType();
        }
        if (nameResolver.typeVars.containsKey((Object)paramValue)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramValue);
            return this.getUnknownType();
        }
        Node mapFnBody = this.getFunctionBody(mapFunction);
        HashMap<String, JSType> newProps = new HashMap<String, JSType>();
        for (String propName : ownPropsNames) {
            JSType propValue = recType.getSlot(propName).getType();
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramValue, propValue), this.addNewEntry(nameResolver.nameVars, paramKey, propName));
            JSType body = this.evalInternal(mapFnBody, newNameResolver);
            if (body.isUnknownType()) {
                return this.getUnknownType();
            }
            if (body.isNoType() || body.isEquivalentTo(this.getObjectType())) continue;
            if (!body.isRecordType()) {
                this.reportWarning(ttlAst, MAPRECORD_BODY_INVALID, body.toString());
                return this.getUnknownType();
            }
            RecordType bodyAsRecType = (RecordType)body;
            for (String newPropName : bodyAsRecType.getOwnPropertyNames()) {
                JSType newPropValue = bodyAsRecType.getSlot(newPropName).getType();
                this.putNewPropInPropertyMap(newProps, newPropName, newPropValue);
            }
        }
        return this.createRecordType((ImmutableMap<String, JSType>)ImmutableMap.copyOf(newProps));
    }

    private JSType evalTypeOfVar(Node ttlAst) {
        String name = this.getCallArgument(ttlAst, 0).getString();
        StaticTypedSlot<JSType> slot = this.scope.getSlot(name);
        if (slot == null) {
            this.reportWarning(ttlAst, VAR_UNDEFINED, name);
            return this.getUnknownType();
        }
        return slot.getType();
    }

    private JSType evalInstanceOf(Node ttlAst, NameResolver nameResolver) {
        JSType type = this.evalInternal(this.getCallArgument(ttlAst, 0), nameResolver);
        if (type.isUnknownType() || !type.isConstructor()) {
            this.reportWarning(ttlAst, INVALID_CTOR, type.getDisplayName());
            return this.getUnknownType();
        }
        return ((FunctionType)type).getInstanceType();
    }

    private JSType evalNativeTypeExpr(Node ttlAst) {
        return new JSTypeExpression(this.getCallArgument(ttlAst, 0), "").evaluate(this.scope, this.typeRegistry);
    }

    private JSType evalPrintType(Node ttlAst, NameResolver nameResolver) {
        JSType type = this.evalInternal(this.getCallArgument(ttlAst, 1), nameResolver);
        String msg = this.getCallArgument(ttlAst, 0).getString() + type;
        System.out.println(msg);
        return type;
    }

    private JSType evalPropType(Node ttlAst, NameResolver nameResolver) {
        JSType type = this.evalInternal(this.getCallArgument(ttlAst, 1), nameResolver);
        ObjectType objType = type.toObjectType();
        if (objType == null) {
            this.reportWarning(ttlAst, PROPTYPE_INVALID, type.toString());
            return this.getUnknownType();
        }
        return objType.getPropertyType(this.getCallArgument(ttlAst, 0).getString());
    }

    private class NameResolver {
        ImmutableMap<String, JSType> typeVars;
        ImmutableMap<String, String> nameVars;

        NameResolver(ImmutableMap<String, JSType> typeVars, ImmutableMap<String, String> nameVars) {
            this.typeVars = typeVars;
            this.nameVars = nameVars;
        }
    }
}

