/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.ident;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.util.SecurityUtility;

public class Identity
implements Serializable {
    static final long serialVersionUID = -2788084303665751253L;
    private static transient Random random = new Random(System.currentTimeMillis());
    public static transient String DEFAULT_DOMAIN;
    private static transient String _domain;
    private static transient Map identities;
    private final String instanceid;
    private final InetAddress ip;
    private final String serverid;
    private String domain;
    private int hashCode;

    private Identity(InetAddress addr, String instanceid, String serverid) {
        this.ip = addr;
        this.instanceid = instanceid;
        this.serverid = serverid;
        this.domain = _domain == null || _domain.equals("") ? DEFAULT_DOMAIN : _domain;
        this.calcHashCode();
    }

    private void calcHashCode() {
        this.hashCode = this.ip.hashCode() + this.instanceid.hashCode() + this.serverid.hashCode() - this.domain.hashCode();
    }

    public static void setDomain(String domain) {
        Iterator iter = identities.keySet().iterator();
        while (iter.hasNext()) {
            Identity ident = (Identity)identities.get(iter.next());
            if (ident != null) {
                ident.domain = domain;
            }
            ident.calcHashCode();
        }
        SecurityUtility.setSystemProperty("jboss.identity.domain", domain);
        _domain = domain;
        NetworkRegistry.getInstance().changeDomain(domain);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "JBOSS Identity\n\taddress:" + this.ip + "\n\tinstanceid:" + this.instanceid + "\n\tJMX id:" + this.serverid + "\n\tdomain:" + this.domain + "\n";
    }

    public final String getDomain() {
        return this.domain;
    }

    public String getInstanceId() {
        return this.instanceid;
    }

    public InetAddress getAddress() {
        return this.ip;
    }

    public String getJMXId() {
        return this.serverid;
    }

    public boolean isSameJVM(Identity identity) {
        return identity.equals(this);
    }

    public boolean isSameInstance(Identity identity) {
        return identity.getInstanceId().equals(this.instanceid);
    }

    public boolean isSameMachine(Identity identity) {
        return identity.getAddress().equals(this.ip);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Identity) {
            return this.hashCode == obj.hashCode();
        }
        return false;
    }

    public static final synchronized Identity get(MBeanServer server) {
        if (identities.containsKey(server)) {
            return (Identity)identities.get(server);
        }
        try {
            InetAddress localHost = SecurityUtility.getLocalHost();
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            String serverid = (String)SecurityUtility.getMBeanAttribute(server, objectName, "MBeanServerId");
            Identity identity = new Identity(localHost, Identity.createId(server), serverid);
            identities.put(server, identity);
            return identity;
        }
        catch (Exception ex) {
            String type = ex.getClass().getName();
            RuntimeException rex = new RuntimeException("Exception creating identity: " + type + ": " + ex.getMessage());
            rex.setStackTrace(ex.getStackTrace());
            throw rex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final synchronized String createId(MBeanServer server) {
        String id;
        block24: {
            File dir;
            String myid = SecurityUtility.getSystemProperty("jboss.identity");
            if (myid != null) {
                return myid;
            }
            id = null;
            File file = null;
            try {
                ObjectName obj = new ObjectName("jboss.system:type=ServerConfig");
                dir = (File)SecurityUtility.getMBeanAttribute(server, obj, "ServerDataDir");
                if (dir != null) {
                    if (!SecurityUtility.fileExists(dir)) {
                        SecurityUtility.mkdirs(dir);
                    }
                    file = new File(dir, "jboss.identity");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (file == null) {
                String fl = SecurityUtility.getSystemProperty("jboss.identity.dir", ".");
                dir = new File(fl);
                if (!SecurityUtility.fileExists(dir)) {
                    SecurityUtility.mkdirs(dir);
                }
                file = new File(dir, "jboss.identity");
            }
            boolean canRead = SecurityUtility.canRead(file);
            if (SecurityUtility.fileExists(file) && canRead) {
                FileInputStream is = null;
                try {
                    try {
                        is = SecurityUtility.getFileInputStream(file);
                        byte[] buf = new byte[800];
                        int c = ((InputStream)is).read(buf);
                        id = new String(buf, 0, c);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Error loading jboss.identity: " + ex.toString());
                    }
                    Object var9_12 = null;
                    if (is == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (is == null) throw throwable;
                    try {
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ig) {}
                ((InputStream)is).close();
            } else {
                FileOutputStream out = null;
                try {
                    try {
                        id = Identity.createUniqueID();
                        if (!SecurityUtility.fileExists(file)) {
                            SecurityUtility.createNewFile(file);
                        }
                        out = SecurityUtility.getFileOutputStream(file);
                        ((OutputStream)out).write(id.getBytes());
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Error creating Instance ID: " + ex.toString());
                    }
                    Object var12_17 = null;
                    if (out == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    if (out == null) throw throwable;
                    try {
                        out.flush();
                        ((OutputStream)out).close();
                        throw throwable;
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ig) {}
                out.flush();
                ((OutputStream)out).close();
            }
        }
        SecurityUtility.setSystemProperty("jboss.identity", id);
        return id;
    }

    public static final String createUniqueID() {
        String id = new VMID().toString();
        return id.replace(':', 'x') + random.nextInt(1000);
    }

    static {
        _domain = DEFAULT_DOMAIN = "JBOSS";
        _domain = SecurityUtility.getSystemProperty("jboss.identity.domain", DEFAULT_DOMAIN);
        identities = new WeakHashMap(2);
    }
}

