/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection.multicast;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.remoting.detection.AbstractDetector;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.multicast.MulticastDetectorMBean;
import org.jboss.remoting.util.SecurityUtility;

public class MulticastDetector
extends AbstractDetector
implements MulticastDetectorMBean {
    private static int threadCounter = 0;
    private String defaultIP = "224.1.9.1";
    private InetAddress addr;
    private InetAddress bindAddr;
    private int port = 2410;
    private MulticastSocket socket;
    private Listener listener = new Listener("Remoting Multicast Detector - Listener Thread: " + threadCounter++);

    public String getDefaultIP() {
        return this.defaultIP;
    }

    public void setDefaultIP(String defaultIP) {
        this.defaultIP = defaultIP;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public void setAddress(InetAddress ip) {
        this.addr = ip;
    }

    public InetAddress getBindAddress() {
        return this.bindAddr;
    }

    public void setBindAddress(InetAddress ip) {
        this.bindAddr = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        if (this.addr == null) {
            this.addr = SecurityUtility.getAddressByName(this.defaultIP);
        }
        InetAddress localHost = SecurityUtility.getLocalHost();
        if (this.bindAddr == null && localHost.getHostAddress().equals("127.0.0.1")) {
            this.bindAddr = localHost;
        }
        try {
            final InetSocketAddress saddr = new InetSocketAddress(this.bindAddr, this.port);
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    MulticastDetector.this.socket = new MulticastSocket(saddr);
                    MulticastDetector.this.socket.joinGroup(MulticastDetector.this.addr);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
        super.start();
        if (this.listener == null) {
            this.listener = new Listener("Remoting Multicast Detector - Listener Thread: " + threadCounter++);
        }
        this.listener.start();
    }

    public void stop() throws Exception {
        super.stop();
        if (this.listener != null) {
            try {
                this.listener.running = false;
                this.listener.interrupt();
            }
            catch (Exception e) {
                log.warn((Object)(this + " Error stopping multicast detector.  " + e.getMessage()));
            }
            this.listener = null;
        }
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.addr);
                this.socket.close();
            }
            catch (IOException e) {
                log.warn((Object)(this + " Error stopping multicast detector.  " + e.getMessage()));
            }
            this.socket = null;
        }
    }

    protected void heartbeat() {
        if (this.socket != null) {
            Detection msg = this.createDetection();
            if (msg == null) {
                return;
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " sending heartbeat: " + msg));
                }
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
                objectOut.writeObject(msg);
                objectOut.flush();
                byteOut.flush();
                byte[] buf = byteOut.toByteArray();
                DatagramPacket p = new DatagramPacket(buf, buf.length, this.addr, this.port);
                this.socket.send(p);
            }
            catch (Throwable ex) {
                log.debug((Object)(this + " heartbeat failed"), ex);
            }
        }
    }

    protected void forceHeartbeat() {
        if (this.socket != null) {
            String msg = "Send heartbeat";
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
                objectOut.writeObject(msg);
                objectOut.flush();
                byteOut.flush();
                byte[] buf = byteOut.toByteArray();
                DatagramPacket p = new DatagramPacket(buf, buf.length, this.addr, this.port);
                this.socket.send(p);
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (Throwable ex) {
                log.debug((Object)(this + " forced heartbeat failed"), ex);
            }
        }
    }

    private void listen(DatagramPacket p, byte[] buf) {
        block7: {
            if (this.socket != null) {
                try {
                    this.socket.receive(p);
                    ByteArrayInputStream byteInput = new ByteArrayInputStream(buf);
                    ObjectInputStream objectInput = new ObjectInputStream(byteInput);
                    Object obj = objectInput.readObject();
                    if (obj instanceof Detection) {
                        Detection msg = (Detection)obj;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(this + " received detection: " + msg));
                        }
                        this.detect(msg);
                    } else {
                        this.heartbeat();
                    }
                }
                catch (Throwable e) {
                    if (e instanceof InvalidClassException) {
                        return;
                    }
                    if (this.socket == null) break block7;
                    log.debug((Object)(this + " Error receiving detection"), e);
                }
            }
        }
    }

    private final class Listener
    extends Thread {
        boolean running;

        public Listener(String name) {
            super(name);
            this.running = true;
        }

        public void run() {
            byte[] buf = new byte[4000];
            DatagramPacket p = new DatagramPacket(buf, 0, buf.length);
            while (this.running) {
                MulticastDetector.this.listen(p, buf);
            }
        }
    }
}

