/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

abstract class AbstractPeepholeOptimization {
    private AbstractCompiler compiler;

    AbstractPeepholeOptimization() {
    }

    abstract Node optimizeSubtree(Node var1);

    protected void error(DiagnosticType diagnostic, Node n) {
        JSError error = JSError.make(NodeUtil.getSourceName(n), n, diagnostic, n.toString());
        this.compiler.report(error);
    }

    protected void reportCodeChange() {
        Preconditions.checkNotNull((Object)this.compiler);
        this.compiler.reportCodeChange();
    }

    protected boolean areNodesEqualForInlining(Node n1, Node n2) {
        Preconditions.checkNotNull((Object)this.compiler);
        return this.compiler.areNodesEqualForInlining(n1, n2);
    }

    protected boolean isASTNormalized() {
        Preconditions.checkNotNull((Object)this.compiler);
        return this.compiler.getLifeCycleStage().isNormalized();
    }

    void beginTraversal(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    void endTraversal(AbstractCompiler compiler) {
        this.compiler = null;
    }

    boolean mayEffectMutableState(Node n) {
        return NodeUtil.mayEffectMutableState(n, this.compiler);
    }

    boolean mayHaveSideEffects(Node n) {
        return NodeUtil.mayHaveSideEffects(n, this.compiler);
    }

    boolean nodeTypeMayHaveSideEffects(Node n) {
        return NodeUtil.nodeTypeMayHaveSideEffects(n, this.compiler);
    }

    boolean isEcmaScript5OrGreater() {
        return this.compiler != null && this.compiler.acceptEcmaScript5();
    }

    CodingConvention getCodingConvention() {
        return this.compiler.getCodingConvention();
    }

    @VisibleForTesting
    static Node validateResult(Node n) {
        block2: {
            if (!(n == null || n.isScript() || n.isBlock() && n.isSyntheticBlock())) {
                for (Node parent : n.getAncestors()) {
                    if (!parent.isScript()) continue;
                    break block2;
                }
                Preconditions.checkState((boolean)false);
            }
        }
        return n;
    }
}

