/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TypeCheck
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType UNEXPECTED_TOKEN = DiagnosticType.error("JSC_INTERNAL_ERROR_UNEXPECTED_TOKEN", "Internal Error: Don't know how to handle {0}");
    static final DiagnosticType BAD_DELETE = DiagnosticType.warning("JSC_BAD_DELETE_OPERAND", "delete operator needs a reference operand");
    protected static final String OVERRIDING_PROTOTYPE_WITH_NON_OBJECT = "overriding prototype with non-object";
    static final DiagnosticType DETERMINISTIC_TEST = DiagnosticType.warning("JSC_DETERMINISTIC_TEST", "condition always evaluates to {2}\nleft : {0}\nright: {1}");
    static final DiagnosticType DETERMINISTIC_TEST_NO_RESULT = DiagnosticType.warning("JSC_DETERMINISTIC_TEST_NO_RESULT", "condition always evaluates to the same value\nleft : {0}\nright: {1}");
    static final DiagnosticType INEXISTENT_ENUM_ELEMENT = DiagnosticType.warning("JSC_INEXISTENT_ENUM_ELEMENT", "element {0} does not exist on this enum");
    static final DiagnosticType INEXISTENT_PROPERTY = DiagnosticType.disabled("JSC_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    protected static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NOT_A_CONSTRUCTOR", "cannot instantiate non-constructor");
    static final DiagnosticType BIT_OPERATION = DiagnosticType.warning("JSC_BAD_TYPE_FOR_BIT_OPERATION", "operator {0} cannot be applied to {1}");
    static final DiagnosticType NOT_CALLABLE = DiagnosticType.warning("JSC_NOT_FUNCTION_TYPE", "{0} expressions are not callable");
    static final DiagnosticType CONSTRUCTOR_NOT_CALLABLE = DiagnosticType.warning("JSC_CONSTRUCTOR_NOT_CALLABLE", "Constructor {0} should be called with the \"new\" keyword");
    static final DiagnosticType FUNCTION_MASKS_VARIABLE = DiagnosticType.warning("JSC_FUNCTION_MASKS_VARIABLE", "function {0} masks variable (IE bug)");
    static final DiagnosticType MULTIPLE_VAR_DEF = DiagnosticType.warning("JSC_MULTIPLE_VAR_DEF", "declaration of multiple variables with shared type information");
    static final DiagnosticType ENUM_DUP = DiagnosticType.error("JSC_ENUM_DUP", "enum element {0} already defined");
    static final DiagnosticType ENUM_NOT_CONSTANT = DiagnosticType.warning("JSC_ENUM_NOT_CONSTANT", "enum key {0} must be a syntactic constant");
    static final DiagnosticType INVALID_INTERFACE_MEMBER_DECLARATION = DiagnosticType.warning("JSC_INVALID_INTERFACE_MEMBER_DECLARATION", "interface members can only be empty property declarations, empty functions{0}");
    static final DiagnosticType INTERFACE_FUNCTION_NOT_EMPTY = DiagnosticType.warning("JSC_INTERFACE_FUNCTION_NOT_EMPTY", "interface member functions must have an empty body");
    static final DiagnosticType CONFLICTING_EXTENDED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_EXTENDED_TYPE", "{1} cannot extend this type; {0}s can only extend {0}s");
    static final DiagnosticType CONFLICTING_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_IMPLEMENTED_TYPE", "{0} cannot implement this type; an interface can only extend, but not implement interfaces");
    static final DiagnosticType BAD_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_IMPLEMENTS_NON_INTERFACE", "can only implement interfaces");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY", "property {0} already defined on superclass {1}; use @override to override it");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY = DiagnosticType.warning("JSC_HIDDEN_INTERFACE_PROPERTY", "property {0} already defined on interface {1}; use @override to override it");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType UNKNOWN_OVERRIDE = DiagnosticType.warning("JSC_UNKNOWN_OVERRIDE", "property {0} not defined on any superclass of {1}");
    static final DiagnosticType INTERFACE_METHOD_OVERRIDE = DiagnosticType.warning("JSC_INTERFACE_METHOD_OVERRIDE", "property {0} is already defined by the {1} extended interface");
    static final DiagnosticType UNKNOWN_EXPR_TYPE = DiagnosticType.warning("JSC_UNKNOWN_EXPR_TYPE", "could not determine the type of this expression");
    static final DiagnosticType UNRESOLVED_TYPE = DiagnosticType.warning("JSC_UNRESOLVED_TYPE", "could not resolve the name {0} to a type");
    static final DiagnosticType WRONG_ARGUMENT_COUNT = DiagnosticType.warning("JSC_WRONG_ARGUMENT_COUNT", "Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}.");
    static final DiagnosticType ILLEGAL_IMPLICIT_CAST = DiagnosticType.warning("JSC_ILLEGAL_IMPLICIT_CAST", "Illegal annotation on {0}. @implicitCast may only be used in externs.");
    static final DiagnosticType INCOMPATIBLE_EXTENDED_PROPERTY_TYPE = DiagnosticType.warning("JSC_INCOMPATIBLE_EXTENDED_PROPERTY_TYPE", "Interface {0} has a property {1} with incompatible types in its super interfaces {2} and {3}");
    static final DiagnosticType EXPECTED_THIS_TYPE = DiagnosticType.warning("JSC_EXPECTED_THIS_TYPE", "\"{0}\" must be called with a \"this\" type");
    static final DiagnosticType IN_USED_WITH_STRUCT = DiagnosticType.warning("JSC_IN_USED_WITH_STRUCT", "Cannot use the IN operator with structs");
    static final DiagnosticType ILLEGAL_PROPERTY_CREATION = DiagnosticType.warning("JSC_ILLEGAL_PROPERTY_CREATION", "Cannot add a property to a struct instance after it is constructed.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(DETERMINISTIC_TEST, DETERMINISTIC_TEST_NO_RESULT, INEXISTENT_ENUM_ELEMENT, INEXISTENT_PROPERTY, NOT_A_CONSTRUCTOR, BIT_OPERATION, NOT_CALLABLE, CONSTRUCTOR_NOT_CALLABLE, FUNCTION_MASKS_VARIABLE, MULTIPLE_VAR_DEF, ENUM_DUP, ENUM_NOT_CONSTANT, INVALID_INTERFACE_MEMBER_DECLARATION, INTERFACE_FUNCTION_NOT_EMPTY, CONFLICTING_EXTENDED_TYPE, CONFLICTING_IMPLEMENTED_TYPE, BAD_IMPLEMENTED_TYPE, HIDDEN_SUPERCLASS_PROPERTY, HIDDEN_INTERFACE_PROPERTY, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, UNKNOWN_OVERRIDE, INTERFACE_METHOD_OVERRIDE, UNKNOWN_EXPR_TYPE, UNRESOLVED_TYPE, WRONG_ARGUMENT_COUNT, ILLEGAL_IMPLICIT_CAST, INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, EXPECTED_THIS_TYPE, IN_USED_WITH_STRUCT, ILLEGAL_PROPERTY_CREATION, RhinoErrorReporter.TYPE_PARSE_ERROR, TypedScopeCreator.UNKNOWN_LENDS, TypedScopeCreator.LENDS_ON_NON_OBJECT, TypedScopeCreator.CTOR_INITIALIZER, TypedScopeCreator.IFACE_INITIALIZER, FunctionTypeBuilder.THIS_TYPE_NON_OBJECT);
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final JSTypeRegistry typeRegistry;
    private Scope topScope;
    private MemoizedScopeCreator scopeCreator;
    private final CheckLevel reportMissingOverride;
    private final CheckLevel reportUnknownTypes;
    private boolean reportMissingProperties = true;
    private InferJSDocInfo inferJSDocInfo = null;
    private int typedCount = 0;
    private int nullCount = 0;
    private int unknownCount = 0;
    private boolean inExterns;
    private int noTypeCheckSection = 0;

    public TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry, Scope topScope, MemoizedScopeCreator scopeCreator, CheckLevel reportMissingOverride, CheckLevel reportUnknownTypes) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.reverseInterpreter = reverseInterpreter;
        this.typeRegistry = typeRegistry;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.reportMissingOverride = reportMissingOverride;
        this.reportUnknownTypes = reportUnknownTypes;
        this.inferJSDocInfo = new InferJSDocInfo(compiler);
    }

    public TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry, CheckLevel reportMissingOverride, CheckLevel reportUnknownTypes) {
        this(compiler, reverseInterpreter, typeRegistry, null, null, reportMissingOverride, reportUnknownTypes);
    }

    TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry) {
        this(compiler, reverseInterpreter, typeRegistry, null, null, CheckLevel.WARNING, CheckLevel.OFF);
    }

    TypeCheck reportMissingProperties(boolean report) {
        this.reportMissingProperties = report;
        return this;
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Preconditions.checkNotNull((Object)this.scopeCreator);
        Preconditions.checkNotNull((Object)this.topScope);
        Node externsAndJs = jsRoot.getParent();
        Preconditions.checkState((externsAndJs != null ? 1 : 0) != 0);
        Preconditions.checkState((externsRoot == null || externsAndJs.hasChild(externsRoot) ? 1 : 0) != 0);
        if (externsRoot != null) {
            this.check(externsRoot, true);
        }
        this.check(jsRoot, false);
    }

    public Scope processForTesting(Node externsRoot, Node jsRoot) {
        Preconditions.checkState((this.scopeCreator == null ? 1 : 0) != 0);
        Preconditions.checkState((this.topScope == null ? 1 : 0) != 0);
        Preconditions.checkState((jsRoot.getParent() != null ? 1 : 0) != 0);
        Node externsAndJsRoot = jsRoot.getParent();
        this.scopeCreator = new MemoizedScopeCreator(new TypedScopeCreator(this.compiler));
        this.topScope = this.scopeCreator.createScope(externsAndJsRoot, null);
        TypeInferencePass inference = new TypeInferencePass(this.compiler, this.reverseInterpreter, this.topScope, this.scopeCreator);
        inference.process(externsRoot, jsRoot);
        this.process(externsRoot, jsRoot);
        return this.topScope;
    }

    public void check(Node node, boolean externs) {
        Preconditions.checkNotNull((Object)node);
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        this.inExterns = externs;
        t.traverseWithScope(node, this.topScope);
        if (externs) {
            this.inferJSDocInfo.process(node, null);
        } else {
            this.inferJSDocInfo.process(null, node);
        }
    }

    private void checkNoTypeCheckSection(Node n, boolean enterSection) {
        switch (n.getType()) {
            case 86: 
            case 105: 
            case 118: 
            case 125: 
            case 132: {
                JSDocInfo info = n.getJSDocInfo();
                if (info != null && info.isNoTypeCheck()) {
                    this.noTypeCheckSection = enterSection ? ++this.noTypeCheckSection : --this.noTypeCheckSection;
                }
                this.validator.setShouldReport(this.noTypeCheckSection == 0);
            }
        }
    }

    private void report(NodeTraversal t, Node n, DiagnosticType diagnosticType, String ... arguments) {
        if (this.noTypeCheckSection == 0) {
            t.report(n, diagnosticType, arguments);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        this.checkNoTypeCheckSection(n, true);
        switch (n.getType()) {
            case 105: {
                Scope outerScope = t.getScope();
                String functionPrivateName = n.getFirstChild().getString();
                if (functionPrivateName == null || functionPrivateName.length() <= 0 || !outerScope.isDeclared(functionPrivateName, false) || outerScope.getVar(functionPrivateName).getType() instanceof FunctionType) break;
                this.report(t, n, FUNCTION_MASKS_VARIABLE, functionPrivateName);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        boolean typeable = true;
        switch (n.getType()) {
            case 38: {
                typeable = this.visitName(t, n, parent);
                break;
            }
            case 83: {
                typeable = false;
                break;
            }
            case 85: {
                this.ensureTyped(t, n, this.getJSType(n.getLastChild()));
                break;
            }
            case 43: 
            case 44: {
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 42: {
                this.ensureTyped(t, n, t.getScope().getTypeOfThis());
                break;
            }
            case 41: {
                this.ensureTyped(t, n, JSTypeNative.NULL_TYPE);
                break;
            }
            case 39: {
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 40: {
                this.ensureTyped(t, n, JSTypeNative.STRING_TYPE);
                break;
            }
            case 154: {
                typeable = false;
                break;
            }
            case 147: 
            case 148: {
                break;
            }
            case 63: {
                this.ensureTyped(t, n, JSTypeNative.ARRAY_TYPE);
                break;
            }
            case 47: {
                this.ensureTyped(t, n, JSTypeNative.REGEXP_TYPE);
                break;
            }
            case 33: {
                this.visitGetProp(t, n, parent);
                typeable = !parent.isAssign() || parent.getFirstChild() != n;
                break;
            }
            case 35: {
                this.visitGetElem(t, n);
                typeable = false;
                break;
            }
            case 118: {
                this.visitVar(t, n);
                typeable = false;
                break;
            }
            case 30: {
                this.visitNew(t, n);
                break;
            }
            case 37: {
                this.visitCall(t, n);
                typeable = !parent.isExprResult();
                break;
            }
            case 4: {
                this.visitReturn(t, n);
                typeable = false;
                break;
            }
            case 102: 
            case 103: {
                Node left = n.getFirstChild();
                this.checkPropCreation(t, left);
                this.validator.expectNumber(t, left, this.getJSType(left), "increment/decrement");
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 26: {
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 122: {
                this.ensureTyped(t, n, JSTypeNative.VOID_TYPE);
                break;
            }
            case 32: {
                this.ensureTyped(t, n, JSTypeNative.STRING_TYPE);
                break;
            }
            case 27: {
                JSType childType = this.getJSType(n.getFirstChild());
                if (!childType.matchesInt32Context()) {
                    this.report(t, n, BIT_OPERATION, NodeUtil.opToStr(n.getType()), childType.toString());
                }
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 28: 
            case 29: {
                Node left = n.getFirstChild();
                this.validator.expectNumber(t, left, this.getJSType(left), "sign operator");
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (left.isTypeOf()) {
                    if (right.isString()) {
                        this.checkTypeofString(t, right, right.getString());
                    }
                } else if (right.isTypeOf() && left.isString()) {
                    this.checkTypeofString(t, left, left.getString());
                }
                JSType leftType = this.getJSType(left);
                JSType rightType = this.getJSType(right);
                JSType leftTypeRestricted = leftType.restrictByNotNullOrUndefined();
                JSType rightTypeRestricted = rightType.restrictByNotNullOrUndefined();
                TernaryValue result = TernaryValue.UNKNOWN;
                if (n.getType() == 12 || n.getType() == 13) {
                    result = leftTypeRestricted.testForEquality(rightTypeRestricted);
                    if (n.isNE()) {
                        result = result.not();
                    }
                } else if (!leftTypeRestricted.canTestForShallowEqualityWith(rightTypeRestricted)) {
                    TernaryValue ternaryValue = result = n.getType() == 45 ? TernaryValue.FALSE : TernaryValue.TRUE;
                }
                if (result != TernaryValue.UNKNOWN) {
                    this.report(t, n, DETERMINISTIC_TEST, leftType.toString(), rightType.toString(), result.toString());
                }
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                JSType leftType = this.getJSType(n.getFirstChild());
                JSType rightType = this.getJSType(n.getLastChild());
                if (rightType.isNumber()) {
                    this.validator.expectNumber(t, n, leftType, "left side of numeric comparison");
                } else if (leftType.isNumber()) {
                    this.validator.expectNumber(t, n, rightType, "right side of numeric comparison");
                } else if (!leftType.matchesNumberContext() || !rightType.matchesNumberContext()) {
                    String message = "left side of comparison";
                    this.validator.expectString(t, n, leftType, message);
                    this.validator.expectNotNullOrUndefined(t, n, leftType, message, this.getNativeType(JSTypeNative.STRING_TYPE));
                    message = "right side of comparison";
                    this.validator.expectString(t, n, rightType, message);
                    this.validator.expectNotNullOrUndefined(t, n, rightType, message, this.getNativeType(JSTypeNative.STRING_TYPE));
                }
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 51: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                JSType rightType = this.getJSType(right);
                this.validator.expectString(t, left, this.getJSType(left), "left side of 'in'");
                this.validator.expectObject(t, n, rightType, "'in' requires an object");
                if (rightType.isStruct()) {
                    this.report(t, right, IN_USED_WITH_STRUCT, new String[0]);
                }
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 52: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                JSType rightType = this.getJSType(right).restrictByNotNullOrUndefined();
                this.validator.expectAnyObject(t, left, this.getJSType(left), "deterministic instanceof yields false");
                this.validator.expectActualObject(t, right, rightType, "instanceof requires an object");
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 86: {
                this.visitAssign(t, n);
                typeable = false;
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.checkPropCreation(t, n.getFirstChild());
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.visitBinaryOperator(n.getType(), t, n);
                break;
            }
            case 31: {
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 111: {
                JSType switchType = this.getJSType(parent.getFirstChild());
                JSType caseType = this.getJSType(n.getFirstChild());
                this.validator.expectSwitchMatchesCase(t, n, switchType, caseType);
                typeable = false;
                break;
            }
            case 119: {
                Node child = n.getFirstChild();
                JSType childType = this.getJSType(child);
                this.validator.expectObject(t, child, childType, "with requires an object");
                typeable = false;
                break;
            }
            case 105: {
                this.visitFunction(t, n);
                break;
            }
            case 49: 
            case 77: 
            case 110: 
            case 112: 
            case 116: 
            case 117: 
            case 120: 
            case 124: 
            case 125: 
            case 126: 
            case 130: 
            case 132: 
            case 152: 
            case 153: {
                typeable = false;
                break;
            }
            case 108: 
            case 113: 
            case 114: {
                typeable = false;
                break;
            }
            case 115: {
                Node obj;
                if (NodeUtil.isForIn(n) && this.getJSType(obj = n.getChildAtIndex(1)).isStruct()) {
                    this.report(t, obj, IN_USED_WITH_STRUCT, new String[0]);
                }
                typeable = false;
                break;
            }
            case 64: 
            case 98: 
            case 100: 
            case 101: {
                if (n.getJSType() != null) {
                    this.ensureTyped(t, n);
                } else if (n.isObjectLit() && parent.getJSType() instanceof EnumType) {
                    this.ensureTyped(t, n, parent.getJSType());
                } else {
                    this.ensureTyped(t, n);
                }
                if (!n.isObjectLit()) break;
                for (Node key : n.children()) {
                    this.visitObjLitKey(t, key, n);
                }
                break;
            }
            default: {
                this.report(t, n, UNEXPECTED_TOKEN, Token.name(n.getType()));
                this.ensureTyped(t, n);
            }
        }
        boolean bl = typeable = typeable && !this.inExterns;
        if (typeable) {
            this.doPercentTypedAccounting(t, n);
        }
        this.checkNoTypeCheckSection(n, false);
    }

    private void checkTypeofString(NodeTraversal t, Node n, String s) {
        if (!(s.equals("number") || s.equals("string") || s.equals("boolean") || s.equals("undefined") || s.equals("function") || s.equals("object") || s.equals("unknown"))) {
            this.validator.expectValidTypeofName(t, n, s);
        }
    }

    private void doPercentTypedAccounting(NodeTraversal t, Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            ++this.nullCount;
        } else if (type.isUnknownType()) {
            if (this.reportUnknownTypes.isOn()) {
                this.compiler.report(t.makeError(n, this.reportUnknownTypes, UNKNOWN_EXPR_TYPE, new String[0]));
            }
            ++this.unknownCount;
        } else {
            ++this.typedCount;
        }
    }

    private void visitAssign(NodeTraversal t, Node assign) {
        Node rightChild;
        JSType rightType;
        JSDocInfo info = assign.getJSDocInfo();
        Node lvalue = assign.getFirstChild();
        Node rvalue = assign.getLastChild();
        if (lvalue.isGetProp()) {
            JSType expectedType;
            FunctionType functionType;
            JSType jsType;
            Node object = lvalue.getFirstChild();
            JSType objectJsType = this.getJSType(object);
            Node property = lvalue.getLastChild();
            String pname = property.getString();
            if (object.isGetProp() && (jsType = this.getJSType(object.getFirstChild())).isInterface() && object.getLastChild().getString().equals("prototype")) {
                this.visitInterfaceGetprop(t, assign, object, pname, lvalue, rvalue);
            }
            this.checkEnumAlias(t, info, rvalue);
            this.checkPropCreation(t, lvalue);
            if (pname.equals("prototype") && objectJsType != null && objectJsType.isFunctionType() && (functionType = objectJsType.toMaybeFunctionType()).isConstructor()) {
                JSType rvalueType = rvalue.getJSType();
                this.validator.expectObject(t, rvalue, rvalueType, OVERRIDING_PROTOTYPE_WITH_NON_OBJECT);
                if (functionType.makesStructs() && !rvalueType.isStruct()) {
                    String funName = functionType.getTypeOfThis().toString();
                    this.compiler.report(t.makeError(assign, CONFLICTING_EXTENDED_TYPE, "struct", funName));
                }
                return;
            }
            ObjectType type = ObjectType.cast(objectJsType.restrictByNotNullOrUndefined());
            if (type != null && type.hasProperty(pname) && !type.isPropertyTypeInferred(pname) && !this.propertyIsImplicitCast(type, pname) && !(expectedType = type.getPropertyType(pname)).isUnknownType()) {
                this.validator.expectCanAssignToPropertyOf(t, assign, this.getJSType(rvalue), expectedType, object, pname);
                this.checkPropertyInheritanceOnGetpropAssign(t, assign, object, pname, info, expectedType);
                return;
            }
            this.checkPropertyInheritanceOnGetpropAssign(t, assign, object, pname, info, this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }
        JSType leftType = this.getJSType(lvalue);
        if (lvalue.isQualifiedName()) {
            JSType rvalueType = this.getJSType(assign.getLastChild());
            Scope.Var var = t.getScope().getVar(lvalue.getQualifiedName());
            if (var != null) {
                if (var.isTypeInferred()) {
                    return;
                }
                if (NodeUtil.getRootOfQualifiedName(lvalue).isThis() && t.getScope() != var.getScope()) {
                    return;
                }
                if (var.getType() != null) {
                    leftType = var.getType();
                }
            }
        }
        if (this.validator.expectCanAssignTo(t, assign, rightType = this.getJSType(rightChild = assign.getLastChild()), leftType, "assignment")) {
            this.ensureTyped(t, assign, rightType);
        } else {
            this.ensureTyped(t, assign);
        }
    }

    private void checkPropCreation(NodeTraversal t, Node lvalue) {
        if (lvalue.isGetProp()) {
            Node obj = lvalue.getFirstChild();
            Node prop = lvalue.getLastChild();
            JSType objType = this.getJSType(obj);
            String pname = prop.getString();
            if (!(!objType.isStruct() || objType.hasProperty(pname) || obj.isThis() && this.getJSType(t.getScope().getRootNode()).isConstructor())) {
                this.report(t, prop, ILLEGAL_PROPERTY_CREATION, new String[0]);
            }
        }
    }

    private void checkPropertyInheritanceOnGetpropAssign(NodeTraversal t, Node assign, Node object, String property, JSDocInfo info, JSType propertyType) {
        if (object.isGetProp()) {
            FunctionType functionType;
            JSType jsType;
            Node object2 = object.getFirstChild();
            String property2 = NodeUtil.getStringValue(object.getLastChild());
            if ("prototype".equals(property2) && (jsType = this.getJSType(object2)).isFunctionType() && ((functionType = jsType.toMaybeFunctionType()).isConstructor() || functionType.isInterface())) {
                this.checkDeclaredPropertyInheritance(t, assign, functionType, property, info, propertyType);
            }
        }
    }

    private void visitObjLitKey(NodeTraversal t, Node key, Node objlit) {
        boolean valid;
        if (objlit.isFromExterns()) {
            this.ensureTyped(t, key);
            return;
        }
        Node rvalue = key.getFirstChild();
        JSType rightType = NodeUtil.getObjectLitKeyTypeFromValueType(key, this.getJSType(rvalue));
        if (rightType == null) {
            rightType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        Node owner = objlit;
        JSType keyType = this.getJSType(key);
        JSType allowedValueType = keyType;
        if (allowedValueType.isEnumElementType()) {
            allowedValueType = allowedValueType.toMaybeEnumElementType().getPrimitiveType();
        }
        if (valid = this.validator.expectCanAssignToPropertyOf(t, key, rightType, allowedValueType, owner, NodeUtil.getObjectLitKeyName(key))) {
            this.ensureTyped(t, key, rightType);
        } else {
            this.ensureTyped(t, key);
        }
        JSType objlitType = this.getJSType(objlit);
        ObjectType type = ObjectType.cast(objlitType.restrictByNotNullOrUndefined());
        if (type != null) {
            String property = NodeUtil.getObjectLitKeyName(key);
            if (type.hasProperty(property) && !type.isPropertyTypeInferred(property) && !this.propertyIsImplicitCast(type, property)) {
                this.validator.expectCanAssignToPropertyOf(t, key, keyType, type.getPropertyType(property), owner, property);
            }
            return;
        }
    }

    private boolean propertyIsImplicitCast(ObjectType type, String prop) {
        while (type != null) {
            JSDocInfo docInfo = type.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isImplicitCast()) {
                return true;
            }
            type = type.getImplicitPrototype();
        }
        return false;
    }

    private void checkDeclaredPropertyInheritance(NodeTraversal t, Node n, FunctionType ctorType, String propertyName, JSDocInfo info, JSType propertyType) {
        boolean bl;
        if (TypeCheck.hasUnknownOrEmptySupertype(ctorType)) {
            return;
        }
        FunctionType superClass = ctorType.getSuperClassConstructor();
        boolean superClassHasProperty = superClass != null && superClass.getInstanceType().hasProperty(propertyName);
        boolean superClassHasDeclaredProperty = superClass != null && superClass.getInstanceType().isPropertyTypeDeclared(propertyName);
        boolean superInterfaceHasProperty = false;
        boolean superInterfaceHasDeclaredProperty = false;
        if (ctorType.isInterface()) {
            for (ObjectType interfaceType : ctorType.getExtendedInterfaces()) {
                superInterfaceHasProperty = superInterfaceHasProperty || interfaceType.hasProperty(propertyName);
                superInterfaceHasDeclaredProperty = superInterfaceHasDeclaredProperty || interfaceType.isPropertyTypeDeclared(propertyName);
            }
        }
        boolean declaredOverride = info != null && info.isOverride();
        boolean foundInterfaceProperty = false;
        if (ctorType.isConstructor()) {
            for (JSType jSType : ctorType.getAllImplementedInterfaces()) {
                if (jSType.isUnknownType() || jSType.isEmptyType()) continue;
                FunctionType interfaceType = jSType.toObjectType().getConstructor();
                Preconditions.checkNotNull((Object)interfaceType);
                boolean interfaceHasProperty = interfaceType.getPrototype().hasProperty(propertyName);
                boolean bl2 = foundInterfaceProperty = foundInterfaceProperty || interfaceHasProperty;
                if (!this.reportMissingOverride.isOn() || declaredOverride || !interfaceHasProperty) continue;
                this.compiler.report(t.makeError(n, this.reportMissingOverride, HIDDEN_INTERFACE_PROPERTY, propertyName, interfaceType.getTopMostDefiningType(propertyName).toString()));
            }
        }
        if (!(declaredOverride || superClassHasProperty || superInterfaceHasProperty)) {
            return;
        }
        ObjectType topInstanceType = superClassHasDeclaredProperty ? superClass.getTopMostDefiningType(propertyName) : null;
        boolean bl3 = bl = ctorType.isConstructor() && (ctorType.getPrototype().hasOwnProperty(propertyName) || ctorType.getInstanceType().hasOwnProperty(propertyName));
        if (this.reportMissingOverride.isOn() && !declaredOverride && superClassHasDeclaredProperty && bl) {
            this.compiler.report(t.makeError(n, this.reportMissingOverride, HIDDEN_SUPERCLASS_PROPERTY, propertyName, topInstanceType.toString()));
        }
        if (superClassHasDeclaredProperty) {
            JSType superClassPropType = superClass.getInstanceType().getPropertyType(propertyName);
            if (!propertyType.isSubtype(superClassPropType)) {
                this.compiler.report(t.makeError(n, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, topInstanceType.toString(), superClassPropType.toString(), propertyType.toString()));
            }
        } else if (superInterfaceHasDeclaredProperty) {
            for (ObjectType interfaceType : ctorType.getExtendedInterfaces()) {
                JSType superPropertyType;
                if (!interfaceType.hasProperty(propertyName) || propertyType.isSubtype(superPropertyType = interfaceType.getPropertyType(propertyName))) continue;
                topInstanceType = interfaceType.getConstructor().getTopMostDefiningType(propertyName);
                this.compiler.report(t.makeError(n, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, topInstanceType.toString(), superPropertyType.toString(), propertyType.toString()));
            }
        } else if (!(foundInterfaceProperty || superClassHasProperty || superInterfaceHasProperty)) {
            this.compiler.report(t.makeError(n, UNKNOWN_OVERRIDE, propertyName, ctorType.getInstanceType().toString()));
        }
    }

    private static boolean hasUnknownOrEmptySupertype(FunctionType ctor) {
        Preconditions.checkArgument((ctor.isConstructor() || ctor.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((!ctor.isUnknownType() ? 1 : 0) != 0);
        ObjectType maybeSuperInstanceType;
        while ((maybeSuperInstanceType = ctor.getPrototype().getImplicitPrototype()) != null) {
            if (maybeSuperInstanceType.isUnknownType() || maybeSuperInstanceType.isEmptyType()) {
                return true;
            }
            ctor = maybeSuperInstanceType.getConstructor();
            if (ctor == null) {
                return false;
            }
            Preconditions.checkState((ctor.isConstructor() || ctor.isInterface() ? 1 : 0) != 0);
        }
        return false;
    }

    private void visitInterfaceGetprop(NodeTraversal t, Node assign, Node object, String property, Node lvalue, Node rvalue) {
        JSType rvalueType = this.getJSType(rvalue);
        String abstractMethodName = this.compiler.getCodingConvention().getAbstractMethodName();
        if (!rvalueType.isFunctionType()) {
            String abstractMethodMessage = abstractMethodName != null ? ", or " + abstractMethodName : "";
            this.compiler.report(t.makeError(object, INVALID_INTERFACE_MEMBER_DECLARATION, abstractMethodMessage));
        }
        if (assign.getLastChild().isFunction() && !NodeUtil.isEmptyBlock(assign.getLastChild().getLastChild())) {
            this.compiler.report(t.makeError(object, INTERFACE_FUNCTION_NOT_EMPTY, abstractMethodName));
        }
    }

    boolean visitName(NodeTraversal t, Node n, Node parent) {
        int parentNodeType = parent.getType();
        if (parentNodeType == 105 || parentNodeType == 120 || parentNodeType == 83 || parentNodeType == 118) {
            return false;
        }
        JSType type = n.getJSType();
        if (type == null) {
            JSType varType;
            type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            Scope.Var var = t.getScope().getVar(n.getString());
            if (var != null && (varType = var.getType()) != null) {
                type = varType;
            }
        }
        this.ensureTyped(t, n, type);
        return true;
    }

    private void visitGetProp(NodeTraversal t, Node n, Node parent) {
        Node property = n.getLastChild();
        Node objNode = n.getFirstChild();
        JSType childType = this.getJSType(objNode);
        if (childType.isDict()) {
            this.report(t, property, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "'.'", "dict");
        } else if (this.validator.expectNotNullOrUndefined(t, n, childType, "No properties on this expression", this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
            this.checkPropertyAccess(childType, property.getString(), t, n);
        }
        this.ensureTyped(t, n);
    }

    private void checkPropertyAccess(JSType childType, String propName, NodeTraversal t, Node n) {
        JSType propType = this.getJSType(n);
        if (propType.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
            ObjectType objectType = ObjectType.cast(childType = childType.autobox());
            if (objectType != null) {
                if (!objectType.hasProperty(propName) || objectType.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
                    if (objectType instanceof EnumType) {
                        this.report(t, n, INEXISTENT_ENUM_ELEMENT, propName);
                    } else {
                        this.checkPropertyAccessHelper(objectType, propName, t, n);
                    }
                }
            } else {
                this.checkPropertyAccessHelper(childType, propName, t, n);
            }
        }
    }

    private void checkPropertyAccessHelper(JSType objectType, String propName, NodeTraversal t, Node n) {
        if (!objectType.isEmptyType() && this.reportMissingProperties && !this.isPropertyTest(n) && !this.typeRegistry.canPropertyBeDefined(objectType, propName)) {
            this.report(t, n, INEXISTENT_PROPERTY, propName, this.validator.getReadableJSTypeName(n.getFirstChild(), true));
        }
    }

    private boolean isPropertyTest(Node getProp) {
        Node parent = getProp.getParent();
        switch (parent.getType()) {
            case 37: {
                return parent.getFirstChild() != getProp && this.compiler.getCodingConvention().isPropertyTestFunction(parent);
            }
            case 108: 
            case 113: 
            case 114: 
            case 115: {
                return NodeUtil.getConditionExpression(parent) == getProp;
            }
            case 32: 
            case 52: {
                return true;
            }
            case 98: 
            case 101: {
                return parent.getFirstChild() == getProp;
            }
            case 26: {
                return parent.getParent().isOr() && parent.getParent().getFirstChild() == parent;
            }
        }
        return false;
    }

    private void visitGetElem(NodeTraversal t, Node n) {
        this.validator.expectIndexMatch(t, n, this.getJSType(n.getFirstChild()), this.getJSType(n.getLastChild()));
        this.ensureTyped(t, n);
    }

    private void visitVar(NodeTraversal t, Node n) {
        JSDocInfo varInfo = n.hasOneChild() ? n.getJSDocInfo() : null;
        for (Node name : n.children()) {
            Node value = name.getFirstChild();
            Scope.Var var = t.getScope().getVar(name.getString());
            if (value == null) continue;
            JSType valueType = this.getJSType(value);
            JSType nameType = var.getType();
            nameType = nameType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : nameType;
            JSDocInfo info = name.getJSDocInfo();
            if (info == null) {
                info = varInfo;
            }
            this.checkEnumAlias(t, info, value);
            if (var.isTypeInferred()) {
                this.ensureTyped(t, name, valueType);
                continue;
            }
            this.validator.expectCanAssignTo(t, value, valueType, nameType, "initializing variable");
        }
    }

    private void visitNew(NodeTraversal t, Node n) {
        Node constructor = n.getFirstChild();
        JSType type = this.getJSType(constructor).restrictByNotNullOrUndefined();
        if (type.isConstructor() || type.isEmptyType() || type.isUnknownType()) {
            FunctionType fnType = type.toMaybeFunctionType();
            if (fnType != null) {
                this.visitParameterList(t, n, fnType);
                this.ensureTyped(t, n, fnType.getInstanceType());
            } else {
                this.ensureTyped(t, n);
            }
        } else {
            this.report(t, n, NOT_A_CONSTRUCTOR, new String[0]);
            this.ensureTyped(t, n);
        }
    }

    private void checkInterfaceConflictProperties(NodeTraversal t, Node n, String functionName, HashMap<String, ObjectType> properties, HashMap<String, ObjectType> currentProperties, ObjectType interfaceType) {
        Set<String> currentPropertyNames = interfaceType.getImplicitPrototype().getOwnPropertyNames();
        for (String name : currentPropertyNames) {
            ObjectType oType = properties.get(name);
            if (oType != null && !interfaceType.getPropertyType(name).isEquivalentTo(oType.getPropertyType(name))) {
                this.compiler.report(t.makeError(n, INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, functionName, name, oType.toString(), interfaceType.toString()));
            }
            currentProperties.put(name, interfaceType);
        }
        for (ObjectType iType : interfaceType.getCtorExtendedInterfaces()) {
            this.checkInterfaceConflictProperties(t, n, functionName, properties, currentProperties, iType);
        }
    }

    private void visitFunction(NodeTraversal t, Node n) {
        FunctionType functionType = JSType.toMaybeFunctionType(n.getJSType());
        String functionPrivateName = n.getFirstChild().getString();
        if (functionType.isConstructor()) {
            FunctionType baseConstructor = functionType.getSuperClassConstructor();
            if (baseConstructor != this.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE) && baseConstructor != null && baseConstructor.isInterface()) {
                this.compiler.report(t.makeError(n, CONFLICTING_EXTENDED_TYPE, "constructor", functionPrivateName));
            } else {
                if (baseConstructor != this.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE)) {
                    ObjectType proto = functionType.getPrototype();
                    if (functionType.makesStructs() && !proto.isStruct()) {
                        this.compiler.report(t.makeError(n, CONFLICTING_EXTENDED_TYPE, "struct", functionPrivateName));
                    } else if (functionType.makesDicts() && !proto.isDict()) {
                        this.compiler.report(t.makeError(n, CONFLICTING_EXTENDED_TYPE, "dict", functionPrivateName));
                    }
                }
                for (JSType jSType : functionType.getImplementedInterfaces()) {
                    boolean badImplementedType = false;
                    ObjectType baseInterfaceObj = ObjectType.cast(jSType);
                    if (baseInterfaceObj != null) {
                        FunctionType interfaceConstructor = baseInterfaceObj.getConstructor();
                        if (interfaceConstructor != null && !interfaceConstructor.isInterface()) {
                            badImplementedType = true;
                        }
                    } else {
                        badImplementedType = true;
                    }
                    if (!badImplementedType) continue;
                    this.report(t, n, BAD_IMPLEMENTED_TYPE, functionPrivateName);
                }
                this.validator.expectAllInterfaceProperties(t, n, functionType);
            }
        } else if (functionType.isInterface()) {
            for (ObjectType extInterface : functionType.getExtendedInterfaces()) {
                if (extInterface.getConstructor() == null || extInterface.getConstructor().isInterface()) continue;
                this.compiler.report(t.makeError(n, CONFLICTING_EXTENDED_TYPE, "interface", functionPrivateName));
            }
            if (functionType.getExtendedInterfacesCount() > 1) {
                HashMap<String, ObjectType> properties = new HashMap<String, ObjectType>();
                HashMap<String, ObjectType> currentProperties = new HashMap<String, ObjectType>();
                for (ObjectType interfaceType : functionType.getExtendedInterfaces()) {
                    currentProperties.clear();
                    this.checkInterfaceConflictProperties(t, n, functionPrivateName, properties, currentProperties, interfaceType);
                    properties.putAll(currentProperties);
                }
            }
        }
    }

    private void visitCall(NodeTraversal t, Node n) {
        Node child = n.getFirstChild();
        JSType childType = this.getJSType(child).restrictByNotNullOrUndefined();
        if (!childType.canBeCalled()) {
            this.report(t, n, NOT_CALLABLE, childType.toString());
            this.ensureTyped(t, n);
            return;
        }
        if (childType.isFunctionType()) {
            FunctionType functionType = childType.toMaybeFunctionType();
            boolean isExtern = false;
            JSDocInfo functionJSDocInfo = functionType.getJSDocInfo();
            if (functionJSDocInfo != null && functionJSDocInfo.getAssociatedNode() != null) {
                isExtern = functionJSDocInfo.getAssociatedNode().isFromExterns();
            }
            if (functionType.isConstructor() && !functionType.isNativeObjectType() && (functionType.getReturnType().isUnknownType() || functionType.getReturnType().isVoidType() || !isExtern)) {
                this.report(t, n, CONSTRUCTOR_NOT_CALLABLE, childType.toString());
            }
            if (!(!functionType.isOrdinaryFunction() || functionType.getTypeOfThis().isUnknownType() || functionType.getTypeOfThis().toObjectType() != null && functionType.getTypeOfThis().toObjectType().isNativeObjectType() || child.isGetElem() || child.isGetProp())) {
                this.report(t, n, EXPECTED_THIS_TYPE, functionType.toString());
            }
            this.visitParameterList(t, n, functionType);
            this.ensureTyped(t, n, functionType.getReturnType());
        } else {
            this.ensureTyped(t, n);
        }
    }

    private void visitParameterList(NodeTraversal t, Node call, FunctionType functionType) {
        Iterator<Node> arguments = call.children().iterator();
        arguments.next();
        Iterator<Node> parameters = functionType.getParameters().iterator();
        int ordinal = 0;
        Node parameter = null;
        Node argument = null;
        while (arguments.hasNext() && (parameters.hasNext() || parameter != null && parameter.isVarArgs())) {
            if (parameters.hasNext()) {
                parameter = parameters.next();
            }
            argument = arguments.next();
            this.validator.expectArgumentMatchesParameter(t, argument, this.getJSType(argument), this.getJSType(parameter), call, ++ordinal);
        }
        int numArgs = call.getChildCount() - 1;
        int minArgs = functionType.getMinArguments();
        int maxArgs = functionType.getMaxArguments();
        if (minArgs > numArgs || maxArgs < numArgs) {
            this.report(t, call, WRONG_ARGUMENT_COUNT, this.validator.getReadableJSTypeName(call.getFirstChild(), false), String.valueOf(numArgs), String.valueOf(minArgs), maxArgs != Integer.MAX_VALUE ? " and no more than " + maxArgs + " argument(s)" : "");
        }
    }

    private void visitReturn(NodeTraversal t, Node n) {
        JSType jsType = this.getJSType(t.getEnclosingFunction());
        if (jsType.isFunctionType()) {
            JSType actualReturnType;
            Node valueNode;
            FunctionType functionType = jsType.toMaybeFunctionType();
            JSType returnType = functionType.getReturnType();
            if (returnType == null) {
                returnType = this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            if ((valueNode = n.getFirstChild()) == null) {
                actualReturnType = this.getNativeType(JSTypeNative.VOID_TYPE);
                valueNode = n;
            } else {
                actualReturnType = this.getJSType(valueNode);
            }
            this.validator.expectCanAssignTo(t, valueNode, actualReturnType, returnType, "inconsistent return type");
        }
    }

    private void visitBinaryOperator(int op, NodeTraversal t, Node n) {
        Node left = n.getFirstChild();
        JSType leftType = this.getJSType(left);
        Node right = n.getLastChild();
        JSType rightType = this.getJSType(right);
        switch (op) {
            case 18: 
            case 19: 
            case 20: 
            case 90: 
            case 91: 
            case 92: {
                if (!leftType.matchesInt32Context()) {
                    this.report(t, left, BIT_OPERATION, NodeUtil.opToStr(n.getType()), leftType.toString());
                }
                if (rightType.matchesUint32Context()) break;
                this.report(t, right, BIT_OPERATION, NodeUtil.opToStr(n.getType()), rightType.toString());
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.validator.expectNumber(t, left, leftType, "left operand");
                this.validator.expectNumber(t, right, rightType, "right operand");
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 87: 
            case 88: 
            case 89: {
                this.validator.expectBitwiseable(t, left, leftType, "bad left operand to bitwise operator");
                this.validator.expectBitwiseable(t, right, rightType, "bad right operand to bitwise operator");
                break;
            }
            case 21: 
            case 93: {
                break;
            }
            default: {
                this.report(t, n, UNEXPECTED_TOKEN, Token.name(op));
            }
        }
        this.ensureTyped(t, n);
    }

    private void checkEnumAlias(NodeTraversal t, JSDocInfo declInfo, Node value) {
        if (declInfo == null || !declInfo.hasEnumParameterType()) {
            return;
        }
        JSType valueType = this.getJSType(value);
        if (!valueType.isEnumType()) {
            return;
        }
        EnumType valueEnumType = valueType.toMaybeEnumType();
        JSType valueEnumPrimitiveType = valueEnumType.getElementsType().getPrimitiveType();
        this.validator.expectCanAssignTo(t, value, valueEnumPrimitiveType, declInfo.getEnumParameterType().evaluate(t.getScope(), this.typeRegistry), "incompatible enum element types");
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private void ensureTyped(NodeTraversal t, Node n) {
        this.ensureTyped(t, n, this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
    }

    private void ensureTyped(NodeTraversal t, Node n, JSTypeNative type) {
        this.ensureTyped(t, n, this.getNativeType(type));
    }

    private void ensureTyped(NodeTraversal t, Node n, JSType type) {
        Preconditions.checkState((!n.isFunction() || type.isFunctionType() || type.isUnknownType() ? 1 : 0) != 0);
        JSDocInfo info = n.getJSDocInfo();
        if (info != null) {
            if (info.hasType()) {
                JSType infoType = info.getType().evaluate(t.getScope(), this.typeRegistry);
                this.validator.expectCanCast(t, n, infoType, type);
                type = infoType;
            }
            if (info.isImplicitCast() && !this.inExterns) {
                String propName = n.isGetProp() ? n.getLastChild().getString() : "(missing)";
                this.compiler.report(t.makeError(n, ILLEGAL_IMPLICIT_CAST, propName));
            }
        }
        if (n.getJSType() == null) {
            n.setJSType(type);
        }
    }

    double getTypedPercent() {
        int total = this.nullCount + this.unknownCount + this.typedCount;
        return total == 0 ? 0.0 : 100.0 * (double)this.typedCount / (double)total;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }
}

