/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class ClosureRewriteModule
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType INVALID_MODULE_IDENTIFIER = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_MODULE_IDENTIFIER", "Module idenifiers must be string literals");
    static final DiagnosticType INVALID_REQUIRE_IDENTIFIER = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_REQUIRE_IDENTIFIER", "goog.require parameter must be a string literal.");
    private final AbstractCompiler compiler;
    private ModuleDescription current = null;

    ClosureRewriteModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            if (!n.hasChildren() || !this.isGoogModuleCall(n.getFirstChild())) {
                return false;
            }
            this.enterModule();
        }
        return true;
    }

    private void enterModule() {
        this.current = new ModuleDescription();
    }

    private boolean isGoogModuleCall(Node n) {
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstChild().getFirstChild();
            return target.matchesQualifiedName("goog.module");
        }
        return false;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 37: {
                Node first = n.getFirstChild();
                if (first.matchesQualifiedName("goog.module")) {
                    this.recordAndUpdateModule(t, n);
                    break;
                }
                if (!first.matchesQualifiedName("goog.require")) break;
                this.recordAndUpdateRequire(t, n);
                break;
            }
            case 38: {
                if (!n.getString().equals("exports")) break;
                Node replacement = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.current.moduleNamespace);
                replacement.srcrefTree(n);
                parent.replaceChild(n, replacement);
                break;
            }
            case 132: {
                this.rewriteModuleAsScope(n);
            }
        }
    }

    private void recordAndUpdateModule(NodeTraversal t, Node call) {
        Node idNode = call.getLastChild();
        if (!idNode.isString()) {
            t.report(idNode, INVALID_MODULE_IDENTIFIER, new String[0]);
            return;
        }
        this.current.moduleNamespace = idNode.getString();
        this.current.moduleDecl = call;
        Node target = call.getFirstChild();
        target.getLastChild().setString("provide");
    }

    private void recordAndUpdateRequire(NodeTraversal t, Node call) {
        Node idNode = call.getLastChild();
        if (!idNode.isString()) {
            t.report(idNode, INVALID_REQUIRE_IDENTIFIER, new String[0]);
            return;
        }
        String namespace = idNode.getString();
        if (this.current.requireInsertNode == null) {
            this.current.requireInsertNode = this.getInsertRoot(call);
        }
        Node replacement = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), namespace).srcrefTree(call);
        call.getParent().replaceChild(call, replacement);
        Node require = IR.exprResult(call).srcref(call);
        Node insertAt = this.current.requireInsertNode;
        insertAt.getParent().addChildBefore(require, insertAt);
    }

    private void rewriteModuleAsScope(Node script) {
        Node srcref = this.current.moduleDecl != null ? this.current.moduleDecl : script;
        Node block = IR.block();
        Node scope = IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("scope")), IR.function(IR.name(""), IR.paramList(), block))).srcrefTree(srcref);
        Node fromNode = this.skipHeaderNodes(script);
        Preconditions.checkNotNull((Object)fromNode);
        this.moveChildrenAfter(fromNode, block);
        script.addChildAfter(scope, fromNode);
        this.compiler.reportCodeChange();
    }

    private Node skipHeaderNodes(Node script) {
        Node lastHeaderNode = null;
        for (Node child = script.getFirstChild(); child != null && this.isHeaderNode(child); child = child.getNext()) {
            lastHeaderNode = child;
        }
        return lastHeaderNode;
    }

    private boolean isHeaderNode(Node n) {
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstChild().getFirstChild();
            return target.matchesQualifiedName("goog.module") || target.matchesQualifiedName("goog.provide") || target.matchesQualifiedName("goog.require") || target.matchesQualifiedName("goog.setTestOnly");
        }
        return false;
    }

    private void moveChildrenAfter(Node fromNode, Node targetBlock) {
        Node parent = fromNode.getParent();
        while (fromNode.getNext() != null) {
            Node child = parent.removeChildAfter(fromNode);
            targetBlock.addChildToBack(child);
        }
    }

    private Node getInsertRoot(Node n) {
        while (!n.getParent().isScript()) {
            n = n.getParent();
        }
        return n;
    }

    private static class ModuleDescription {
        Node moduleDecl;
        String moduleNamespace = "";
        Node requireInsertNode = null;

        private ModuleDescription() {
        }
    }
}

