/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.javascript.jscomp.deps.DependencyInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class ClosureBundler {
    static void appendPrefix(Appendable out, DependencyInfo info) throws IOException {
        if (info.isModule()) {
            String moduleName = (String)Iterables.get(info.getProvides(), (int)0);
            out.append("goog.loadModule('" + moduleName + "', function(exports) {" + "'use strict';");
        }
    }

    static void appendPostfix(Appendable out, DependencyInfo info) throws IOException {
        if (info.isModule()) {
            out.append("\n;return exports;});\n");
        }
    }

    public static void appendInput(Appendable out, DependencyInfo info, File input, Charset inputCharset) throws IOException {
        ClosureBundler.appendPrefix(out, info);
        Files.copy((File)input, (Charset)inputCharset, (Appendable)out);
        ClosureBundler.appendPostfix(out, info);
    }

    public static void appendInput(Appendable out, DependencyInfo info, String contents) throws IOException {
        ClosureBundler.appendPrefix(out, info);
        out.append(contents);
        ClosureBundler.appendPostfix(out, info);
    }
}

