/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.javascript.jscomp.deps.DependencyInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SimpleDependencyInfo
implements DependencyInfo {
    private final List<String> provides;
    private final List<String> requires;
    private final boolean isModule;
    private final String srcPathRelativeToClosure;
    private final String pathOfDefiningFile;

    public SimpleDependencyInfo(String srcPathRelativeToClosure, String pathOfDefiningFile, List<String> provides, List<String> requires, boolean isModule) {
        this.srcPathRelativeToClosure = srcPathRelativeToClosure;
        this.pathOfDefiningFile = pathOfDefiningFile;
        this.provides = provides;
        this.requires = requires;
        this.isModule = isModule;
    }

    @Override
    public String getName() {
        return this.pathOfDefiningFile;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.srcPathRelativeToClosure;
    }

    @Override
    public boolean isModule() {
        return this.isModule;
    }

    @Override
    public Collection<String> getProvides() {
        return Collections.unmodifiableList(this.provides);
    }

    @Override
    public Collection<String> getRequires() {
        return Collections.unmodifiableList(this.requires);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleDependencyInfo)) {
            return false;
        }
        SimpleDependencyInfo other = (SimpleDependencyInfo)obj;
        return Objects.equals(other.srcPathRelativeToClosure, this.srcPathRelativeToClosure) && Objects.equals(other.pathOfDefiningFile, this.pathOfDefiningFile) && Objects.equals(other.requires, this.requires) && Objects.equals(other.provides, this.provides) && other.isModule == this.isModule;
    }

    public String toString() {
        return String.format("DependencyInfo(relativePath='%1$s', path='%2$s', provides=%3$s, requires=%4$s, module=%5$b)", this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.provides, this.requires, this.isModule);
    }

    public int hashCode() {
        return Objects.hash(this.provides, this.requires, this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.isModule);
    }
}

