/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.AssignableExprFuzzer;
import com.google.javascript.jscomp.fuzzing.Dispatcher;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Set;

class UnaryExprFuzzer
extends Dispatcher {
    UnaryExprFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected void initCandidates() {
        Operator[] operators = Operator.values();
        this.candidates = new UnaryExprGenerator[operators.length];
        for (int i = 0; i < operators.length; ++i) {
            this.candidates[i] = new UnaryExprGenerator(this.context, operators[i]);
        }
    }

    @Override
    protected String getConfigName() {
        return "unaryExpr";
    }

    private static enum Operator {
        VOID(122, false, Sets.newHashSet((Object[])new Type[]{Type.UNDEFINED})),
        TYPEOF(32, false, Sets.newHashSet((Object[])new Type[]{Type.STRING})),
        POS(28, false, Sets.newHashSet((Object[])new Type[]{Type.NUMBER})),
        NEG(29, false, Sets.newHashSet((Object[])new Type[]{Type.NUMBER})),
        BIT_NOT(27, false, Sets.newHashSet((Object[])new Type[]{Type.NUMBER})),
        NOT(26, false, Sets.newHashSet((Object[])new Type[]{Type.BOOLEAN})),
        INC(102, true, Sets.newHashSet((Object[])new Type[]{Type.NUMBER})),
        DEC(103, true, Sets.newHashSet((Object[])new Type[]{Type.NUMBER})),
        DEL_PROP(31, true, Sets.newHashSet((Object[])new Type[]{Type.BOOLEAN})),
        POST_INC(102, true, Sets.newHashSet((Object[])new Type[]{Type.NUMBER})),
        POST_DEC(103, true, Sets.newHashSet((Object[])new Type[]{Type.NUMBER}));

        int nodeType;
        boolean hasSideEffect;
        Set<Type> supportedTypes;

        private Operator(int nodeType, boolean hasSideEffect, Set<Type> supportedTypes) {
            this.nodeType = nodeType;
            this.hasSideEffect = hasSideEffect;
            this.supportedTypes = supportedTypes;
        }
    }

    private static class UnaryExprGenerator
    extends AbstractFuzzer {
        Operator operator;
        private AbstractFuzzer target;

        UnaryExprGenerator(FuzzingContext context, Operator operator) {
            super(context);
            this.operator = operator;
        }

        private AbstractFuzzer getTarget() {
            if (this.target == null) {
                this.target = this.operator.hasSideEffect ? new AssignableExprFuzzer(this.context) : new ExpressionFuzzer(this.context);
            }
            return this.target;
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            Node node = new Node(this.operator.nodeType, this.getTarget().generate(budget - 1));
            if (this.operator == Operator.POST_INC || this.operator == Operator.POST_DEC) {
                node.putBooleanProp(32, true);
            }
            return node;
        }

        @Override
        protected boolean isEnough(int budget) {
            if (budget < 1) {
                return false;
            }
            return this.getTarget().isEnough(budget - 1);
        }

        @Override
        protected String getConfigName() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.operator.name());
        }

        @Override
        protected Set<Type> supportedTypes() {
            return this.operator.supportedTypes;
        }
    }
}

