/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.InvocationsCallback;
import com.google.javascript.jscomp.MethodCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

class InlineSimpleMethods
extends MethodCompilerPass {
    private static final Logger logger = Logger.getLogger(InlineSimpleMethods.class.getName());
    static final MethodCompilerPass.SignatureStore DUMMY_SIGNATURE_STORE = new MethodCompilerPass.SignatureStore(){

        @Override
        public void addSignature(String functionName, Node functionNode, String sourceFile) {
        }

        @Override
        public void removeSignature(String functionName) {
        }

        @Override
        public void reset() {
        }
    };

    InlineSimpleMethods(AbstractCompiler compiler) {
        super(compiler);
    }

    @Override
    NodeTraversal.Callback getActingCallback() {
        return new InlineTrivialAccessors();
    }

    private static boolean isPropertyTree(Node expectedGetprop) {
        if (!expectedGetprop.isGetProp()) {
            return false;
        }
        Node leftChild = expectedGetprop.getFirstChild();
        if (!leftChild.isThis() && !InlineSimpleMethods.isPropertyTree(leftChild)) {
            return false;
        }
        Node retVal = leftChild.getNext();
        return NodeUtil.getStringValue(retVal) != null;
    }

    private static void replaceThis(Node expectedGetprop, Node replacement) {
        Node leftChild = expectedGetprop.getFirstChild();
        if (leftChild.isThis()) {
            expectedGetprop.replaceChild(leftChild, replacement);
        } else {
            InlineSimpleMethods.replaceThis(leftChild, replacement);
        }
    }

    private static Node returnedExpression(Node fn) {
        Node expectedBlock = InlineSimpleMethods.getMethodBlock(fn);
        if (!expectedBlock.hasOneChild()) {
            return null;
        }
        Node expectedReturn = expectedBlock.getFirstChild();
        if (!expectedReturn.isReturn()) {
            return null;
        }
        if (!expectedReturn.hasOneChild()) {
            return null;
        }
        return expectedReturn.getLastChild();
    }

    private static boolean isEmptyMethod(Node fn) {
        Node expectedBlock = InlineSimpleMethods.getMethodBlock(fn);
        return expectedBlock == null ? false : NodeUtil.isEmptyBlock(expectedBlock);
    }

    private static Node getMethodBlock(Node fn) {
        if (fn.getChildCount() != 3) {
            return null;
        }
        Node expectedBlock = fn.getLastChild();
        return expectedBlock.isBlock() ? expectedBlock : null;
    }

    private boolean allDefinitionsEquivalent(Collection<Node> definitions) {
        ArrayList<Node> list = new ArrayList<Node>();
        list.addAll(definitions);
        Node node0 = (Node)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (this.compiler.areNodesEqualForInlining((Node)list.get(i), node0)) continue;
            return false;
        }
        return true;
    }

    private void inlinePropertyReturn(Node parent, Node call, Node returnedValue) {
        Node getProp = returnedValue.cloneTree();
        InlineSimpleMethods.replaceThis(getProp, call.getFirstChild().removeFirstChild());
        parent.replaceChild(call, getProp);
        this.compiler.reportCodeChange();
    }

    private void inlineConstReturn(Node parent, Node call, Node returnedValue) {
        Node retValue = returnedValue.cloneTree();
        parent.replaceChild(call, retValue);
        this.compiler.reportCodeChange();
    }

    private void inlineEmptyMethod(Node parent, Node call) {
        if (NodeUtil.isExprCall(parent)) {
            parent.getParent().replaceChild(parent, IR.empty());
        } else {
            Node srcLocation = call;
            parent.replaceChild(call, NodeUtil.newUndefinedNode(srcLocation));
        }
        this.compiler.reportCodeChange();
    }

    private boolean argsMayHaveSideEffects(Node call) {
        for (Node currentChild = call.getFirstChild().getNext(); currentChild != null; currentChild = currentChild.getNext()) {
            if (!NodeUtil.mayHaveSideEffects(currentChild, this.compiler)) continue;
            return true;
        }
        return false;
    }

    @Override
    MethodCompilerPass.SignatureStore getSignatureStore() {
        return DUMMY_SIGNATURE_STORE;
    }

    private class InlineTrivialAccessors
    extends InvocationsCallback {
        private InlineTrivialAccessors() {
        }

        @Override
        void visit(NodeTraversal t, Node callNode, Node parent, String callName) {
            if (InlineSimpleMethods.this.externMethods.contains(callName) || InlineSimpleMethods.this.nonMethodProperties.contains(callName)) {
                return;
            }
            Collection definitions = InlineSimpleMethods.this.methodDefinitions.get((Object)callName);
            if (definitions == null || definitions.isEmpty()) {
                return;
            }
            Node firstDefinition = (Node)definitions.iterator().next();
            if (definitions.size() == 1 || InlineSimpleMethods.this.allDefinitionsEquivalent(definitions)) {
                if (!InlineSimpleMethods.this.argsMayHaveSideEffects(callNode)) {
                    Node returned = InlineSimpleMethods.returnedExpression(firstDefinition);
                    if (returned != null) {
                        if (InlineSimpleMethods.isPropertyTree(returned)) {
                            logger.fine("Inlining property accessor: " + callName);
                            InlineSimpleMethods.this.inlinePropertyReturn(parent, callNode, returned);
                        } else if (NodeUtil.isLiteralValue(returned, false) && !NodeUtil.mayHaveSideEffects(callNode.getFirstChild(), InlineSimpleMethods.this.compiler)) {
                            logger.fine("Inlining constant accessor: " + callName);
                            InlineSimpleMethods.this.inlineConstReturn(parent, callNode, returned);
                        }
                    } else if (InlineSimpleMethods.isEmptyMethod(firstDefinition) && !NodeUtil.mayHaveSideEffects(callNode.getFirstChild(), InlineSimpleMethods.this.compiler)) {
                        logger.fine("Inlining empty method: " + callName);
                        InlineSimpleMethods.this.inlineEmptyMethod(parent, callNode);
                    }
                }
            } else {
                logger.fine("Method '" + callName + "' has conflicting definitions.");
            }
        }
    }
}

